/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import open.dolphin.infomodel.DepartmentModel;
import open.dolphin.infomodel.FacilityModel;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.LicenseModel;
import open.dolphin.infomodel.RoleModel;
import open.dolphin.infomodel.UserLiteModel;
import open.dolphin.queries.DolphinQuery;

public class UserModel
extends InfoModel {
    private long id;
    private FacilityModel facility;
    private LicenseModel licenseModel;
    private DepartmentModel departmentModel;
    private Set<RoleModel> roles;
    private String userId;
    private String password;
    private String sirName;
    private String givenName;
    private String commonName;
    private String memberType;
    private String memo;
    private Date registeredDate;
    private String email;

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void initialize(String facilityId, String userId, String SirName, String GivenName, String password) {
        StringBuilder sb = new StringBuilder(facilityId);
        sb.append(":");
        sb.append(userId.trim());
        this.setUserId(sb.toString());
        this.setPassword(password);
        this.setSirName(SirName.trim());
        this.setGivenName(GivenName.trim());
        this.setCommonName(this.getSirName() + " " + this.getGivenName());
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String idAsLocal() {
        int index = this.userId.indexOf(":");
        return this.userId.substring(index + 1);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSirName(String sirName) {
        this.sirName = sirName;
    }

    public String getSirName() {
        return this.sirName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setLicenseModel(LicenseModel licenseValue) {
        this.licenseModel = licenseValue;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public void setFacility(FacilityModel facility) {
        this.facility = facility;
    }

    public FacilityModel getFacility() {
        return this.facility;
    }

    public void setDepartmentModel(DepartmentModel departmentValue) {
        this.departmentModel = departmentValue;
    }

    public DepartmentModel getDepartmentModel() {
        return this.departmentModel;
    }

    public void setRoles(Set<RoleModel> roles) {
        this.roles = roles;
    }

    public Set<RoleModel> getRoles() {
        return this.roles;
    }

    public void addRole(RoleModel value) {
        if (this.roles == null) {
            this.roles = new LinkedHashSet<RoleModel>(1);
        }
        this.roles.add(value);
    }

    public UserLiteModel getLiteModel() {
        UserLiteModel model = new UserLiteModel();
        model.setUserId(this.getUserId());
        model.setCommonName(this.getCommonName());
        LicenseModel lm = new LicenseModel();
        lm.setLicense(this.getLicenseModel().getLicense());
        lm.setLicenseDesc(this.getLicenseModel().getLicenseDesc());
        lm.setLicenseCodeSys(this.getLicenseModel().getLicenseCodeSys());
        model.setLicenseModel(lm);
        return model;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public String getMemberType() {
        return this.memberType;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setRegisteredDate(Date registeredDate) {
        this.registeredDate = registeredDate;
    }

    public Date getRegisteredDate() {
        return this.registeredDate;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserModel other = (UserModel)obj;
        return this.getId() == other.getId();
    }
}

