/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import open.dolphin.table.ObjectTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

public abstract class AbstractMasterPanel
extends JPanel {
    public static final String SELECTED_ITEM_PROP = "selectedItemProp";
    public static final String BUSY_PROP = "busyProp";
    public static final String ITEM_COUNT_PROP = "itemCount";
    protected static final String TOOLTIP_KEYWORD = "\u6f22\u5b57\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059";
    protected static final int KEYWORD_FIELD_LENGTH = 12;
    protected static final String FIND_ICON = "/open/dolphin/resources/images/srch_16.gif";
    protected static final String keywordBorderTitle = "\u30ad\u30fc\u30ef\u30fc\u30c9\u691c\u7d22";
    protected static final Color[] masterColors = GlobalConstants.getColorArray("masterSearch.masterColors");
    protected static final String[] masterNames = new String[]{"disease", "medicine", "medicine", "tool_material", "treatment"};
    protected static final String[] masterTabNames = new String[]{"\u50b7\u75c5\u540d", "\u5185\u7528\u30fb\u5916\u7528\u85ac", "\u6ce8\u5c04\u85ac", "\u7279\u5b9a\u5668\u6750", "\u8a3a\u7642\u884c\u70ba"};
    protected final int START_NUM_ROWS = 20;
    protected JTextField keywordField;
    protected ImageIcon findIcon = new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/srch_16.gif"));
    protected JLabel findLabel = new JLabel(this.findIcon);
    protected JRadioButton[] sortButtons;
    protected JTable table;
    protected ObjectTableModel tableModel;
    protected String master;
    protected String searchClass;
    protected String sortBy;
    protected String order;
    protected MasterItem selectedItem;
    protected boolean busy;
    protected int itemCount;
    protected Timer taskTimer;
    protected static final int TIMER_DELAY = 200;
    protected PropertyChangeSupport boundSupport;
    protected Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    protected JCheckBox isForwordCheckBox;

    public AbstractMasterPanel() {
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
    }

    public AbstractMasterPanel(String master) {
        this();
        this.master = master;
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.keywordField = new JTextField(12);
        this.keywordField.setToolTipText(TOOLTIP_KEYWORD);
        this.keywordField.setMaximumSize(this.keywordField.getPreferredSize());
        this.keywordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String key = AbstractMasterPanel.this.keywordField.getText().trim();
                if (!key.equals("")) {
                    AbstractMasterPanel.this.setSortBy("srycd asc, yukoedymd");
                    AbstractMasterPanel.this.order = "desc";
                    AbstractMasterPanel.this.search(key);
                }
            }
        });
        this.isForwordCheckBox = new JCheckBox("\u90e8\u5206\u4e00\u81f4");
        this.isForwordCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String key = AbstractMasterPanel.this.keywordField.getText().trim();
                if (!key.equals("")) {
                    AbstractMasterPanel.this.setSortBy("srycd asc, yukoedymd");
                    AbstractMasterPanel.this.order = "desc";
                    AbstractMasterPanel.this.search(key);
                }
            }
        });
        this.keywordField.addFocusListener(AutoKanjiListener.getInstance());
        this.initialize();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    protected abstract void initialize();

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    public void setSelectedItem(MasterItem item) {
        MasterItem oldItem = this.selectedItem;
        this.selectedItem = item;
        this.boundSupport.firePropertyChange(SELECTED_ITEM_PROP, oldItem, this.selectedItem);
    }

    public void setBusy(boolean newBusy) {
        boolean oldBusy = this.busy;
        this.busy = newBusy;
        this.boundSupport.firePropertyChange(BUSY_PROP, oldBusy, this.busy);
    }

    public void setItemCount(int count) {
        this.itemCount = count;
        this.boundSupport.firePropertyChange(ITEM_COUNT_PROP, -1, this.itemCount);
    }

    public void setSearchClass(String searchClass) {
        this.searchClass = searchClass;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    private String getMaster() {
        return this.master;
    }

    public void enter() {
        this.setItemCount(this.tableModel.getObjectCount());
        this.tableModel.clear();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractMasterPanel.this.keywordField.requestFocusInWindow();
            }
        });
    }

    public void dispose() {
        if (this.tableModel != null) {
            this.tableModel.clear();
        }
    }

    protected void search(String text) {
        this.search(text, !this.isForwordCheckBox.isSelected());
    }

    protected void search(String text, boolean startsWith) {
        String address = GlobalVariables.getClaimAddress();
        if (address == null || address.equals("")) {
            String msg0 = "\u30ec\u30bb\u30b3\u30f3\u306eIP\u30a2\u30c9\u30ec\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u30de\u30b9\u30bf\u30fc\u3092\u691c\u7d22\u3067\u304d\u307e\u305b\u3093\u3002";
            String msg1 = "\u74b0\u5883\u8a2d\u5b9a\u30e1\u30cb\u30e5\u30fc\u304b\u3089\u30ec\u30bb\u30b3\u30f3\u306eIP\u30a2\u30c9\u30ec\u30b9\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            String[] message = new String[]{msg0, msg1};
            Window parent = SwingUtilities.getWindowAncestor(this);
            String title = GlobalConstants.getFrameTitle(this.master);
            JOptionPane.showMessageDialog(parent, message, title, 2);
            return;
        }
        SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Application app = appCtx.getApplication();
        this.processResult(dao.isNoError(), dao.getByName(this.master, text, startsWith, this.searchClass, this.sortBy, this.order), dao.getErrorMessage());
    }

    protected void searchByCode(String text, boolean startsWith) {
        String address = GlobalVariables.getClaimAddress();
        if (address == null || address.equals("")) {
            String msg0 = "\u30ec\u30bb\u30b3\u30f3\u306eIP\u30a2\u30c9\u30ec\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u30de\u30b9\u30bf\u30fc\u3092\u691c\u7d22\u3067\u304d\u307e\u305b\u3093\u3002";
            String msg1 = "\u74b0\u5883\u8a2d\u5b9a\u30e1\u30cb\u30e5\u30fc\u304b\u3089\u30ec\u30bb\u30b3\u30f3\u306eIP\u30a2\u30c9\u30ec\u30b9\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            String[] message = new String[]{msg0, msg1};
            Window parent = SwingUtilities.getWindowAncestor(this);
            String title = GlobalConstants.getFrameTitle(this.master);
            JOptionPane.showMessageDialog(parent, message, title, 2);
            return;
        }
        SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
        this.processResult(dao.isNoError(), dao.getByName(this.master, text, startsWith, this.searchClass, this.sortBy, this.order), dao.getErrorMessage());
        this.keywordField.setText("");
    }

    protected void processResult(boolean noErr, Object result, String message) {
        if (noErr) {
            this.tableModel.setObjectList((List)result);
            this.setItemCount(this.tableModel.getObjectCount());
        } else {
            String title = GlobalConstants.getFrameTitle(this.master);
            JOptionPane.showMessageDialog(this, message, title, 2);
        }
    }

    public void clear() {
        this.tableModel.clear();
        this.keywordField.setText("");
    }

    protected class SortActionListener
    implements ActionListener {
        private AbstractMasterPanel target;
        private String sortBy;
        private int btnIndex;

        public SortActionListener(AbstractMasterPanel target, String sortBy, int btnIndex) {
            this.target = target;
            this.sortBy = sortBy;
            this.btnIndex = btnIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractMasterPanel.this.prefs.putInt("masterSearch." + this.target.getMaster() + ".sort", this.btnIndex);
            this.target.setSortBy(this.sortBy);
        }
    }
}

