/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.plugin.memopanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.CompositeArea;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.infomodel.PatientMemoModel;
import open.dolphin.project.GlobalVariables;

public class MemoPanel
extends JPanel
implements IChartDocument {
    public static final String TITLE = "\u30e1\u30e2";
    private CompositeArea memoArea;
    private PatientMemoModel patientMemoModel;
    private IChart parent;
    private String title = "\u30e1\u30e2";
    private JPanel btnPanel;
    private JScrollPane scrollPane;
    private JButton updateMemoBtn;

    private void initComponents() {
        this.btnPanel = new JPanel();
        this.updateMemoBtn = new JButton();
        this.scrollPane = new JScrollPane();
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(242, 86));
        this.setLayout(new BorderLayout());
        this.btnPanel.setName("btnPanel");
        this.btnPanel.setLayout(new BorderLayout());
        this.updateMemoBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/ref_16.gif")));
        this.updateMemoBtn.setToolTipText("\u66f4\u65b0");
        this.updateMemoBtn.setEnabled(false);
        this.updateMemoBtn.setMargin(new Insets(2, 2, 2, 2));
        this.updateMemoBtn.setName("updateMemoBtn");
        this.updateMemoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoPanel.this.updateMemoBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add((Component)this.updateMemoBtn, "Center");
        this.add((Component)this.btnPanel, "East");
        this.scrollPane.setName("scrollPane");
        this.add((Component)this.scrollPane, "Center");
    }

    private void updateMemoBtnActionPerformed(ActionEvent evt) {
        this.updateMemo();
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.Plugin;
    }

    public MemoPanel(IChart parent) {
        this.parent = parent;
        this.initComponents();
        this.initCustomComponents();
        this.update();
    }

    private void initCustomComponents() {
        this.memoArea = new CompositeArea(5, 10);
        this.memoArea.setLayout(new BorderLayout());
        this.memoArea.setLineWrap(true);
        this.memoArea.setMargin(new Insets(3, 3, 2, 2));
        this.memoArea.addFocusListener(AutoKanjiListener.getInstance());
        this.memoArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MemoPanel.this.updateCheck();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MemoPanel.this.updateCheck();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.scrollPane.setViewportView(this.memoArea);
    }

    private void update() {
        List list = this.getParentContext().getKarte().getEntryCollection("patientMemo");
        if (list != null && list.size() > 0) {
            this.patientMemoModel = (PatientMemoModel)list.get(0);
            this.memoArea.setText(this.patientMemoModel.getMemo());
            this.updateMemoBtn.setEnabled(false);
        }
    }

    public void updateMemo() {
        if (this.patientMemoModel == null) {
            this.patientMemoModel = new PatientMemoModel();
        }
        Date confirmed = new Date();
        this.patientMemoModel.setKarte(this.getParentContext().getKarte());
        this.patientMemoModel.setCreator(GlobalVariables.getUserModel());
        this.patientMemoModel.setConfirmed(confirmed);
        this.patientMemoModel.setRecorded(confirmed);
        this.patientMemoModel.setStarted(confirmed);
        this.patientMemoModel.setStatus("F");
        this.patientMemoModel.setMemo(this.memoArea.getText().trim());
        DBTask<Void> task = new DBTask<Void>(this.getParentContext()){

            @Override
            protected Void doInBackground() throws Exception {
                RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
                ddl.updatePatientMemo(MemoPanel.this.patientMemoModel);
                return null;
            }

            @Override
            protected void succeeded(Void result) {
                MemoPanel.this.updateMemoBtn.setEnabled(false);
            }
        };
        task.execute();
    }

    private void updateCheck() {
        if (this.memoArea.getText().trim().length() <= 255) {
            this.updateMemoBtn.setEnabled(true);
        } else {
            this.updateMemoBtn.setEnabled(false);
        }
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }
}

