/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.project;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.prefs.Preferences;
import javax.security.auth.Subject;
import open.dolphin.infomodel.UserModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.DolphinPrincipal;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.security.EncryptUtil;
import open.dolphin.utils.CombinedStringParser;

public class GlobalVariablesImplement
implements Serializable {
    private Preferences prefs = Preferences.userRoot().node("/open/dolphin/project");
    private DolphinPrincipal principal;
    private UserModel userModel;
    private Subject subject;
    private final String NODE_NAME = "/open/dolphin/project";
    private final String DEFAULT_PROJECT_NAME = "OpenDolphin";
    private final String DEFAULT_USER_ID;
    private final String DEFAULT_FACILITY_ID;
    private final String DEFAULT_DB_ADDRESS = "localhost";
    private final int JBOSS_J2EE_PORT = 1099;
    private final boolean DEFAULT_SEND_CLAIM = true;
    private final boolean DEFAULT_SEND_DIAGNOSIS = true;
    private final String DEFAULT_CLAIM_HOST_NAME = "\u65e5\u533b\u6a19\u6e96\u30ec\u30bb\u30d7\u30c8(ORCA)";
    private final String DEFAULT_CLAIM_ADDRESS;
    private final int DEFAULT_CLAIM_PORT = 8210;
    private final String DEFAULT_CLAIM_ENCODING = "UTF-8";
    private final boolean DEFAULT_USE_AS_PVTSERVER = true;
    private int DEFAULT_ORCA_CHARACTER_CODE = 0;
    private final boolean DEFAULT_SEND_MML = false;
    private final String DEFAULT_MML_VERSION = "2.3";
    private final String DEFAULT_MML_ENCODING = "UTF-8";
    private final String DEFAULT_SEND_MML_ADDRESS;
    private final String DEFAULT_SEND_MML_DIRECTORY;
    private final boolean DEFAULT_USE_PROXY = false;
    private final String DEFAULT_PROXY_HOST;
    private final int DEFAULT_PROXY_PORT = 8080;
    private final long DEFAULT_LAST_MODIFIED = 0L;
    private final String DEFAULT_DIRECTIONS = "\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057";

    public GlobalVariablesImplement() {
        this.DEFAULT_USER_ID = null;
        this.DEFAULT_FACILITY_ID = null;
        this.DEFAULT_CLAIM_ADDRESS = null;
        this.DEFAULT_SEND_MML_ADDRESS = null;
        this.DEFAULT_SEND_MML_DIRECTORY = null;
        this.DEFAULT_PROXY_HOST = null;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public boolean isValid() {
        if (this.getUserType().equals((Object)GlobalVariables.UserType.UNKNOWN)) {
            return false;
        }
        if (this.getUserId() == null || this.getFacilityId() == null) {
            return false;
        }
        return !this.getSendMML() || this.getUploaderIPAddress() != null && this.getUploadShareDirectory() != null;
    }

    public DolphinPrincipal getDolphinPrincipal() {
        return this.principal;
    }

    public void setDolphinPrincipal(DolphinPrincipal principal) {
        this.principal = principal;
    }

    public String getName() {
        return this.prefs.get("name", "OpenDolphin");
    }

    public void setName(String projectName) {
        this.prefs.put("name", projectName);
    }

    public UserModel getUserModel() {
        return this.userModel;
    }

    public void setUserModel(UserModel userModel) {
        this.userModel = userModel;
    }

    public String getUserId() {
        if (GlobalSettings.isTrial()) {
            return "dolphintrial";
        }
        return this.prefs.get("userId", this.DEFAULT_USER_ID);
    }

    public void setUserId(String val) {
        this.prefs.put("userId", val);
    }

    public String getFacilityId() {
        if (GlobalSettings.isTrial()) {
            return "1.3.6.1.4.1.9414.10.1";
        }
        return this.prefs.get("facilityId", this.DEFAULT_FACILITY_ID);
    }

    public void setFacilityId(String val) {
        this.prefs.put("facilityId", val);
    }

    public String getOrcaVersion() {
        if (GlobalSettings.isTrial()) {
            return "40";
        }
        return this.prefs.get("orcaVersion", "40");
    }

    public void setOrcaVersion(String version) {
        this.prefs.put("orcaVersion", version);
    }

    public String getJMARICode() {
        if (GlobalSettings.isTrial()) {
            return "JPN123456789101";
        }
        return this.prefs.get("jmariCode", "JPN000000000000");
    }

    public void setJMARICode(String jamriCode) {
        this.prefs.put("jmariCode", jamriCode);
    }

    public GlobalVariables.UserType getUserType() {
        if (GlobalSettings.isTrial()) {
            return GlobalVariables.UserType.FACILITY_USER;
        }
        String userType = this.prefs.get("userType", GlobalVariables.UserType.UNKNOWN.toString());
        return GlobalVariables.UserType.valueOf(userType);
    }

    public void setUserType(GlobalVariables.UserType userType) {
        this.prefs.put("userType", userType.toString());
    }

    public String getDbAddress() {
        if (GlobalSettings.isTrial()) {
            return "dolphin.good-day.co.jp";
        }
        return this.prefs.get("dbAddress", "localhost");
    }

    public void setDbAddress(String val) {
        this.prefs.put("dbAddress", val);
    }

    private byte[] getDbPassword() {
        if (GlobalSettings.isTrial()) {
            return EncryptUtil.encryptWithBlowfish("UQ6nRcOa");
        }
        return this.prefs.getByteArray("dbPassword", null);
    }

    public void setDbPassword(String pass) {
        if (pass.equals("")) {
            return;
        }
        this.prefs.putByteArray("dbPassword", EncryptUtil.encryptWithBlowfish(pass));
    }

    public String getDbPasswordWithoutHash() {
        if (GlobalSettings.isTrial()) {
            return "UQ6nRcOa";
        }
        byte[] encryptedPass = this.getDbPassword();
        if (encryptedPass == null) {
            return "";
        }
        return EncryptUtil.decodeWithBlowfish(encryptedPass);
    }

    public boolean getDbSSLState() {
        if (GlobalSettings.isTrial()) {
            return false;
        }
        return this.prefs.getBoolean("dbSSLState", false);
    }

    public void setDbSSLState(boolean state2) {
        this.prefs.putBoolean("dbSSLState", state2);
    }

    public int getHostPort() {
        if (GlobalSettings.isTrial()) {
            return 1099;
        }
        return this.prefs.getInt("hostPort", 1099);
    }

    public void setHostPort(int val) {
        this.prefs.putInt("hostPort", val);
    }

    public String getPDFStore() {
        String defaultStore = GlobalConstants.getPDFDirectory();
        return this.prefs.get("pdfStore", defaultStore);
    }

    public void setPDFStore(String pdfStore) {
        this.prefs.put("pdfStore", pdfStore);
    }

    public int getFetchKarteCount() {
        return this.prefs.getInt("docHistory.fetchCount", 1);
    }

    public void setFetchKarteCount(int cnt) {
        this.prefs.putInt("docHistory.fetchCount", cnt);
    }

    public boolean getScrollKarteV() {
        return this.prefs.getBoolean("karte.scroll.direction", true);
    }

    public void setScrollKarteV(boolean b) {
        this.prefs.putBoolean("karte.scroll.direction", b);
    }

    public boolean getAscendingKarte() {
        return this.prefs.getBoolean("docHistory.ascending", false);
    }

    public void setAscendingKarte(boolean b) {
        this.prefs.putBoolean("docHistory.ascending", b);
    }

    public int getKarteExtractionPeriod() {
        return this.prefs.getInt("docHistory.period", -12);
    }

    public void setKarteExtractionPeriod(int period) {
        this.prefs.putInt("docHistory.period", period);
    }

    public boolean getShowModifiedKarte() {
        return this.prefs.getBoolean("docHistory.showModified", false);
    }

    public void setShowModifiedKarte(boolean b) {
        this.prefs.putBoolean("docHistory.showModified", b);
    }

    public boolean getShowUnsendKarte() {
        return this.prefs.getBoolean("docHistory.showUnsend", false);
    }

    public void setShowUnsendKarte(boolean b) {
        this.prefs.putBoolean("docHistory.showUnsend", b);
    }

    public boolean getShowSendKarte() {
        return this.prefs.getBoolean("docHistory.showSend", false);
    }

    public void setShowSendKarte(boolean b) {
        this.prefs.putBoolean("docHistory.showSend", b);
    }

    public boolean getShowNewestKarte() {
        return this.prefs.getBoolean("docHistory.showNewest", false);
    }

    public void setShowNewestKarte(boolean b) {
        this.prefs.putBoolean("docHistory.showNewest", b);
    }

    public boolean getAscendingDiagnosis() {
        return this.prefs.getBoolean("diagnosis.ascending", false);
    }

    public void setAscendingDiagnosis(boolean b) {
        this.prefs.putBoolean("diagnosis.ascending", b);
    }

    public int getDiagnosisExtractionPeriod() {
        return this.prefs.getInt("diagnosis.period", 0);
    }

    public void setDiagnosisExtractionPeriod(int period) {
        this.prefs.putInt("diagnosis.period", period);
    }

    public void setCharacterCode(int code) {
        this.prefs.putInt("orcacharactercode", code);
    }

    public int getCharacterCode() {
        if (GlobalSettings.isTrial()) {
            return 0;
        }
        return this.prefs.getInt("orcacharactercode", this.DEFAULT_ORCA_CHARACTER_CODE);
    }

    public boolean isAutoOutcomeInput() {
        return this.prefs.getBoolean("autoOutcomeInput", false);
    }

    public void setAutoOutcomeInput(boolean b) {
        this.prefs.putBoolean("autoOutcomeInput", b);
    }

    public boolean isReplaceStamp() {
        return this.prefs.getBoolean("replaceStamp", false);
    }

    public void setReplaceStamp(boolean b) {
        this.prefs.putBoolean("replaceStamp", b);
    }

    public boolean isStampSpace() {
        return this.prefs.getBoolean("stampSpace", true);
    }

    public void setStampSpace(boolean b) {
        this.prefs.putBoolean("stampSpace", b);
    }

    public boolean isLaboFold() {
        return this.prefs.getBoolean("laboFold", true);
    }

    public void setLaboFold(boolean b) {
        this.prefs.putBoolean("laboFold", b);
    }

    public String getDefaultZyozaiNum() {
        return this.prefs.get("defaultZyozaiNum", "3");
    }

    public void setDefaultZyozaiNum(String defaultZyozaiNum) {
        this.prefs.put("defaultZyozaiNum", defaultZyozaiNum);
    }

    public String getDefaultMizuyakuNum() {
        return this.prefs.get("defaultMizuyakuNum", "1");
    }

    public void setDefaultMizuyakuNum(String defaultMizuyakuNum) {
        this.prefs.put("defaultMizuyakuNum", defaultMizuyakuNum);
    }

    public String getDefaultSanyakuNum() {
        return this.prefs.get("defaultSanyakuNum", "1.0");
    }

    public void setDefaultSanyakuNum(String defaultSanyakuNum) {
        this.prefs.put("defaultSanyakuNum", defaultSanyakuNum);
    }

    public String getDefaultRpNum() {
        return this.prefs.get("defaultRpNum", "3");
    }

    public void setDefaultRpNum(String defaultRpNum) {
        this.prefs.put("defaultRpNum", defaultRpNum);
    }

    public int getLaboTestExtractionPeriod() {
        return this.prefs.getInt("laboTest.period", -6);
    }

    public void setLaboTestExtractionPeriod(int period) {
        this.prefs.putInt("laboTest.period", period);
    }

    public boolean getConfirmAtNew() {
        return this.prefs.getBoolean("karte.showConfirmAtNew", true);
    }

    public void setConfirmAtNew(boolean b) {
        this.prefs.putBoolean("karte.showConfirmAtNew", b);
    }

    public int getCreateKarteMode() {
        return this.prefs.getInt("karte.createMode", 0);
    }

    public void setCreateKarteMode(int mode) {
        this.prefs.putInt("karte.createMode", mode);
    }

    public boolean getPlaceKarteMode() {
        return this.prefs.getBoolean("karte.placeMode", true);
    }

    public void setPlaceKarteMode(boolean mode) {
        this.prefs.putBoolean("karte.placeMode", mode);
    }

    public boolean getConfirmAtSave() {
        return this.prefs.getBoolean("karte.showConfirmAtSave", true);
    }

    public void setConfirmAtSave(boolean b) {
        this.prefs.putBoolean("karte.showConfirmAtSave", b);
    }

    public int getPrintKarteCount() {
        return this.prefs.getInt("karte.printCount", 0);
    }

    public void setPrintKarteCount(int cnt) {
        this.prefs.putInt("karte.printCount", cnt);
    }

    public int getSaveKarteMode() {
        return this.prefs.getInt("karte.saveAction", 0);
    }

    public void setSaveKarteMode(int mode) {
        this.prefs.putInt("karte.saveAction", mode);
    }

    public boolean getSendClaim() {
        return this.prefs.getBoolean("sendClaim", true);
    }

    public void setSendClaim(boolean b) {
        this.prefs.putBoolean("sendClaim", b);
    }

    public String getDefaultKarteTitle() {
        return this.prefs.get("defaultKarteTitle", "\u7d4c\u904e\u8a18\u9332");
    }

    public void setDefaultKarteTitle(String defaultKarteTitle) {
        this.prefs.put("defaultKarteTitle", defaultKarteTitle);
    }

    public boolean isUseTop15AsTitle() {
        return this.prefs.getBoolean("useTop15AsTitle", true);
    }

    public void setUseTop15AsTitle(boolean useTop15AsTitle) {
        this.prefs.putBoolean("useTop15AsTitle", useTop15AsTitle);
    }

    public boolean getSendDiagnosis() {
        return this.prefs.getBoolean("sendDiagnosis", true);
    }

    public void setSendDiagnosis(boolean b) {
        this.prefs.putBoolean("sendDiagnosis", b);
    }

    public String getClaimHostName() {
        if (GlobalSettings.isTrial()) {
            return "\u65e5\u533b\u6a19\u6e96\u30ec\u30bb\u30b3\u30f3(ORCA)";
        }
        return this.prefs.get("claimHostName", "\u65e5\u533b\u6a19\u6e96\u30ec\u30bb\u30d7\u30c8(ORCA)");
    }

    public void setClaimHostName(String b) {
        this.prefs.put("claimHostName", b);
    }

    public String getClaimEncoding() {
        return this.prefs.get("claimEncoding", "UTF-8");
    }

    public void setClaimEncoding(String val) {
        this.prefs.put("claimEncoding", val);
    }

    public String getClaimAddress() {
        if (GlobalSettings.isTrial()) {
            return "dolphin.good-day.co.jp";
        }
        return this.prefs.get("claimAddress", this.DEFAULT_CLAIM_ADDRESS);
    }

    public void setClaimAddress(String val) {
        this.prefs.put("claimAddress", val);
    }

    public int getClaimPort() {
        if (GlobalSettings.isTrial()) {
            return 10329;
        }
        return this.prefs.getInt("claimPort", 8210);
    }

    public void setClaimPort(int val) {
        this.prefs.putInt("claimPort", val);
    }

    public void setUseAsPVTServer(boolean b) {
        this.prefs.putBoolean("useAsPVTServer", b);
    }

    public boolean getUseAsPVTServer() {
        if (GlobalSettings.isTrial()) {
            return true;
        }
        return this.prefs.getBoolean("useAsPVTServer", true);
    }

    public boolean getIsHospital() {
        return this.prefs.getBoolean("isHospital", false);
    }

    public void setIsHospital(boolean val) {
        this.prefs.putBoolean("isHospital", val);
    }

    public String getLetterGreetings() {
        return this.prefs.get("greetings", "");
    }

    public void setLetterGreetings(String val) {
        this.prefs.put("greetings", val);
    }

    public boolean getJoinAreaNetwork() {
        return this.prefs.getBoolean("joinAreaNetwork", false);
    }

    public void setJoinAreaNetwork(boolean b) {
        this.prefs.putBoolean("joinAreaNetwork", b);
    }

    public String getAreaNetworkName() {
        return this.prefs.get("jareaNetworkName", null);
    }

    public void setAreaNetworkName(String name) {
        this.prefs.put("jareaNetworkName", name);
    }

    public String getAreaNetworkFacilityId() {
        return this.prefs.get("jareaNetworkFacilityId", null);
    }

    public void setAreaNetworkFacilityId(String id) {
        this.prefs.put("jareaNetworkFacilityId", id);
    }

    public String getAreaNetworkCreatorId() {
        return this.prefs.get("jareaNetworkCreatorId", null);
    }

    public void setAreaNetworkCreatorId(String id) {
        this.prefs.put("jareaNetworkCreatorId", id);
    }

    public boolean getSendMML() {
        return this.prefs.getBoolean("mml.send", false);
    }

    public void setSendMML(boolean b) {
        this.prefs.putBoolean("mml.send", b);
    }

    public String getMMLVersion() {
        return this.prefs.get("mml.version", "2.3");
    }

    public void setMMLVersion(String b) {
        this.prefs.put("mml.version", b);
    }

    public String getMMLEncoding() {
        return this.prefs.get("mml.encoding", "UTF-8");
    }

    public void setMMLEncoding(String val) {
        this.prefs.put("mml.encoding", val);
    }

    public boolean getMIMEEncoding() {
        return this.prefs.getBoolean("mimeEncoding", false);
    }

    public void setMIMEEncoding(boolean val) {
        this.prefs.putBoolean("mimeEncoding", val);
    }

    public String getUploaderIPAddress() {
        return this.prefs.get("mml.address", this.DEFAULT_SEND_MML_ADDRESS);
    }

    public void setUploaderIPAddress(String val) {
        this.prefs.put("mml.address", val);
    }

    public String getUploadShareDirectory() {
        return this.prefs.get("mml.directory", this.DEFAULT_SEND_MML_DIRECTORY);
    }

    public void setUploadShareDirectory(String val) {
        this.prefs.put("mml.directory", val);
    }

    public boolean getUseProxy() {
        return this.prefs.getBoolean("useProxy", false);
    }

    public void setUseProxy(boolean b) {
        this.prefs.putBoolean("useProxy", b);
    }

    public String getProxyHost() {
        return this.prefs.get("proxyHost", this.DEFAULT_PROXY_HOST);
    }

    public void setProxyHost(String val) {
        this.prefs.put("proxyHost", val);
    }

    public int getProxyPort() {
        return this.prefs.getInt("proxyPort", 8080);
    }

    public void setProxyPort(int val) {
        this.prefs.putInt("proxyPort", val);
    }

    public long getLastModify() {
        return this.prefs.getLong("lastModify", 0L);
    }

    public void setLastModify(long val) {
        this.prefs.putLong("lastModify", val);
    }

    public CombinedStringParser getDirections() {
        String line_string = this.prefs.get("karte.directions", "\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057");
        return new CombinedStringParser(',', line_string);
    }

    public void setDirections(CombinedStringParser lines) {
        this.prefs.put("karte.directions", lines.toCombinedString());
    }

    public String getDirection(int index) {
        String line_string = this.prefs.get("karte.directions", "\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057");
        CombinedStringParser line = new CombinedStringParser(',', line_string);
        return line.get(index);
    }

    public void setDirection(int index, String direction) {
        CombinedStringParser line = new CombinedStringParser(',', this.prefs.get("karte.directions", "\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057"));
        line.set(index, direction);
        this.prefs.put("karte.directions", line.toCombinedString());
    }

    public CombinedStringParser getCcDirections() {
        String line_string = this.prefs.get("karte.cc_directions", "\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057");
        return new CombinedStringParser(',', line_string);
    }

    public void setCcDirections(CombinedStringParser lines) {
        this.prefs.put("karte.cc_directions", lines.toCombinedString());
    }

    public String getCcDirection(int index) {
        String line_string = this.prefs.get("karte.cc_directions", "\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057");
        CombinedStringParser line = new CombinedStringParser(',', line_string);
        return line.get(index);
    }

    public void setCcDirection(int index, String direction) {
        CombinedStringParser line = new CombinedStringParser(',', this.prefs.get("karte.cc_directions", "\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057,\u306a\u3057"));
        line.set(index, direction);
        this.prefs.put("karte.cc_directions", line.toCombinedString());
    }

    public boolean getFepControl() {
        return this.prefs.getBoolean("karte.fep_control", true);
    }

    public void setFepControl(boolean value) {
        this.prefs.putBoolean("karte.fep_control", value);
    }

    public void exportSubtree(OutputStream os) {
        try {
            this.prefs.exportSubtree(os);
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    public void clear() {
        try {
            this.prefs.clear();
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getPreferencesPath() {
        return this.prefs.absolutePath();
    }
}

