/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.service.remote;

import java.util.List;
import open.dolphin.dto.PatientSearchSpec;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.log.LogWriter;
import open.dolphin.service.DolphinService;
import open.dolphin.service.IPatientService;
import open.dolphin.service.remote.PatientModelFinder;
import org.hibernate.HibernateException;

public class RemotePatientService
extends DolphinService
implements IPatientService {
    @Override
    public List<PatientModel> getPatients(PatientSearchSpec spec) {
        List<PatientModel> patients;
        block2: {
            this.roleAllowed("user");
            patients = null;
            try {
                this.startTransaction();
                PatientModelFinder finder = new PatientModelFinder(spec, this.getSession());
                patients = finder.find(this.getCallersFacilityId());
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return patients;
    }

    @Override
    public PatientModel getPatient(String patientId) {
        List<PatientModel> patients;
        block3: {
            this.roleAllowed("user");
            patients = null;
            try {
                this.startTransaction();
                String facilityId = this.getCallersFacilityId();
                PatientSearchSpec spec = new PatientSearchSpec();
                spec.setCode(1);
                spec.setPatientId(patientId);
                PatientModelFinder finder = new PatientModelFinder(spec, this.getSession());
                patients = finder.find(facilityId, true);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        if (patients == null) {
            return null;
        }
        return (PatientModel)patients.get(0);
    }

    @Override
    public long addPatient(PatientModel patient) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                String facilityId = this.getCallersFacilityId();
                patient.setFacilityId(facilityId);
                this.getSession().persist((Object)patient);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return patient.getId();
    }

    @Override
    public int update(PatientModel patient) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                this.getSession().merge((Object)patient);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return 1;
    }
}

