/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;

public class GUIDGenerator {
    private static String hexServerIP = null;
    private static final SecureRandom seeder = new SecureRandom();

    public static final String generate(Object o) {
        StringBuffer tmpBuffer = new StringBuffer(16);
        if (hexServerIP == null) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                System.err.println("KingAppoUtil: Could not get the local IP address using InetAddress.getLocalHost()!");
                uhe.printStackTrace();
                return null;
            }
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP = GUIDGenerator.hexFormat(GUIDGenerator.getInt(serverIP), 8);
        }
        String hashcode = GUIDGenerator.hexFormat(System.identityHashCode(o), 8);
        tmpBuffer.append(hexServerIP);
        tmpBuffer.append(hashcode);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = seeder.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(GUIDGenerator.hexFormat(timeLow, 8));
        guid.append(tmpBuffer.toString());
        guid.append(GUIDGenerator.hexFormat(node, 8));
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return GUIDGenerator.padHex(s, j) + s;
    }

    private static String padHex(String s, int i) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                tmpBuffer.append('0');
            }
        }
        return tmpBuffer.toString();
    }
}

