/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.utils;

import java.awt.Label;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import open.dolphin.project.GlobalSettings;
import open.dolphin.utils.IPAddressDocument;
import open.dolphin.utils.StringTool;
import org.jdesktop.application.ApplicationContext;

public class UserDirectoryInitializer {
    private static final String PREFERENCES_NAME = "/open/dolphin/project";
    private static final String INITIALIZED = "initialized";
    private static final String SSL_STATE = "dbSSLState";

    public static void run(ApplicationContext context) {
        File templatePath;
        File loginConfigPath;
        File securityPath;
        File userPath = context.getLocalStorage().getDirectory();
        if (!userPath.exists()) {
            userPath.mkdirs();
        }
        if (!userPath.canWrite()) {
            UserDirectoryInitializer.exitWithMessage("\u30e6\u30fc\u30b6\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u66f8\u304d\u8fbc\u307f\u53ef\u80fd\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + System.getProperty("line.separator") + userPath.getPath());
        }
        if (!(securityPath = new File(userPath, "security")).exists()) {
            securityPath.mkdir();
        }
        if (!(loginConfigPath = new File(securityPath, "dolphin.login.config")).exists()) {
            UserDirectoryInitializer.createLoginConfigFile(loginConfigPath);
        }
        if (!(templatePath = new File(userPath, "templates")).exists()) {
            templatePath.mkdir();
        }
        Preferences pref = Preferences.userRoot().node(PREFERENCES_NAME);
        if (!GlobalSettings.isTrial() && !pref.getBoolean(INITIALIZED, false)) {
            switch (JOptionPane.showConfirmDialog(null, "SSL\u901a\u4fe1\u3092\u884c\u3044\u307e\u3059\u304b\uff1f")) {
                case 0: {
                    File trustStorePath = new File(securityPath, "dolphin.trustStore");
                    if (trustStorePath.exists() || !UserDirectoryInitializer.fetchTrustStore(trustStorePath)) break;
                    pref.putBoolean(SSL_STATE, true);
                    pref.putBoolean(INITIALIZED, true);
                    break;
                }
                case 1: {
                    pref.putBoolean(INITIALIZED, true);
                    break;
                }
            }
        }
    }

    private static void createLoginConfigFile(File loginConfigPath) {
        try {
            BufferedWriter bufWriter = new BufferedWriter(new FileWriter(loginConfigPath));
            bufWriter.write(UserDirectoryInitializer.loginConfigFileContent());
            bufWriter.close();
        }
        catch (IOException ex) {
            UserDirectoryInitializer.exitWithMessage("\u30ed\u30b0\u30a4\u30f3\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + System.getProperty("line.separator") + ex.toString());
        }
        UserDirectoryInitializer.showMessage("\u30ed\u30b0\u30a4\u30f3\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u66f8\u304d\u8fbc\u307f\u307e\u3057\u305f");
    }

    private static String loginConfigFileContent() {
        return "openDolphin {" + System.getProperty("line.separator") + "  open.dolphin.security.DolphinLoginModule required;" + System.getProperty("line.separator") + "};" + System.getProperty("line.separator");
    }

    private static boolean isNoResultFromDialog(JOptionPane pane) {
        return pane.getValue() == null || (Integer)pane.getValue() == 2;
    }

    private static String askIpAdderss() {
        JTextField field;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        ArrayList<JTextField> fields = new ArrayList<JTextField>(4);
        for (int i = 0; i < 4; ++i) {
            field = new JTextField(3);
            field.setHorizontalAlignment(0);
            field.setDocument(new IPAddressDocument(field));
            fields.add(field);
        }
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            field = (JTextField)iterator.next();
            panel.add(field);
            if (!iterator.hasNext()) continue;
            panel.add(new Label("."));
        }
        JOptionPane pane = new JOptionPane(panel, 3, 2);
        JDialog dialog = pane.createDialog("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30b5\u30fc\u30d0\u306e IP \u30a2\u30c9\u30ec\u30b9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        if (UserDirectoryInitializer.isNoResultFromDialog(pane)) {
            return null;
        }
        StringBuilder ipAddress = new StringBuilder();
        Iterator iterator2 = fields.iterator();
        while (iterator2.hasNext()) {
            JTextField field2 = (JTextField)iterator2.next();
            String value = field2.getText();
            if (StringTool.isEmptyString(value)) continue;
            ipAddress.append(value);
            if (!iterator2.hasNext()) continue;
            ipAddress.append('.');
        }
        return ipAddress.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fetchTrustStore(File trustStorePath) {
        String ipAddress = UserDirectoryInitializer.askIpAdderss();
        if (!StringTool.isEmptyString(ipAddress)) {
            try {
                URL url = new URL("http://" + ipAddress + ":1026/cert");
                FileOutputStream foWriter = new FileOutputStream(trustStorePath);
                InputStream iStream = url.openStream();
                try {
                    int ch;
                    while ((ch = iStream.read()) != -1) {
                        foWriter.write(ch);
                    }
                }
                finally {
                    foWriter.close();
                }
            }
            catch (MalformedURLException ex) {
                UserDirectoryInitializer.exitWithMessage("\u4e0d\u6b63\u306a IP \u30a2\u30c9\u30ec\u30b9\u3067\u3059" + ex.toString());
                return false;
            }
            catch (IOException ex) {
                UserDirectoryInitializer.exitWithMessage("\u30ad\u30fc\u30b9\u30c8\u30a2\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff1a" + System.getProperty("line.separator") + ex.toString());
                return false;
            }
            UserDirectoryInitializer.showMessage("\u30ad\u30fc\u30b9\u30c8\u30a2\u3092\u53d6\u5f97\u3057\u307e\u3057\u305f");
            return true;
        }
        return false;
    }

    private static void showMessage(String message) {
        JOptionPane.showMessageDialog(null, message);
    }

    private static void exitWithMessage(String message) {
        UserDirectoryInitializer.showMessage(message);
    }
}

