/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import fr.apteryx.imageio.dicom.Attribute;
import fr.apteryx.imageio.dicom.DataElement;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DataSetReaderWriter;
import fr.apteryx.imageio.dicom.DateRange;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomWriter;
import fr.apteryx.imageio.dicom.FloatingDate;
import fr.apteryx.imageio.dicom.JPEGFilterOutputStream;
import fr.apteryx.imageio.dicom.PersonName;
import fr.apteryx.imageio.dicom.RawWriter;
import fr.apteryx.imageio.dicom.StreamPart;
import fr.apteryx.imageio.dicom.Tag;
import fr.apteryx.imageio.dicom.TransferSyntax;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;

class DataSetWriter
extends DataSetReaderWriter {
    private final ImageOutputStream os;
    private final TransferSyntax TS;
    private final DataSet ds;
    private final DicomWriter writer;
    private final boolean writeGroupLength;
    private static DecimalFormat dfe = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    private static DecimalFormat dff;
    private static final byte[] BYTE0;
    private static Hashtable writers;

    DataSetWriter(ImageOutputStream imageOutputStream, TransferSyntax transferSyntax, DataSet dataSet, boolean bl, DicomWriter dicomWriter, boolean bl2) {
        super(bl);
        this.os = imageOutputStream;
        this.TS = transferSyntax;
        this.ds = dataSet;
        this.writer = dicomWriter;
        this.writeGroupLength = bl2;
    }

    private void initByteOrder() {
        this.os.setByteOrder(this.TS.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    void write() throws DicomException, IOException {
        this.initByteOrder();
        this.ds.offset = this.os.getStreamPosition();
        Iterator iterator = this.ds.values().iterator();
        while (iterator.hasNext()) {
            this.write((DataElement)iterator.next());
        }
    }

    private static void appendValue(StringBuffer stringBuffer, Object object, int n, int n2, boolean bl) throws DicomException {
        String string;
        int n3;
        if (object == null) {
            return;
        }
        if (bl) {
            if (object instanceof Number) {
                n3 = ((Number)object).intValue();
            } else {
                try {
                    n3 = Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DicomException("ProtocoleViolation", "Value " + object + " is not an integer");
                }
            }
            string = Integer.toString(n3);
            if (string.length() > n2) {
                throw new DicomException("ProtocoleViolation", "Value " + string + " is too large");
            }
        } else if (object instanceof Number) {
            string = DataSetWriter.numToString((Number)object, n2);
        } else {
            string = object.toString();
            if (string.length() > n2) {
                string = string.substring(0, n2);
            }
        }
        stringBuffer.append(string);
        for (n3 = string.length(); n3 < n; ++n3) {
            stringBuffer.append(' ');
        }
    }

    private static String join(Object object, String string, int n, int n2, boolean bl) throws DicomException {
        if (Array.getLength(object) == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < Array.getLength(object); ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            Object object2 = Array.get(object, i);
            DataSetWriter.appendValue(stringBuffer, object2, n, n2, bl);
        }
        return new String(stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String numToString(Number number, int n) throws DicomException {
        String string;
        double d = number.doubleValue();
        if (d == 0.0) {
            return "0";
        }
        if (d >= 0.01 && d < 1000.0 || d <= -0.01 && d > -1000.0) {
            DecimalFormat decimalFormat = dff;
            synchronized (decimalFormat) {
                dff.setMaximumFractionDigits(0);
                string = dff.format(d);
                int n2 = string.length();
                if (n2 > n) {
                    throw new DicomException("ProtocoleViolation", "Value " + number + " is too large");
                }
                if (n2 < n - 1) {
                    dff.setMaximumFractionDigits(n - n2 - 1);
                    string = dff.format(d);
                }
            }
        }
        DecimalFormat decimalFormat = dfe;
        synchronized (decimalFormat) {
            dfe.setMaximumFractionDigits(0);
            string = dfe.format(d);
            int n3 = string.length();
            if (n3 > n) {
                throw new DicomException("ProtocoleViolation", "Value " + number + " is too large");
            }
            if (n3 < n - 1) {
                dfe.setMaximumFractionDigits(n - n3 - 1);
                string = dfe.format(d);
            }
        }
        return string;
    }

    private static String buildStringValue(Object object, int n, int n2, char c, boolean bl) throws DicomException {
        if (object == null) {
            return "";
        }
        if (object.getClass().isArray()) {
            String string = DataSetWriter.join(object, "\\", n, n2, bl);
            return (string.length() & 1) == 1 ? string + c : string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        DataSetWriter.appendValue(stringBuffer, object, n, n2, bl);
        if ((stringBuffer.length() & 1) == 1) {
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }

    private byte[] buildEncodedStringValue(Object object, int n, int n2, char c, boolean bl) throws DicomException {
        if (object == null) {
            return BYTE0;
        }
        try {
            byte[] byArray;
            if (object.getClass().isArray()) {
                String string = DataSetWriter.join(object, "\\", n, n2, bl);
                byArray = string.getBytes(this.enc);
                if ((byArray.length & 1) == 1) {
                    byArray = this.bytePad(byArray, c);
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                DataSetWriter.appendValue(stringBuffer, object, n, n2, bl);
                byArray = new String(stringBuffer).getBytes(this.enc);
                if ((byArray.length & 1) == 1) {
                    if (stringBuffer.length() == n2) {
                        stringBuffer.setLength(0);
                        DataSetWriter.appendValue(stringBuffer, object, n, n2 - 1, bl);
                        byArray = new String(stringBuffer).getBytes(this.enc);
                        if ((byArray.length & 1) == 0) {
                            return byArray;
                        }
                    }
                    byArray = this.bytePad(byArray, c);
                }
            }
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DicomException("Unsupported", "Character set '" + this.enc + "'");
        }
    }

    private byte[] bytePad(byte[] byArray, char c) throws UnsupportedEncodingException {
        byte[] byArray2 = new byte[byArray.length + 1];
        for (int i = byArray.length - 1; i >= 0; --i) {
            byArray2[i] = byArray[i];
        }
        byArray2[byArray.length] = Character.toString(c).getBytes(this.enc)[0];
        return byArray2;
    }

    private static int writeData(ImageOutputStream imageOutputStream, Object object, boolean bl, int n) throws IOException {
        if (object instanceof Collection) {
            int n2 = 0;
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                n2 += DataSetWriter.writeData(imageOutputStream, iterator.next(), bl, n);
            }
            return n2;
        }
        return RawWriter.writeRaw(imageOutputStream, (IIOImage)object, bl, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEncapsulatedImage(ImageOutputStream imageOutputStream, IIOImage iIOImage, ImageWriter imageWriter, ImageWriteParam imageWriteParam, boolean bl) throws IOException {
        DataSetWriter.writeTag(imageOutputStream, -73728);
        if (imageOutputStream instanceof FileImageOutputStream || imageOutputStream.isCached()) {
            long l = imageOutputStream.getStreamPosition();
            ByteOrder byteOrder = imageOutputStream.getByteOrder();
            imageOutputStream.writeInt(0);
            imageWriter.setOutput(bl ? new JPEGFilterOutputStream(imageOutputStream) : imageOutputStream);
            imageWriter.write(null, iIOImage, imageWriteParam);
            imageWriter.setOutput(null);
            imageOutputStream.setByteOrder(byteOrder);
            long l2 = imageOutputStream.getStreamPosition();
            if ((l2 - l & 1L) == 1L) {
                imageOutputStream.writeByte(0);
                ++l2;
            }
            imageOutputStream.seek(l);
            imageOutputStream.writeInt((int)(l2 - l - 4L));
            imageOutputStream.seek(l2);
        } else {
            File file = File.createTempFile("dcm", null);
            try {
                FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
                imageWriter.setOutput(bl ? new JPEGFilterOutputStream(fileImageOutputStream) : fileImageOutputStream);
                imageWriter.write(null, iIOImage, imageWriteParam);
                imageWriter.setOutput(null);
                int n = (int)fileImageOutputStream.getStreamPosition();
                if ((n & 1) == 1) {
                    fileImageOutputStream.writeByte(0);
                    ++n;
                }
                imageOutputStream.writeInt(n);
                fileImageOutputStream.seek(0L);
                byte[] byArray = new byte[1024];
                while (n > 0) {
                    int n2 = fileImageOutputStream.read(byArray);
                    imageOutputStream.write(byArray, 0, n2);
                    n -= n2;
                }
                fileImageOutputStream.close();
            }
            finally {
                file.delete();
            }
        }
    }

    private static void writeImageData(ImageOutputStream imageOutputStream, Object object, boolean bl, int n) throws DicomException, IOException {
        SampleModel sampleModel;
        Object object2;
        Object object3 = object;
        int n2 = 1;
        while (object3 instanceof Collection) {
            n2 *= ((Collection)object3).size();
            object3 = ((Collection)object3).iterator().next();
        }
        if (!(object3 instanceof IIOImage)) {
            throw new DicomException("ProtocoleViolation", "Invalid image data");
        }
        IIOImage iIOImage = (IIOImage)object3;
        if (iIOImage.hasRaster()) {
            object2 = iIOImage.getRaster();
            sampleModel = ((Raster)object2).getSampleModel();
            n2 *= ((Raster)object2).getHeight() * ((Raster)object2).getWidth() * (n > 0 ? 1 + (sampleModel.getNumBands() - 1) / (2 * n) : sampleModel.getNumBands());
        } else {
            object2 = iIOImage.getRenderedImage();
            sampleModel = object2.getSampleModel();
            n2 *= object2.getHeight() * object2.getWidth() * (n > 0 ? 1 + (sampleModel.getNumBands() - 1) / (2 * n) : sampleModel.getNumBands());
        }
        int n3 = sampleModel.getDataType();
        if (n3 == 2 || n3 == 1) {
            n2 *= 2;
        } else if (n3 != 0) {
            throw new DicomException("ProtocoleViolation", "Invalid pixel type");
        }
        imageOutputStream.writeInt((n2 & 1) == 1 ? n2 + 1 : n2);
        if (DataSetWriter.writeData(imageOutputStream, object, bl, n) != n2) {
            throw new DicomException("ProtocoleViolation", "Not consistent image size");
        }
        if ((n2 & 1) == 1) {
            imageOutputStream.write(0);
        }
    }

    private static void writeLen(DataSetWriter dataSetWriter, int n) throws IOException {
        if (dataSetWriter.TS.explicitVR) {
            dataSetWriter.os.writeShort(n);
        } else {
            dataSetWriter.os.writeInt(n);
        }
    }

    private void write(int n, String string, Object object) throws IOException, DicomException {
        if (string != null) {
            if (string.equals("up")) {
                string = "UL";
            } else if (string.equals("xs")) {
                string = this.ds.findInt(2621699) == 0 ? "US" : "SS";
            } else if (string.equals("ox")) {
                if ((n & 0xFF00FFFF) == 1342185484) {
                    string = this.ds.findInt(n & 0xFFFF0000 | 0x2002) == 0 ? "OW" : "OB";
                } else if (this.TS.explicitVR) {
                    string = n == 2145386512 ? (this.ds.findInt(2621696) <= 8 || this.TS.encapsulated ? "OB" : "OW") : "OW";
                } else if (n == 2145386512 || (n & 0xFF00FFFF) == 0x60003000 || n == 1409290256 || n >= 2626049 && n <= 2626051 || n >= 0x281221 && n <= 2626083) {
                    string = "OW";
                } else if ((n & 0xFF00FFFF) == 0x50003000) {
                    int n2 = this.ds.findInt(n & 0xFFFF0000 | 0x103);
                    switch (n2) {
                        case 1: {
                            string = "SS";
                            break;
                        }
                        case 2: {
                            string = "FL";
                            break;
                        }
                        case 3: {
                            string = "FD";
                            break;
                        }
                        case 4: {
                            string = "SL";
                            break;
                        }
                        default: {
                            string = "US";
                            break;
                        }
                    }
                } else {
                    string = "OB";
                }
            }
        }
        if (this.TS.explicitVR) {
            if (string == null) {
                throw new DicomException("Unsupported", "Unknown tag " + Tag.toString(n));
            }
            this.os.writeBytes(string);
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (this.TS.explicitVR) {
                if (string.equals("OB") || string.equals("UT") || string.equals("OW") || string.equals("OF") || string.equals("SQ") || string.equals("UN")) {
                    this.os.writeShort(0);
                    this.os.writeInt(byArray.length);
                } else {
                    this.os.writeShort(byArray.length);
                }
            } else {
                this.os.writeInt(byArray.length);
            }
            this.os.write(byArray);
            return;
        }
        if (n == 2145386512) {
            if (object instanceof StreamPart) {
                StreamPart streamPart = (StreamPart)object;
                if (this.TS.explicitVR) {
                    if (string.equals("OB") || string.equals("UT") || string.equals("OW") || string.equals("OF") || string.equals("SQ") || string.equals("UN")) {
                        this.os.writeShort(0);
                        this.os.writeInt((int)streamPart.l);
                    } else {
                        this.os.writeShort((int)streamPart.l);
                    }
                } else {
                    this.os.writeInt((int)streamPart.l);
                }
                streamPart.copy(this.os);
                return;
            }
            if (object instanceof StreamPart[]) {
                if (this.TS.explicitVR) {
                    this.os.writeShort(0);
                }
                this.os.writeInt(-1);
                StreamPart[] streamPartArray = (StreamPart[])object;
                for (int i = 0; i < streamPartArray.length; ++i) {
                    DataSetWriter.writeTag(this.os, -73728);
                    this.os.writeInt((int)streamPartArray[i].l);
                    streamPartArray[i].copy(this.os);
                }
                DataSetWriter.writeTag(this.os, -73507);
                this.os.writeInt(0);
                return;
            }
            if (object instanceof byte[][]) {
                if (this.TS.explicitVR) {
                    this.os.writeShort(0);
                }
                this.os.writeInt(-1);
                byte[][] byArray = (byte[][])object;
                for (int i = 0; i < byArray.length; ++i) {
                    DataSetWriter.writeTag(this.os, -73728);
                    this.os.writeInt(byArray[i].length);
                    this.os.write(byArray[i]);
                }
                DataSetWriter.writeTag(this.os, -73507);
                this.os.writeInt(0);
                return;
            }
        }
        if (n == 524293) {
            if (object == null) {
                if (this.writer != null) {
                    this.writer.wl.warning("ProtocoleViolation", "Attribute SpecificCharacterSet cannot be null");
                }
            } else {
                this.enc = (String)CHARSETS_DICOM_JAVA.get(object);
                if (this.enc == null) {
                    throw new DicomException("Unsupported", "Character set '" + object + "'");
                }
            }
        }
        if (string == null) {
            throw new DicomException("Unsupported", "Unknown tag " + Tag.toString(n));
        }
        ValueWriter valueWriter = (ValueWriter)writers.get(string);
        if (valueWriter == null) {
            throw new DicomException("ProtocoleViolation", "Unknown VR '" + string + "'");
        }
        valueWriter.write(this, n, object);
    }

    private static void writeTag(ImageOutputStream imageOutputStream, int n) throws IOException {
        imageOutputStream.writeShort(Tag.getGroupNumber(n));
        imageOutputStream.writeShort(Tag.getElementNumber(n));
    }

    private void write(DataElement dataElement) throws DicomException, IOException {
        if ((dataElement.tag & 0xFFFF) == 0 && !this.writeGroupLength) {
            return;
        }
        DataSetWriter.writeTag(this.os, dataElement.tag);
        Attribute attribute = dataElement.getAttribute();
        this.write(dataElement.tag, attribute == null ? null : attribute.VR, dataElement.value);
    }

    static {
        dfe.applyPattern("0.#E0");
        dff = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        dff.applyPattern("#.#");
        BYTE0 = new byte[0];
        writers = new Hashtable();
        writers.put("AE", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                String string = DataSetWriter.buildStringValue(object, 0, 16, ' ', false);
                DataSetWriter.writeLen(dataSetWriter, string.length());
                dataSetWriter.os.writeBytes(string);
            }
        });
        writers.put("AS", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                String string = DataSetWriter.buildStringValue(object, 4, 4, ' ', false);
                DataSetWriter.writeLen(dataSetWriter, string.length());
                dataSetWriter.os.writeBytes(string);
            }
        });
        writers.put("AT", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (object == null) {
                    DataSetWriter.writeLen(dataSetWriter, 0);
                } else if (object instanceof Integer) {
                    DataSetWriter.writeLen(dataSetWriter, 4);
                    DataSetWriter.writeTag(dataSetWriter.os, (Integer)object);
                } else if (object.getClass().isArray()) {
                    DataSetWriter.writeLen(dataSetWriter, 4 * Array.getLength(object));
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        Object object2 = Array.get(object, i);
                        if (!(object2 instanceof Number)) {
                            throw new DicomException("ProtocoleViolation", "Incorrect value type for AT VR");
                        }
                        DataSetWriter.writeTag(dataSetWriter.os, ((Number)object2).intValue());
                    }
                } else {
                    throw new DicomException("ProtocoleViolation", "Incorrect value type for VR AT");
                }
            }
        });
        writers.put("CS", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                String string = DataSetWriter.buildStringValue(object, 0, 16, ' ', false);
                DataSetWriter.writeLen(dataSetWriter, string.length());
                dataSetWriter.os.writeBytes(string);
            }
        });
        writers.put("DA", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (object == null) {
                    DataSetWriter.writeLen(dataSetWriter, 0);
                } else if (object instanceof Date) {
                    String string = dataSetWriter.formats.dicom3DA.format((Date)object);
                    DataSetWriter.writeLen(dataSetWriter, 8);
                    dataSetWriter.os.writeBytes(string);
                } else if (object instanceof Date[]) {
                    Date[] dateArray = (Date[])object;
                    if (dateArray.length == 0) {
                        DataSetWriter.writeLen(dataSetWriter, 0);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer(dataSetWriter.formats.dicom3DA.format(dateArray[0]));
                        for (int i = 1; i < dateArray.length; ++i) {
                            stringBuffer.append("\\");
                            stringBuffer.append(dataSetWriter.formats.dicom3DA.format(dateArray[i]));
                        }
                        if ((stringBuffer.length() & 1) == 1) {
                            stringBuffer.append(' ');
                        }
                        DataSetWriter.writeLen(dataSetWriter, stringBuffer.length());
                        dataSetWriter.os.writeBytes(new String(stringBuffer));
                    }
                } else if (dataSetWriter.isFind) {
                    if (object instanceof DateRange) {
                        String string = ((DateRange)object).format(dataSetWriter.formats.dicom3DA);
                        DataSetWriter.writeLen(dataSetWriter, string.length());
                        dataSetWriter.os.writeBytes(string);
                    } else {
                        String string = DataSetWriter.buildStringValue(object, 0, 256, ' ', false);
                        DataSetWriter.writeLen(dataSetWriter, string.length());
                        dataSetWriter.os.writeBytes(string);
                    }
                } else {
                    throw new DicomException("ProtocoleViolation", "Incorrect value type for VR DA");
                }
            }
        });
        writers.put("DS", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                String string = DataSetWriter.buildStringValue(object, 0, 16, ' ', false);
                DataSetWriter.writeLen(dataSetWriter, string.length());
                dataSetWriter.os.writeBytes(string);
            }
        });
        writers.put("DT", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (object == null) {
                    DataSetWriter.writeLen(dataSetWriter, 0);
                } else if (object instanceof Date) {
                    String string = dataSetWriter.formats.formatDT((Date)object);
                    if ((string.length() & 1) == 1) {
                        string = string + ' ';
                    }
                    DataSetWriter.writeLen(dataSetWriter, string.length());
                    dataSetWriter.os.writeBytes(string);
                } else if (object instanceof Date[]) {
                    Date[] dateArray = (Date[])object;
                    if (dateArray.length == 0) {
                        DataSetWriter.writeLen(dataSetWriter, 0);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer(dataSetWriter.formats.formatDT(dateArray[0]));
                        for (int i = 1; i < dateArray.length; ++i) {
                            stringBuffer.append("\\");
                            stringBuffer.append(dataSetWriter.formats.formatDT(dateArray[i]));
                        }
                        if ((stringBuffer.length() & 1) == 1) {
                            stringBuffer.append(' ');
                        }
                        DataSetWriter.writeLen(dataSetWriter, stringBuffer.length());
                        dataSetWriter.os.writeBytes(new String(stringBuffer));
                    }
                } else if (dataSetWriter.isFind) {
                    if (object instanceof DateRange) {
                        DateRange dateRange;
                        String string = dateRange.format((dateRange = (DateRange)object).getDate1() instanceof FloatingDate ? dataSetWriter.formats.DTWriteFloating : dataSetWriter.formats.DTWrite);
                        DataSetWriter.writeLen(dataSetWriter, string.length());
                        dataSetWriter.os.writeBytes(string);
                    } else {
                        String string = DataSetWriter.buildStringValue(object, 0, 256, ' ', false);
                        DataSetWriter.writeLen(dataSetWriter, string.length());
                        dataSetWriter.os.writeBytes(string);
                    }
                } else {
                    throw new DicomException("ProtocoleViolation", "Incorrect value type for VR DT");
                }
            }
        });
        writers.put("FL", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (object == null) {
                    DataSetWriter.writeLen(dataSetWriter, 0);
                } else if (object instanceof Number) {
                    DataSetWriter.writeLen(dataSetWriter, 4);
                    dataSetWriter.os.writeFloat(((Number)object).floatValue());
                } else if (object.getClass().isArray()) {
                    DataSetWriter.writeLen(dataSetWriter, 4 * Array.getLength(object));
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        Object object2 = Array.get(object, i);
                        if (!(object2 instanceof Number)) {
                            throw new DicomException("ProtocoleViolation", "Incorrect value type for FL VR");
                        }
                        dataSetWriter.os.writeFloat(((Number)object2).floatValue());
                    }
                } else {
                    throw new DicomException("ProtocoleViolation", "Incorrect value type for FL VR");
                }
            }
        });
        writers.put("FD", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (object == null) {
                    DataSetWriter.writeLen(dataSetWriter, 0);
                } else if (object instanceof Number) {
                    DataSetWriter.writeLen(dataSetWriter, 8);
                    dataSetWriter.os.writeDouble(((Number)object).doubleValue());
                } else if (object.getClass().isArray()) {
                    DataSetWriter.writeLen(dataSetWriter, 8 * Array.getLength(object));
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        Object object2 = Array.get(object, i);
                        if (!(object2 instanceof Number)) {
                            throw new DicomException("ProtocoleViolation", "Incorrect value type for FD VR");
                        }
                        dataSetWriter.os.writeDouble(((Number)object2).doubleValue());
                    }
                } else {
                    throw new DicomException("ProtocoleViolation", "Incorrect value type for VR FD");
                }
            }
        });
        writers.put("IS", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                String string = DataSetWriter.buildStringValue(object, 0, 12, ' ', true);
                DataSetWriter.writeLen(dataSetWriter, string.length());
                dataSetWriter.os.writeBytes(string);
            }
        });
        writers.put("LO", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                byte[] byArray = dataSetWriter.buildEncodedStringValue(object, 0, 64, ' ', false);
                DataSetWriter.writeLen(dataSetWriter, byArray.length);
                dataSetWriter.os.write(byArray);
            }
        });
        writers.put("LT", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                byte[] byArray = dataSetWriter.buildEncodedStringValue(object, 0, 10240, ' ', false);
                DataSetWriter.writeLen(dataSetWriter, byArray.length);
                dataSetWriter.os.write(byArray);
            }
        });
        ValueWriter valueWriter = new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (((DataSetWriter)dataSetWriter).TS.explicitVR) {
                    dataSetWriter.os.writeShort(0);
                }
                if (object == null) {
                    dataSetWriter.os.writeInt(0);
                } else if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    if ((byArray.length & 1) == 1) {
                        dataSetWriter.os.writeInt(byArray.length + 1);
                        dataSetWriter.os.write(byArray);
                        dataSetWriter.os.write(0);
                    } else {
                        dataSetWriter.os.writeInt(byArray.length);
                        dataSetWriter.os.write(byArray);
                    }
                } else if (object instanceof short[]) {
                    short[] sArray = (short[])object;
                    dataSetWriter.os.writeInt(sArray.length * 2);
                    for (int i = 0; i < sArray.length; ++i) {
                        dataSetWriter.os.writeShort(sArray[i]);
                    }
                } else if (object instanceof Collection || object instanceof IIOImage) {
                    if (((DataSetWriter)dataSetWriter).TS.encapsulated) {
                        Object object2;
                        ImageWriter imageWriter = dataSetWriter.TS.getWriter();
                        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                        imageWriteParam.setCompressionMode(2);
                        boolean bl = false;
                        if (dataSetWriter.TS == TransferSyntax.JPEG_BASELINE_1) {
                            imageWriteParam.setCompressionType("JPEG");
                            imageWriteParam.setCompressionQuality(dataSetWriter.writer.getJPEGQuality());
                            bl = true;
                        } else if (dataSetWriter.TS == TransferSyntax.JPEG_LOSSLESS_14SV1) {
                            imageWriteParam.setCompressionType("JPEG-LOSSLESS");
                            bl = true;
                        } else if (dataSetWriter.TS == TransferSyntax.JPEG_LS_LOSSLESS) {
                            imageWriteParam.setCompressionType("JPEG-LS");
                            bl = true;
                        } else if (dataSetWriter.TS == TransferSyntax.JPEG2000_LOSSLESS || dataSetWriter.TS == TransferSyntax.JPEG2000) {
                            object2 = (J2KImageWriteParam)imageWriteParam;
                            object2.setComponentTransformation(true);
                            object2.setWriteCodeStreamOnly(true);
                            if (dataSetWriter.TS == TransferSyntax.JPEG2000_LOSSLESS) {
                                object2.setEncodingRate(Double.MAX_VALUE);
                                object2.setLossless(true);
                                object2.setFilter("w5x3");
                            } else {
                                object2.setLossless(false);
                                object2.setFilter("w9x7");
                                object2.setEncodingRate(dataSetWriter.writer.getJPEG2000EncodingRate());
                            }
                        }
                        dataSetWriter.os.writeInt(-1);
                        DataSetWriter.writeTag(dataSetWriter.os, -73728);
                        if (object instanceof Collection) {
                            object2 = (Collection)object;
                            long[] lArray = new long[object2.size()];
                            dataSetWriter.os.writeInt(lArray.length * 4);
                            long l = dataSetWriter.os.getStreamPosition();
                            dataSetWriter.os.skipBytes(lArray.length * 4);
                            int n2 = 0;
                            Iterator iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                lArray[n2++] = dataSetWriter.os.getStreamPosition();
                                DataSetWriter.writeEncapsulatedImage(dataSetWriter.os, (IIOImage)iterator.next(), imageWriter, imageWriteParam, bl);
                            }
                            long l2 = dataSetWriter.os.getStreamPosition();
                            dataSetWriter.os.seek(l);
                            for (n2 = 0; n2 < lArray.length; ++n2) {
                                dataSetWriter.os.writeInt((int)(lArray[n2] - lArray[0]));
                            }
                            dataSetWriter.os.seek(l2);
                        } else {
                            dataSetWriter.os.writeInt(0);
                            DataSetWriter.writeEncapsulatedImage(dataSetWriter.os, (IIOImage)object, imageWriter, imageWriteParam, bl);
                        }
                        imageWriter.dispose();
                        DataSetWriter.writeTag(dataSetWriter.os, -73507);
                        dataSetWriter.os.writeInt(0);
                    } else {
                        String string = dataSetWriter.ds.findString(2621444);
                        int n3 = 0;
                        if (string != null) {
                            if (string.endsWith("_422")) {
                                n3 = 1;
                            } else if (string.endsWith("_420")) {
                                n3 = 2;
                            }
                        }
                        DataSetWriter.writeImageData(dataSetWriter.os, object, dataSetWriter.ds.findInt(0x280002) == 1 || dataSetWriter.ds.findInt(2621446) != 0, n3);
                    }
                } else {
                    throw new DicomException("ProtocoleViolation", "Incorrect value for VR Ox (" + object.getClass() + ")");
                }
            }
        };
        writers.put("OB", valueWriter);
        writers.put("OW", valueWriter);
        writers.put("OF", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (((DataSetWriter)dataSetWriter).TS.explicitVR) {
                    dataSetWriter.os.writeShort(0);
                }
                if (object == null) {
                    dataSetWriter.os.writeInt(0);
                } else if (object instanceof float[]) {
                    float[] fArray = (float[])object;
                    dataSetWriter.os.writeInt(fArray.length * 4);
                    for (int i = 0; i < fArray.length; ++i) {
                        dataSetWriter.os.writeFloat(fArray[i]);
                    }
                } else {
                    throw new DicomException("ProtocoleViolation", "Incorrect value for VR OF (" + object.getClass() + ")");
                }
            }
        });
        writers.put("PN", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (object == null) {
                    DataSetWriter.writeLen(dataSetWriter, 0);
                } else {
                    Object object2;
                    Object object3;
                    if (object instanceof PersonName) {
                        object3 = new StringBuffer();
                        ((PersonName)object).encode((StringBuffer)object3);
                        object2 = object3;
                    } else if (object instanceof PersonName[]) {
                        object3 = new StringBuffer();
                        PersonName[] personNameArray = (PersonName[])object;
                        for (int i = 0; i < personNameArray.length; ++i) {
                            if (i > 0) {
                                ((StringBuffer)object3).append("\\");
                            }
                            personNameArray[i].encode((StringBuffer)object3);
                        }
                        object2 = object3;
                    } else {
                        object2 = object;
                    }
                    object3 = dataSetWriter.buildEncodedStringValue(object2, 0, 64, ' ', false);
                    DataSetWriter.writeLen(dataSetWriter, ((Object)object3).length);
                    dataSetWriter.os.write((byte[])object3);
                }
            }
        });
        writers.put("SH", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                byte[] byArray = dataSetWriter.buildEncodedStringValue(object, 0, 16, ' ', false);
                DataSetWriter.writeLen(dataSetWriter, byArray.length);
                dataSetWriter.os.write(byArray);
            }
        });
        writers.put("SQ", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object arrayList) throws IOException, DicomException {
                if (((DataSetWriter)dataSetWriter).TS.explicitVR) {
                    dataSetWriter.os.writeShort(0);
                }
                if (arrayList == null) {
                    dataSetWriter.os.writeInt(0);
                } else {
                    Object object;
                    if (arrayList instanceof DataSet) {
                        object = arrayList;
                        arrayList = new ArrayList(1);
                        arrayList.add(object);
                    } else if (!(arrayList instanceof Collection)) {
                        throw new DicomException("ProtocoleViolation", "Incorrect value type for VR SQ");
                    }
                    dataSetWriter.os.writeInt(-1);
                    object = ((Collection)arrayList).iterator();
                    while (object.hasNext()) {
                        DataSetWriter.writeTag(dataSetWriter.os, -73728);
                        dataSetWriter.os.writeInt(-1);
                        Object e = object.next();
                        if (!(e instanceof DataSet)) {
                            throw new DicomException("ProtocoleViolation", "Incorrect value type for VR SQ");
                        }
                        ((DataSet)e).write(dataSetWriter.os, dataSetWriter.TS, dataSetWriter.isFind, dataSetWriter.writer, dataSetWriter.writeGroupLength);
                        DataSetWriter.writeTag(dataSetWriter.os, -73715);
                        dataSetWriter.os.writeInt(0);
                    }
                    DataSetWriter.writeTag(dataSetWriter.os, -73507);
                    dataSetWriter.os.writeInt(0);
                }
            }
        });
        writers.put("ST", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                byte[] byArray = dataSetWriter.buildEncodedStringValue(object, 0, 1024, ' ', false);
                DataSetWriter.writeLen(dataSetWriter, byArray.length);
                dataSetWriter.os.write(byArray);
            }
        });
        writers.put("TM", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (object == null) {
                    DataSetWriter.writeLen(dataSetWriter, 0);
                } else if (object instanceof Date) {
                    String string = dataSetWriter.formats.dicom3TM.format((Date)object);
                    DataSetWriter.writeLen(dataSetWriter, 10);
                    dataSetWriter.os.writeBytes(string);
                } else if (object instanceof Date[]) {
                    Date[] dateArray = (Date[])object;
                    if (dateArray.length == 0) {
                        DataSetWriter.writeLen(dataSetWriter, 0);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer(dataSetWriter.formats.dicom3TM.format(dateArray[0]));
                        for (int i = 1; i < dateArray.length; ++i) {
                            stringBuffer.append("\\");
                            stringBuffer.append(dataSetWriter.formats.dicom3TM.format(dateArray[i]));
                        }
                        if ((stringBuffer.length() & 1) == 1) {
                            stringBuffer.append(' ');
                        }
                        DataSetWriter.writeLen(dataSetWriter, stringBuffer.length());
                        dataSetWriter.os.writeBytes(new String(stringBuffer));
                    }
                } else if (dataSetWriter.isFind) {
                    if (object instanceof DateRange) {
                        String string = ((DateRange)object).format(dataSetWriter.formats.dicom3TM);
                        DataSetWriter.writeLen(dataSetWriter, string.length());
                        dataSetWriter.os.writeBytes(string);
                    } else {
                        String string = DataSetWriter.buildStringValue(object, 0, 256, ' ', false);
                        DataSetWriter.writeLen(dataSetWriter, string.length());
                        dataSetWriter.os.writeBytes(string);
                    }
                } else {
                    throw new DicomException("ProtocoleViolation", "Incorrect value type for VR TM");
                }
            }
        });
        writers.put("UI", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                String string = DataSetWriter.buildStringValue(object, 0, 64, '\u0000', false);
                DataSetWriter.writeLen(dataSetWriter, string.length());
                dataSetWriter.os.writeBytes(string);
            }
        });
        valueWriter = new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (object == null) {
                    DataSetWriter.writeLen(dataSetWriter, 0);
                } else if (object instanceof Number) {
                    DataSetWriter.writeLen(dataSetWriter, 4);
                    dataSetWriter.os.writeInt(((Number)object).intValue());
                } else if (object.getClass().isArray()) {
                    DataSetWriter.writeLen(dataSetWriter, 4 * Array.getLength(object));
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        Object object2 = Array.get(object, i);
                        if (!(object2 instanceof Number)) {
                            throw new DicomException("ProtocoleViolation", "Incorrect value type for long VR");
                        }
                        dataSetWriter.os.writeInt(((Number)object2).intValue());
                    }
                } else {
                    throw new DicomException("ProtocoleViolation", "Incorrect value type for integer VR");
                }
            }
        };
        writers.put("UL", valueWriter);
        writers.put("SL", valueWriter);
        writers.put("UN", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (((DataSetWriter)dataSetWriter).TS.explicitVR) {
                    dataSetWriter.os.writeShort(0);
                }
                dataSetWriter.os.writeInt(0);
            }
        });
        valueWriter = new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (object == null) {
                    DataSetWriter.writeLen(dataSetWriter, 0);
                } else if (object instanceof Number) {
                    DataSetWriter.writeLen(dataSetWriter, 2);
                    dataSetWriter.os.writeShort(((Number)object).intValue());
                } else if (object.getClass().isArray()) {
                    DataSetWriter.writeLen(dataSetWriter, 2 * Array.getLength(object));
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        Object object2 = Array.get(object, i);
                        if (!(object2 instanceof Number)) {
                            throw new DicomException("ProtocoleViolation", "Incorrect value type for short VR");
                        }
                        dataSetWriter.os.writeShort(((Number)object2).shortValue());
                    }
                } else {
                    throw new DicomException("ProtocoleViolation", "Incorrect value type for short VR");
                }
            }
        };
        writers.put("US", valueWriter);
        writers.put("SS", valueWriter);
        writers.put("UT", new ValueWriter(){

            public void write(DataSetWriter dataSetWriter, int n, Object object) throws IOException, DicomException {
                if (((DataSetWriter)dataSetWriter).TS.explicitVR) {
                    dataSetWriter.os.writeShort(0);
                }
                if (object == null) {
                    dataSetWriter.os.writeInt(0);
                } else if ("ISO-8859-1".equals(dataSetWriter.enc)) {
                    String string = object.toString();
                    if ((string.length() & 1) == 1) {
                        dataSetWriter.os.writeInt(string.length() + 1);
                        dataSetWriter.os.writeBytes(string);
                        dataSetWriter.os.write(32);
                    } else {
                        dataSetWriter.os.writeInt(string.length());
                        dataSetWriter.os.writeBytes(string);
                    }
                } else {
                    byte[] byArray = dataSetWriter.buildEncodedStringValue(object, 0, Integer.MAX_VALUE, ' ', false);
                    dataSetWriter.os.writeInt(byArray.length);
                    dataSetWriter.os.write(byArray);
                }
            }
        });
    }

    static interface ValueWriter {
        public void write(DataSetWriter var1, int var2, Object var3) throws DicomException, IOException;
    }
}

