/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.DicomWriter;
import fr.apteryx.imageio.dicom.PeerAE;
import fr.apteryx.imageio.dicom.QueryRetrieveSCP;
import fr.apteryx.imageio.dicom.StorageSCU;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public final class DicomWriterSpi
extends ImageWriterSpi {
    public DicomWriterSpi() {
        this.vendorName = "Apteryx";
        this.version = "1.10";
        this.names = new String[]{"dicom"};
        this.MIMETypes = new String[]{"application/dicom"};
        this.nativeStreamMetadataFormatClassName = "DicomStreamMetadataFormat";
        this.nativeStreamMetadataFormatName = "fr_apteryx_imageio_dicom_1.0";
        this.pluginClassName = "fr.apteryx.imageio.dicom.DicomWriter";
        this.suffixes = new String[]{"dcm"};
        this.supportsStandardStreamMetadataFormat = true;
        this.outputTypes = new Class[]{ImageOutputStream.class, StorageSCU.class, PeerAE.class, QueryRetrieveSCP.Operation.class};
        this.readerSpiNames = new String[]{"fr.apteryx.imageio.dicom.DicomReaderSpi"};
    }

    public String getDescription(Locale locale) {
        return "DICOM V3.0 writer";
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        int n = sampleModel.getNumBands();
        if (n != 1 && n != 3 && n != 4) {
            return false;
        }
        n = sampleModel.getDataType();
        return n == 0 || n == 2 || n == 1;
    }

    public ImageWriter createWriterInstance(Object object) {
        return new DicomWriter(this);
    }
}

