/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.Attribute;
import fr.apteryx.imageio.dicom.Tag;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Dictionary {
    private static Hashtable dico;
    private static Vector groups;

    private static void put(int n, Attribute attribute) {
        dico.put(new Integer(n), attribute);
    }

    public static void learn(int n, String string, String string2) {
        Attribute attribute = new Attribute();
        attribute.tag = n;
        attribute.VR = string;
        attribute.name = string2;
        Dictionary.put(n, attribute);
    }

    public static boolean contains(int n) {
        return Dictionary.contains(new Integer(n));
    }

    public static boolean contains(Integer n) {
        return dico.containsKey(n);
    }

    static Attribute getAttribute(int n) {
        Attribute attribute = (Attribute)dico.get(new Integer(n));
        if (attribute != null) {
            return attribute;
        }
        int n2 = Tag.getGroupNumber(n);
        int n3 = Tag.getElementNumber(n);
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            RepeatingGroup repeatingGroup = (RepeatingGroup)iterator.next();
            if (repeatingGroup.gtype == 1 && n2 % 2 == 0) continue;
            if (repeatingGroup.gtype == 2 && n2 % 2 == 1) continue;
            if (repeatingGroup.etype == 1 && n3 % 2 == 0) continue;
            if (repeatingGroup.etype == 2 && n3 % 2 == 1 || n2 < repeatingGroup.group1 || n2 > repeatingGroup.group2 || n3 < repeatingGroup.element1 || n3 > repeatingGroup.element2) continue;
            return repeatingGroup.attribute;
        }
        return null;
    }

    static {
        Object object;
        groups = new Vector();
        InputStream inputStream = Dictionary.class.getResourceAsStream("dicom.dic.ser");
        if (inputStream != null) {
            try {
                object = new ObjectInputStream(inputStream);
                dico = (Hashtable)((ObjectInputStream)object).readObject();
                groups = (Vector)((ObjectInputStream)object).readObject();
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (dico == null) {
            System.err.println("Cannot read serialized dicom dictionary");
            object = Dictionary.class.getResource("dicom.dic");
            dico = new Hashtable();
            try {
                InputStream inputStream2 = ((URL)object).openStream();
                new Tokenizer(inputStream2).parse();
                inputStream2.close();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(((URL)object).getPath() + ".ser"));
                objectOutputStream.writeObject(dico);
                objectOutputStream.writeObject(groups);
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        }
    }

    static class Tokenizer
    extends StreamTokenizer {
        Tokenizer(InputStream inputStream) {
            super(new InputStreamReader(inputStream));
            this.resetSyntax();
            this.eolIsSignificant(true);
            this.wordChars(97, 122);
            this.wordChars(65, 90);
            this.wordChars(160, 255);
            this.whitespaceChars(32, 32);
            this.whitespaceChars(9, 9);
            this.wordChars(48, 57);
            this.commentChar(35);
        }

        void error(String string) {
            System.err.println(this.lineno() + ": " + string);
            System.exit(1);
        }

        void parse() throws IOException {
            while (this.nextToken() != -1) {
                RepeatingGroup repeatingGroup = null;
                if (this.ttype == 10 || this.ttype == 13) continue;
                if (this.ttype != 40) {
                    this.error("Expected (");
                }
                this.nextToken();
                if (this.ttype != -3) {
                    this.error("Group number expected");
                }
                int n = Integer.parseInt(this.sval, 16);
                this.nextToken();
                if (this.ttype == 45) {
                    repeatingGroup = new RepeatingGroup();
                    repeatingGroup.group1 = n;
                    this.nextToken();
                    if (this.ttype != -3) {
                        this.error("u, o or group number expected");
                    }
                    if (this.sval.length() == 1) {
                        if (this.sval.equals("u")) {
                            repeatingGroup.gtype = 0;
                        } else if (this.sval.equals("o")) {
                            repeatingGroup.gtype = 1;
                        } else {
                            this.error("u or o expected");
                        }
                        this.nextToken();
                        if (this.ttype != 45) {
                            this.error("- expected");
                        }
                        this.nextToken();
                        if (this.ttype != -3) {
                            this.error("Group number expected");
                        }
                    }
                    repeatingGroup.group2 = Integer.parseInt(this.sval, 16);
                    this.nextToken();
                }
                if (this.ttype != 44) {
                    this.error(", expected");
                }
                this.nextToken();
                if (this.ttype != -3) {
                    this.error("Element number expected");
                }
                int n2 = Integer.parseInt(this.sval, 16);
                this.nextToken();
                if (this.ttype == 45) {
                    if (repeatingGroup == null) {
                        repeatingGroup = new RepeatingGroup();
                        repeatingGroup.group1 = repeatingGroup.group2 = n;
                        repeatingGroup.gtype = 0;
                    }
                    repeatingGroup.element1 = n2;
                    this.nextToken();
                    if (this.ttype != -3) {
                        this.error("u, o or element number expected");
                    }
                    if (this.sval.length() == 1) {
                        if (this.sval.equals("u")) {
                            repeatingGroup.etype = 0;
                        } else if (this.sval.equals("o")) {
                            repeatingGroup.etype = 1;
                        } else {
                            this.error("u or o expected");
                        }
                        this.nextToken();
                        if (this.ttype != 45) {
                            this.error("- expected");
                        }
                        this.nextToken();
                        if (this.ttype != -3) {
                            this.error("Element number expected");
                        }
                    }
                    repeatingGroup.element2 = Integer.parseInt(this.sval, 16);
                    this.nextToken();
                } else if (repeatingGroup != null) {
                    repeatingGroup.element1 = repeatingGroup.element2 = n2;
                    repeatingGroup.etype = 0;
                }
                if (this.ttype != 41) {
                    this.error(") expected");
                }
                Attribute attribute = new Attribute();
                this.nextToken();
                if (this.ttype != -3) {
                    this.error("VR expected");
                }
                if (this.sval.length() != 2) {
                    this.error("VR is not 2 character long");
                }
                attribute.VR = this.sval;
                this.nextToken();
                if (this.ttype != -3) {
                    this.error("Name expected");
                }
                attribute.name = this.sval;
                while (this.nextToken() != 10 && this.ttype != 13) {
                }
                if (repeatingGroup != null) {
                    repeatingGroup.attribute = attribute;
                    continue;
                }
                Dictionary.put(Tag.create(n, n2), attribute);
            }
        }
    }

    static final class RepeatingGroup
    implements Serializable {
        static final int ODD = 1;
        static final int EVEN = 2;
        static final int ALL = 0;
        int group1;
        int group2;
        int element1;
        int element2;
        int gtype = 2;
        int etype = 2;
        Attribute attribute;

        RepeatingGroup() {
            groups.add(this);
        }
    }
}

