/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

class JPEGFilterOutputStream
extends ImageOutputStreamImpl {
    private int APP0len;
    private boolean APP0present;
    ImageOutputStream os;
    private byte[] header = new byte[6];
    private final byte[] buf1 = new byte[1];

    JPEGFilterOutputStream(ImageOutputStream imageOutputStream) {
        this.os = imageOutputStream;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 0) {
            return;
        }
        int n4 = n + n2;
        if (this.streamPos < 6L) {
            for (n3 = n; n3 < n + n2 && this.streamPos < 6L; ++n3) {
                this.header[(int)this.streamPos] = byArray[n3];
                ++this.streamPos;
            }
            if (this.streamPos < 6L) {
                return;
            }
            if (this.header[0] != -1 || this.header[1] != -40) {
                throw new IOException("JPEG stream being written does not start with SOI");
            }
            if (this.header[2] != -1 || this.header[3] != -32) {
                this.os.write(this.header, 0, 6);
                this.APP0present = false;
            } else {
                this.APP0len = (this.header[4] & 0xFF) << 8 | this.header[5] & 0xFF;
                this.os.write(this.header, 0, 2);
                this.APP0present = true;
            }
        }
        if (this.APP0present) {
            if (this.streamPos >= (long)(this.APP0len + 4)) {
                this.os.write(byArray, n3, n4 - n3);
            } else if (this.streamPos + (long)n4 - (long)n3 > (long)(this.APP0len + 4)) {
                int n5 = (int)((long)n3 + ((long)(this.APP0len + 4) - this.streamPos));
                this.os.write(byArray, n5, n4 - n5);
            }
        } else {
            this.os.write(byArray, n3, n4 - n3);
        }
        this.streamPos += (long)(n4 - n3);
    }

    public void write(int n) throws IOException {
        this.buf1[0] = (byte)n;
        this.write(this.buf1, 0, 1);
    }

    public void seek(long l) {
        throw new Error("Unsupported seek");
    }

    public int read(byte[] byArray, int n, int n2) {
        throw new Error("Unsupported read");
    }

    public int read() {
        throw new Error("Unsupported read");
    }
}

