/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import fr.apteryx.imageio.dicom.Cloner;
import fr.apteryx.imageio.dicom.Constants;
import fr.apteryx.imageio.dicom.DataElement;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.Day;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomObject;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.Modality;
import fr.apteryx.imageio.dicom.Time;
import fr.apteryx.imageio.dicom.UID;
import fr.apteryx.imageio.dicom.Util;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

final class Normalizer
implements Constants {
    private final DicomWarningListener wl;
    private DicomObject obj;
    private DataSet ds;
    private int im;
    private String sopClass;
    private String sopInstance;
    private static final int[] DEFAULT_PIXEL_SPACING = new int[]{1, 1};
    private static final int[] DEFAULT_IMAGE_ORIENTATION_PATIENT = new int[6];
    private static final int[] DEFAULT_IMAGE_POSITION_PATIENT = new int[3];
    private static final String[] DEFAULT_CT_IMAGE_TYPE = new String[]{"DERIVED", "SECONDARY", "AXIAL"};
    private static final String[] DEFAULT_MR_IMAGE_TYPE = new String[]{"DERIVED", "SECONDARY", "OTHER"};
    private static final String[] DEFAULT_ENHCT_IMAGE_TYPE = new String[]{"DERIVED", "PRIMARY", "VOLUME", "NONE"};
    private static final String[] DEFAULT_ENHMR_IMAGE_TYPE = new String[]{"DERIVED", "PRIMARY", "T1", "NONE"};
    private static final String[] DEFAULT_NM_IMAGE_TYPE = new String[]{"DERIVED", "PRIMARY", "RECON TOMO"};
    private static final String[] DEFAULT_XA_IMAGE_TYPE = new String[]{"DERIVED", "SECONDARY", "SINGLE PLANE"};
    private static final String[] DEFAULT_RT_IMAGE_TYPE = new String[]{"DERIVED", "SECONDARY", "RADIOGRAPH"};
    private static final String[] DEFAULT_DX_IMAGE_TYPE = new String[]{"DERIVED", "SECONDARY", ""};
    private static final String[] DEFAULT_PATIENT_ORIENTATION = new String[]{"H", "R"};
    private static final int[] DEFAULT_FIELD_OF_VIEW_ORIGIN = new int[]{0, 0};
    private static final String[] DEFAULT_VL_IMAGE_TYPE = new String[]{"DERIVED", "SECONDARY"};
    private static final String[] DEFAULT_PT_SERIES_TYPE = new String[]{"STATIC", "IMAGE"};
    private static final String[] DEFAULT_PT_IMAGETYPE = new String[]{"DERIVED", "PRIMARY"};
    private static final String[] DEFAULT_OP_IMAGETYPE = new String[]{"DERIVED", "PRIMARY"};

    Normalizer(DicomWarningListener dicomWarningListener) {
        this.wl = dicomWarningListener;
    }

    private int getNumberOfFrames() {
        Object object = this.ds.findValue(2145386512);
        return object instanceof Collection ? ((Collection)object).size() : 1;
    }

    synchronized void normalize(DicomObject dicomObject) throws DicomException {
        Object[] objectArray;
        this.im = 0;
        this.ds = dicomObject.ds;
        this.obj = dicomObject;
        this.ds.checkSpecificCharacterSet();
        Object object = this.ds.findValue(2145386512);
        if (dicomObject.sopClass == null) {
            if (object != null) {
                objectArray = this.ds.findString(524384);
                dicomObject.sopClass = Modality.modalityToSop((String)objectArray, object);
            }
            if (dicomObject.sopClass == null || dicomObject.sopClass.length() == 0) {
                throw new DicomException("InvalidFormat", "No available SOP class to encode this data format");
            }
        }
        if (dicomObject.sopInstance == null || dicomObject.sopInstance.length() == 0) {
            dicomObject.sopInstance = UID.createUID(1);
        }
        this.sopClass = dicomObject.sopClass;
        this.sopInstance = dicomObject.sopInstance;
        if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.1")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modCRSeries();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modCRImage();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.2")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modFrameOfReference();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePlane();
            this.modImagePixel();
            this.modCTImage();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.2.1")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modCTSeries();
            this.modFrameOfReference();
            this.modGeneralEquipment();
            this.modMultiframeDimension();
            this.modAcquisitionContext();
            objectArray = this.getColorModels(object);
            this.modEnhCTImage((ColorModel[])objectArray);
            this.modImagePixel();
            this.modMultiframeFunctionalGroups((ColorModel[])objectArray);
            this.modSoftCopyPresentationLUT();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.4")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modFrameOfReference();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePlane();
            this.modImagePixel();
            this.modMRImage();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.4.1")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modMRSeries();
            this.modFrameOfReference();
            this.modGeneralEquipment();
            this.modMultiframeDimension();
            objectArray = this.getColorModels(object);
            this.modEnhMRImage((ColorModel[])objectArray);
            this.modImagePixel();
            this.modMRPulseSeq();
            this.modMultiframeFunctionalGroups((ColorModel[])objectArray);
            this.modSoftCopyPresentationLUT();
            this.modAcquisitionContext();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.20")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modNMPETPatientOrientation();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modNMImagePixel();
            this.modMultiFrame();
            this.modNMMultiFrame();
            this.modNMImage();
            this.modNMIsotope();
            this.modNMDetector();
            objectArray = (String[])this.ds.findValue(524296, String;.class);
            if ("TOMO".equals(objectArray[2]) || "GATED TOMO".equals(objectArray[2]) || "RECON TOMO".equals(objectArray[2]) || "RECON GATED TOMO".equals(objectArray[2])) {
                this.modNMTOMOAcquisition();
            }
            if ("GATED".equals(objectArray[2]) || "GATED TOMO".equals(objectArray[2]) || "RECON GATED TOMO".equals(objectArray[2])) {
                this.modNMMultigatedAcquisition();
            }
            if ("DYNAMIC".equals(objectArray[2])) {
                this.modNMPhase();
            }
            if ("RECON TOMO".equals(objectArray[2]) || "RECON GATED TOMO".equals(objectArray[2])) {
                this.modNMReconstruction();
            }
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.6.1")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modUSImage();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.3.1")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modMultiFrame();
            this.modUSImage();
            this.modCine();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.7")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modSCEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modSCImage();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.7.2") || this.sopClass.equals("1.2.840.10008.5.1.4.1.1.7.3") || this.sopClass.equals("1.2.840.10008.5.1.4.1.1.7.4")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modSCEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modMultiFrame();
            this.modSCImage();
            this.modSCMultiFrameImage();
            this.modCine();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.12.1")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modMultiFrame();
            this.modXRayImage();
            this.modCine();
            this.modXRayAcquisition();
            this.modXAPositioner();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.12.2")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modMultiFrame();
            this.modXRayImage();
            this.modCine();
            this.modXRayAcquisition();
            if ("TOMO".equals(this.ds.findString(1572898))) {
                this.modXRayTomoAcquisition();
            }
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.481.1")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modRTSeries();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            if (this.getNumberOfFrames() > 1) {
                this.modMultiFrame();
                this.modCine();
            }
            this.modRTImage();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.1.1") || this.sopClass.equals("1.2.840.10008.5.1.4.1.1.1.1.1")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modDXSeries(this.sopClass.equals("1.2.840.10008.5.1.4.1.1.1.1") ? "FOR PRESENTATION" : "FOR PROCESSING");
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modDXAnatomyImaged();
            this.modDXImage();
            this.modDXDetector();
            this.modAcquisitionContext();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.1.2") || this.sopClass.equals("1.2.840.10008.5.1.4.1.1.1.2.1")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modDXSeries(this.sopClass.equals("1.2.840.10008.5.1.4.1.1.1.2") ? "FOR PRESENTATION" : "FOR PROCESSING");
            this.modMammoSeries();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modDXImage();
            this.modDXDetector();
            this.modMammoImage();
            this.modAcquisitionContext();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.1.2") || this.sopClass.equals("1.2.840.10008.5.1.4.1.1.1.2.1")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modDXSeries(this.sopClass.equals("1.2.840.10008.5.1.4.1.1.1.2") ? "FOR PRESENTATION" : "FOR PROCESSING");
            this.modIntraOralSeries();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modDXImage();
            this.modDXDetector();
            this.modIntraOralImage();
            this.modAcquisitionContext();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.77.1.1") || this.sopClass.equals("1.2.840.10008.5.1.4.1.1.77.1.4")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modVLImage();
            this.modAcquisitionContext();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.77.1.5.1") || this.sopClass.equals("1.2.840.10008.5.1.4.1.1.77.1.5.2")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modOphthalmicPhotographySeries();
            this.modSynchronization();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modMultiFrame();
            this.modOphthalmicPhotographicParameters();
            this.modOphthalmicPhotographyImage(this.sopClass.equals("1.2.840.10008.5.1.4.1.1.77.1.5.1") ? 8 : 16);
            this.modOcularRegionImaged();
            this.modOphthalmicPhotographyAcquisitionParameters();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.77.1.2")) {
            this.modPatient();
            this.modSpecimenIdentification();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modVLImage();
            this.modAcquisitionContext();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.77.1.3")) {
            this.modPatient();
            this.modSpecimenIdentification();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modFrameOfReference();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePixel();
            this.modVLImage();
            this.modSlideCoordinates();
            this.modAcquisitionContext();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.128")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modNMPETPatientOrientation();
            this.modPETSeries();
            this.modPETIsotope();
            objectArray = (String[])this.ds.findValue(5509120, String;.class);
            if (objectArray != null && objectArray.length > 1 && "GATED".equals(objectArray[1])) {
                this.modPETMultiGatedAcquisition();
            }
            this.modFrameOfReference();
            this.modGeneralEquipment();
            this.modGeneralImage();
            this.modImagePlane();
            this.modImagePixel();
            this.modPETImage();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.1.30")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modHardcopyEquipment();
            this.modGeneralImage();
            this.modHCGrayscaleImage();
            this.modSOPCommon();
        } else if (this.sopClass.equals("1.2.840.10008.5.1.1.29")) {
            this.modPatient();
            this.modGeneralStudy();
            this.modGeneralSeries();
            this.modHardcopyEquipment();
            this.modGeneralImage();
            this.modHCColorImage();
            this.modSOPCommon();
        } else {
            this.wl.warning("Unsupported", "SOP Class " + this.sopClass + " is not supported, conformance cannot be checked");
        }
    }

    private ColorModel[] getColorModels(Object object) throws DicomException {
        if (object == null) {
            throw new DicomException("MissingMandatoryAttribute", "PixelData");
        }
        ColorModel[] colorModelArray = new ColorModel[this.getNumberOfFrames()];
        if (object instanceof Collection) {
            int n = 0;
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                colorModelArray[n++] = Util.getColorModel(iterator.next());
            }
        } else {
            colorModelArray[0] = Util.getColorModel(object);
        }
        return colorModelArray;
    }

    private boolean codeSequenceHasItem(int n, String string, String string2) {
        Collection collection = this.ds.findSequence(n);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DataSet dataSet = (DataSet)iterator.next();
                if (!string.equals(dataSet.findString(524546)) || !string2.equals(dataSet.findString(524544))) continue;
                return true;
            }
        }
        return false;
    }

    private void checkType2(int n) {
        if (!this.ds.has(n)) {
            this.ds.add(n, null);
        }
    }

    private void checkType2(int n, int n2) {
        if (!this.ds.has(n)) {
            this.ds.add(n, this.ds.findValue(n2));
        }
    }

    private void checkType1(int n, Object object) {
        if (this.ds.findValue(n) == null) {
            this.coercion(n, object);
        }
    }

    private void checkType1(int n, int n2) {
        if (!this.ds.has(n)) {
            this.coercion(n, new Integer(n2));
        }
    }

    private void checkType1(DataSet dataSet, int n, int n2) {
        if (!dataSet.has(n)) {
            this.coercion(dataSet, n, new Integer(n2));
        }
    }

    private void coercion(int n, Object object) {
        this.coercion(this.ds, n, object);
    }

    private void coercion(DataSet dataSet, int n, Object object) {
        DataElement dataElement = new DataElement(n, object);
        dataSet.add(dataElement);
        if (this.wl != null) {
            this.wl.warning(this.im, "AttributeCoercion", dataElement.toString());
        }
    }

    private void force(int n, Object object) {
        Object object2 = this.ds.findValue(n);
        if (object2 != null && object2.equals(object)) {
            return;
        }
        this.coercion(n, object);
    }

    private void force(int n, int n2) {
        this.force(n, new Integer(n2));
    }

    private void modPatient() {
        this.checkType2(0x100010);
        this.checkType2(0x100020);
        this.checkType2(0x100030);
        this.checkType2(0x100040);
    }

    private void modGeneralStudy() {
        if (!this.ds.has(0x20000D)) {
            this.ds.add(0x20000D, UID.createUID(2));
        }
        this.checkType2(524320, 524323);
        this.checkType2(524336, 524339);
        this.checkType2(0x200010);
        this.checkType2(524432);
        this.checkType2(524368);
    }

    private void modGeneralSeries() {
        String string = this.ds.findString(524384);
        if (string == null) {
            string = Modality.sopToModality(this.sopClass);
            if (string != null) {
                this.ds.add(524384, string);
            } else {
                this.coercion(this.ds, 524384, "OT");
            }
        }
        if (!this.ds.has(0x20000E)) {
            this.ds.add(0x20000E, UID.createUID(3));
        }
        this.checkType2(0x200011);
        if ("CT".equals(string) || "MR".equals(string)) {
            this.checkType2(1593600);
        }
    }

    private void modCRSeries() {
        this.checkType2(1572885);
        this.checkType2(1593601);
    }

    private void modGeneralEquipment() {
        if (!(this.ds.has(524400) || this.ds.has(528528) || this.ds.has(1576992))) {
            this.ds.add(524400, "Apteryx");
            this.ds.add(528528, "Dicom Image I/O Plugin");
            this.ds.add(1576992, "1.10");
        }
    }

    private void modGeneralImage() {
        this.checkType2(2097171);
        if (!("1.2.840.10008.5.1.4.1.1.2".equals(this.sopClass) || "1.2.840.10008.5.1.4.1.1.2.1".equals(this.sopClass) || "1.2.840.10008.5.1.4.1.1.4".equals(this.sopClass) || "1.2.840.10008.5.1.4.1.1.4.1".equals(this.sopClass) || "1.2.840.10008.5.1.4.1.1.128".equals(this.sopClass))) {
            this.checkType2(0x200020);
        }
    }

    private void modImagePixel() throws DicomException {
        if (!(this.ds.has(0x280002) && this.ds.has(2621444) && this.ds.has(2621456) && this.ds.has(2621457) && this.ds.has(2621696) && this.ds.has(2621697) && this.ds.has(2621698) && this.ds.has(2621699) && this.ds.has(2145386512))) {
            throw new DicomException("MissingMandatoryAttribute", "Image Pixel module");
        }
        if (this.ds.findInt(0x280002) > 1 && !this.ds.has(2621446)) {
            throw new DicomException("MissingMandatoryAttribute", "Planar Configuration");
        }
        if (!(!"PALETTE COLOR".equals(this.ds.findString(2621444)) && !"COLOR".equals(this.ds.findString(561669)) && !"MIXED".equals(this.ds.findString(561669)) || this.ds.has(2625793) && this.ds.has(2625794) && this.ds.has(2625795) && this.ds.has(2626049) && this.ds.has(2626050) && this.ds.has(2626051))) {
            throw new DicomException("MissingMandatoryAttribute", "Palette");
        }
    }

    private void modCRImage() throws DicomException {
        int n = this.ds.findInt(0x280002);
        String string = this.ds.findString(2621444);
        if (n != 1) {
            throw new DicomException("ProtocoleViolation", "CR Images need to be 1 band");
        }
        if (!"MONOCHROME1".equals(string) && !"MONOCHROME2".equals(string)) {
            this.force(2621444, "MONOCHROME2");
        }
        if (this.ds.has(2621488) && !this.ds.has(1577316)) {
            this.ds.add(1577316, this.ds.findValue(2621488));
        }
    }

    private void modSOPCommon() {
        this.ds.add(524310, this.sopClass);
        this.ds.add(524312, this.sopInstance);
    }

    private void modFrameOfReference() {
        this.checkType1(0x200052, this.sopInstance);
        this.checkType2(2101312);
    }

    private void modSynchronization() {
        this.checkType1(0x200200, "1.2.840.10008.15.1.1");
        this.checkType1(1577066, "NO TRIGGER");
        this.checkType1(0x181800, "N");
    }

    private void modImagePlane() {
        this.checkType1(2621488, DEFAULT_PIXEL_SPACING);
        this.checkType1(2097207, DEFAULT_IMAGE_ORIENTATION_PATIENT);
        this.checkType1(0x200032, DEFAULT_IMAGE_POSITION_PATIENT);
        this.checkType2(1572944);
    }

    private void modCTImage() throws DicomException {
        if (this.ds.findInt(0x280002) != 1) {
            throw new DicomException("ProtocoleViolation", "CT images need to be 1 band");
        }
        String string = this.ds.findString(2621444);
        if (!"MONOCHROME1".equals(string) && !"MONOCHROME2".equals(string)) {
            this.force(2621444, "MONOCHROME2");
        }
        if (this.ds.findInt(2621696) != 16) {
            throw new DicomException("ProtocoleViolation", "CT images need to be 16 bits");
        }
        int n = this.ds.findInt(2621697);
        if (n <= 12) {
            this.ds.add(2621697, 12);
            this.ds.add(2621698, 11);
        } else {
            this.ds.add(2621697, 16);
            this.ds.add(2621698, 15);
        }
        this.checkType1(524296, DEFAULT_CT_IMAGE_TYPE);
        this.checkType1(2625618, 0);
        this.checkType1(2625619, 1);
        this.checkType2(1572960);
        this.checkType2(0x200012);
    }

    private void modMRImage() throws DicomException {
        if (this.ds.findInt(0x280002) != 1) {
            throw new DicomException("ProtocoleViolation", "MR images need to be 1 band");
        }
        String string = this.ds.findString(2621444);
        if (!"MONOCHROME1".equals(string) && !"MONOCHROME2".equals(string)) {
            this.force(2621444, "MONOCHROME2");
        }
        int n = this.ds.findInt(2621697);
        if (this.ds.findInt(2621696) != 16) {
            throw new DicomException("ProtocoleViolation", "MR images need to be 16 bits");
        }
        this.checkType1(524296, DEFAULT_MR_IMAGE_TYPE);
        this.checkType1(1572896, "RM");
        this.checkType1(1572897, "NONE");
        this.checkType2(1572898);
        this.checkType2(1572899);
        this.checkType2(0x200012);
        this.checkType2(0x180080);
        this.checkType2(0x180081);
        this.checkType2(1573009);
    }

    private void commonCTMRImageDescriptionMacro(ColorModel[] colorModelArray) {
        String string;
        IndexColorModel indexColorModel = null;
        boolean bl = false;
        for (int i = 0; i < colorModelArray.length; ++i) {
            this.im = i;
            if (colorModelArray[i] instanceof IndexColorModel) {
                indexColorModel = (IndexColorModel)colorModelArray[i];
                if (!bl) continue;
                break;
            }
            bl = true;
            if (indexColorModel != null) break;
        }
        this.im = 0;
        if (indexColorModel != null) {
            this.obj.updateFromICM(indexColorModel);
            string = bl ? "MIXED" : "COLOR";
        } else {
            string = "MONOCHROME";
        }
        this.checkType1(561669, string);
        this.checkType1(561670, "VOLUME");
        this.checkType1(561671, "NONE");
    }

    private void modEnhCTImage(ColorModel[] colorModelArray) throws DicomException {
        String[] stringArray = (String[])this.ds.findValue(524296, String;.class);
        if (stringArray == null || stringArray.length != 4) {
            this.coercion(524296, DEFAULT_ENHCT_IMAGE_TYPE);
            stringArray = DEFAULT_ENHCT_IMAGE_TYPE;
        }
        String string = stringArray[0];
        this.commonCTMRImageDescriptionMacro(colorModelArray);
        if ("ORIGINAL".equals(string) || "MIXED".equals(string)) {
            this.checkType1(524330, new Date());
            this.checkType2(1609843);
        }
        if (this.ds.has(528704) && !this.ds.has(561298)) {
            throw new DicomException("MissingMandatoryAttribute", "ReferencedImageEvidenceSequence");
        }
        if (this.ds.has(532754) && !this.ds.has(561492)) {
            throw new DicomException("MissingMandatoryAttribute", "SourceImageEvidenceSequence");
        }
        if (this.ds.findInt(0x280002) != 1) {
            throw new DicomException("ProtocoleViolation", "Enh CT images need to be 1 band");
        }
        String string2 = this.ds.findString(2621444);
        this.force(2621444, "MONOCHROME2");
        int n = this.ds.findInt(2621697);
        int n2 = this.ds.findInt(2621696);
        if (n2 != 16) {
            throw new DicomException("ProtocoleViolation", "Enh CT images need to be 16 bits");
        }
        n = n <= 12 ? 12 : 16;
        this.force(2621697, n);
        this.force(2621698, n - 1);
        this.checkType1(1609732, "RESEARCH");
        this.checkType1(2629904, "00");
        if ("01".equals(this.ds.findString(2629904))) {
            this.checkType1(0x282112, 1);
        }
    }

    private void modMRSeries() {
    }

    private void modEnhMRImage(ColorModel[] colorModelArray) throws DicomException {
        String[] stringArray = (String[])this.ds.findValue(524296, String;.class);
        if (stringArray == null || stringArray.length != 4) {
            this.coercion(524296, DEFAULT_ENHMR_IMAGE_TYPE);
            stringArray = DEFAULT_ENHMR_IMAGE_TYPE;
        }
        String string = stringArray[0];
        this.commonCTMRImageDescriptionMacro(colorModelArray);
        this.checkType1(561672, "MAGNITUDE");
        this.checkType1(561673, "UNKNOWN");
        if ("ORIGINAL".equals(string) || "MIXED".equals(string)) {
            this.checkType1(524330, new Date());
            this.checkType1(1609843, 0);
            this.checkType1(1609984, "1H");
            this.checkType1(1572999, 0);
            this.checkType1(1609828, "NONE");
        }
        if (this.ds.has(528704) && !this.ds.has(561298)) {
            throw new DicomException("MissingMandatoryAttribute", "ReferencedImageEvidenceSequence");
        }
        if (this.ds.has(532754) && !this.ds.has(561492)) {
            throw new DicomException("MissingMandatoryAttribute", "SourceImageEvidenceSequence");
        }
        this.checkType1(1609732, "RESEARCH");
        this.checkType1(1610100, "IEC");
        if (this.ds.findInt(0x280002) != 1) {
            throw new DicomException("ProtocoleViolation", "Enh MR images need to be 1 band");
        }
        String string2 = this.ds.findString(2621444);
        this.force(2621444, "MONOCHROME2");
        int n = this.ds.findInt(2621697);
        int n2 = this.ds.findInt(2621696);
        if (n2 != 16 && n2 != 8) {
            throw new DicomException("ProtocoleViolation", "Enh MR images need to be 8 or 16 bits");
        }
        n = n <= 8 ? 8 : (n <= 12 ? 12 : 16);
        this.force(2621697, n);
        this.checkType1(2629904, "00");
        if ("01".equals(this.ds.findString(2629904))) {
            this.checkType1(0x282112, 1);
        }
    }

    private void modNMPETPatientOrientation() {
        this.checkType2(5506064);
        this.checkType2(5506068);
    }

    private void modNMImagePixel() throws DicomException {
        int n;
        if (this.ds.findInt(0x280002) != 1) {
            throw new DicomException("ProtocoleViolation", "NM images need to be 1 band");
        }
        String string = this.ds.findString(2621444);
        if (!"MONOCHROME2".equals(string) && !"PALETTE COLOR".equals(string)) {
            this.force(2621444, "MONOCHROME2");
        }
        if ((n = this.ds.findInt(2621696)) != 8 && n != 16) {
            throw new DicomException("ProtocoleViolation", "NM images need to be 8 or 16 bits");
        }
        this.ds.add(2621697, n);
        this.ds.add(2621698, n - 1);
        this.checkType2(2621488);
    }

    private void modMultiFrame() {
        this.ds.add(0x280008, this.getNumberOfFrames());
    }

    private void modNMMultiFrame() {
        String[] stringArray = (String[])this.ds.findValue(524296, String;.class);
        if (stringArray == null || stringArray.length < 3 || !this.ds.has(2621449)) {
            stringArray = DEFAULT_NM_IMAGE_TYPE;
            this.coercion(524296, stringArray);
            this.coercion(2621449, new Integer(5505152));
            int n = this.ds.findInt(0x280008);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i + 1;
            }
            this.coercion(5505152, nArray);
            this.force(5505153, n);
        }
        if ("TOMO".equals(stringArray[2]) || "GATED TOMO".equals(stringArray[2]) || "RECON TOMO".equals(stringArray[2]) || "RECON GATED TOMO".equals(stringArray[2])) {
            this.checkType1(5505105, 1);
        }
        this.checkType1(5505041, 1);
        this.checkType1(5505057, 1);
    }

    private void modNMImage() {
        this.checkType2(1572976);
    }

    private void modNMIsotope() {
        this.checkType2(5505042);
        this.checkType2(5505046);
    }

    private void modNMDetector() {
        this.checkType2(5505058);
    }

    private void modNMTOMOAcquisition() {
        this.checkType2(5505106);
    }

    private void modNMMultigatedAcquisition() {
    }

    private void modNMPhase() {
    }

    private void modNMReconstruction() {
        this.checkType2(0x180088);
        this.checkType2(1572944);
    }

    private void modUSImage() throws DicomException {
        int n = this.ds.findInt(0x280002);
        String string = this.ds.findString(2621444);
        switch (n) {
            case 1: {
                if ("MONOCHROME2".equals(string) || "PALETTE COLOR".equals(string)) break;
                this.force(2621444, "MONOCHROME2");
                break;
            }
            case 3: {
                if ("YBR_FULL".equals(string)) {
                    this.ds.add(2621446, 1);
                    break;
                }
                if ("YBR_FULL_422".equals(string) || "YBR_PARTIAL_422".equals(string) || "YBR_PARTIAL_420".equals(string) || "YBR_ICT".equals(string) || "YBR_RCT".equals(string)) {
                    this.ds.add(2621446, 0);
                    break;
                }
                this.force(2621444, "RGB");
                break;
            }
            default: {
                throw new DicomException("ProtocoleViolation", "US images need to be 1 band or 3 bands");
            }
        }
        if (this.ds.findInt(2621699) != 0) {
            throw new DicomException("ProtocoleViolation", "US images need to be unsigned");
        }
        int n2 = this.ds.findInt(2621696);
        if ("PALETTE COLOR".equals(string)) {
            if (n2 != 16 && n2 != 8) {
                throw new DicomException("ProtocoleViolation", "US palette-color images need to be 8 or 16 bits");
            }
        } else if (n2 != 8) {
            throw new DicomException("ProtocoleViolation", "US non-palette-color images need to be 8 bits");
        }
        this.ds.add(2621697, n2);
        this.ds.add(2621698, n2 - 1);
        if (this.ds.has(0x280008)) {
            this.checkType1(2621449, 1577059);
        }
        this.checkType2(524296);
    }

    private void modCine() {
        switch (this.ds.findInt(2621449)) {
            case 1577059: {
                this.checkType1(1577059, 1);
                break;
            }
            case 1577061: {
                if (this.ds.has(1577061)) break;
                int n = this.ds.findInt(0x280008);
                int[] nArray = new int[n];
                nArray[0] = 0;
                for (int i = 1; i < n; ++i) {
                    nArray[i] = 1;
                }
                this.coercion(1577061, nArray);
            }
        }
    }

    private void modSCEquipment() {
        this.checkType1(524388, "WSD");
    }

    private void modSCImage() throws DicomException {
        if (!"1.2.840.10008.5.1.4.1.1.7".equals(this.sopClass)) {
            if (this.ds.findInt(2621699) != 0) {
                throw new DicomException("ProtocoleViolation", "SC multiframe images need to be unsigned");
            }
            if ("1.2.840.10008.5.1.4.1.1.7.4".equals(this.sopClass)) {
                if (this.ds.findInt(0x280002) != 3) {
                    throw new DicomException("ProtocoleViolation", "SC true color images need to be 3 bands");
                }
                String string = this.ds.findString(2621444);
                if (string != null && string.startsWith("YBR")) {
                    this.force(2621444, "YBR_FULL_422");
                } else {
                    this.force(2621444, "RGB");
                }
                this.ds.add(2621446, 0);
                if (this.ds.findInt(2621696) != 8) {
                    throw new DicomException("ProtocoleViolation", "SC true color images must be 8 bits");
                }
                this.ds.add(2621697, 8);
                this.ds.add(2621698, 7);
            } else {
                if (this.ds.findInt(0x280002) != 1) {
                    throw new DicomException("ProtocoleViolation", "SC grayscale images need to be 1 band");
                }
                this.force(2621444, "MONOCHROME2");
                if ("1.2.840.10008.5.1.4.1.1.7.3".equals(this.sopClass)) {
                    if (this.ds.findInt(2621696) != 16) {
                        throw new DicomException("ProtocoleViolation", "SC grayscale word images must be 16 bits");
                    }
                    int n = this.ds.findInt(2621697);
                    if (n < 9) {
                        n = 9;
                    }
                    this.ds.add(2621697, n);
                    this.ds.add(2621698, n - 1);
                } else {
                    if (this.ds.findInt(2621696) != 8) {
                        throw new DicomException("ProtocoleViolation", "SC grayscale byte images must be 8 bits");
                    }
                    this.ds.add(2621697, 8);
                    this.ds.add(2621698, 7);
                }
            }
        }
    }

    private void modSCMultiFrameImage() {
        String string;
        int n;
        this.checkType1(2622209, "NO");
        if ("MONOCHROME2".equals(this.ds.findString(2621444)) && this.ds.findInt(2621697) > 1) {
            this.force(0x20500020, "IDENTITY");
            this.force(2625618, 0);
            this.force(2625619, 1);
            this.force(2625620, "US");
        }
        if ((n = this.ds.findInt(0x280008)) > 1) {
            this.checkType1(2621449, 1577061);
        }
        if ((string = this.ds.findString(524388)).equals("DF") || (string.equals("SD") || string.equals("SI")) && this.ds.has(2621488)) {
            Object object;
            Object object2 = this.ds.findValue(2621488);
            if (object2 == null) {
                object2 = this.ds.findValue(2621492);
            }
            if (object2 == null) {
                int[] nArray = new int[2];
                nArray[0] = 1;
                object = nArray;
                nArray[1] = 1;
            } else {
                object = object2;
            }
            this.coercion(1581072, object);
        }
    }

    private void modXRayImage() throws DicomException {
        if (this.ds.findInt(0x280002) != 1) {
            throw new DicomException("ProtocoleViolation", "XRay images need to be 1 band");
        }
        this.force(2621444, "MONOCHROME2");
        if (this.ds.findInt(2621699) != 0) {
            throw new DicomException("ProtocoleViolation", "XRay images need to be unsigned");
        }
        int n = this.ds.findInt(2621696);
        if (n != 8 && n != 16) {
            throw new DicomException("ProtocoleViolation", "XRay images need to be 8 or 16 bits");
        }
        int n2 = this.ds.findInt(2621697);
        if (n2 <= 8) {
            this.ds.add(2621697, 8);
            this.ds.add(2621698, 7);
        } else if (n2 <= 10) {
            this.ds.add(2621697, 10);
            this.ds.add(2621698, 9);
        } else if (n2 <= 12) {
            this.ds.add(2621697, 12);
            this.ds.add(2621698, 11);
        } else {
            this.ds.add(2621697, 16);
            this.ds.add(2621698, 15);
        }
        if (this.ds.findInt(0x280008) > 1) {
            this.checkType1(2621449, 1577059);
        }
        this.checkType1(524296, DEFAULT_XA_IMAGE_TYPE);
        this.checkType1(2625600, "LIN");
    }

    private void modXRayAcquisition() {
        this.checkType2(1572960);
        this.checkType1(0x181155, "SC");
        if (!this.ds.has(1577298)) {
            this.checkType2(0x181151);
            this.checkType2(1577296);
        }
        if (this.ds.has(2621488) && !this.ds.has(1577316)) {
            this.ds.add(1577316, this.ds.findValue(2621488));
        }
    }

    private void modXAPositioner() {
        if (this.ds.findInt(0x280008) > 1) {
            this.checkType2(1578240);
        }
        this.checkType2(1578256);
        this.checkType2(0x181511);
        if ("DYNAMIC".equals(this.ds.findString(1578240))) {
            this.checkType2(1578272);
            this.checkType2(1578273);
        }
    }

    private void modXRayTomoAcquisition() {
        this.checkType1(1578080, 0);
    }

    private void modRTSeries() {
        if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.481.1")) {
            this.force(524384, "RTIMAGE");
        }
        if (!this.ds.has(0x20000E)) {
            this.ds.add(0x20000E, UID.createUID(3));
        }
        this.checkType2(0x200011);
    }

    private void modRTImage() throws DicomException {
        DataSet dataSet;
        if (this.ds.findInt(0x280002) != 1) {
            throw new DicomException("ProtocoleViolation", "RT images need to be 1 band");
        }
        this.force(2621444, "MONOCHROME2");
        if (this.ds.findInt(2621699) != 0) {
            throw new DicomException("ProtocoleViolation", "RT images need to be unsigned");
        }
        int n = this.ds.findInt(2621696);
        if (n != 8 && n != 16) {
            throw new DicomException("ProtocoleViolation", "RT images need to be 8 or 16 bits");
        }
        int n2 = this.ds.findInt(2621697);
        if (n2 <= 8) {
            n2 = 8;
        } else if (n2 <= 12) {
            n2 = 12;
        }
        this.ds.add(2621697, n2);
        this.ds.add(2621698, n2 - 1);
        this.checkType1(0x30020002, "No label");
        this.checkType2(528496);
        this.checkType1(524296, DEFAULT_RT_IMAGE_TYPE);
        this.checkType2(524388);
        String[] stringArray = (String[])this.ds.findValue(524296, String;.class);
        if (stringArray.length > 2 && ("SIMULATOR".equals(stringArray[2]) || "PORTAL".equals(stringArray[2]))) {
            this.checkType2(805437450);
        }
        this.checkType1(805437452, "NORMAL");
        this.checkType2(805437454);
        if ("NON_NORMAL".equals(this.ds.findString(805437452))) {
            this.checkType2(805437456);
        }
        this.checkType2(805437457, 2621488);
        this.checkType2(805437458);
        this.checkType2(0x30020020);
        this.checkType2(805961907);
        this.checkType2(0x30020022);
        this.checkType2(805437478);
        String[] stringArray2 = (String[])this.ds.findValue(524296, String;.class);
        if (stringArray2 != null && stringArray2.length >= 3 && "FLUENCE".equals(stringArray2[2]) && ((dataSet = this.ds.findDataSet(805437504)) == null || !dataSet.has(805437505))) {
            new DataSet();
            dataSet.add(805437505, "CALCULATED");
            this.coercion(805437504, dataSet);
        }
    }

    private void modDXSeries(String string) {
        this.checkType1(524392, string);
    }

    private void modDXAnatomyImaged() {
        this.checkType1(0x200062, "U");
        this.checkType2(533016);
    }

    private void modDXImage() throws DicomException {
        if (this.ds.findInt(0x280002) != 1) {
            throw new DicomException("ProtocoleViolation", "DX images need to be 1 band");
        }
        String string = this.ds.findString(2621444);
        if (!"MONOCHROME2".equals(string) && !"MONOCHROME1".equals(string)) {
            this.force(2621444, "MONOCHROME2");
        }
        if (this.ds.findInt(2621699) != 0) {
            throw new DicomException("ProtocoleViolation", "DX images need to be unsigned");
        }
        int n = this.ds.findInt(2621696);
        if (n != 8 && n != 16) {
            throw new DicomException("ProtocoleViolation", "DX images need to be 8 or 16 bits");
        }
        int n2 = this.ds.findInt(2621697);
        if (n2 <= 8) {
            n2 = 8;
        } else if (n2 <= 12) {
            n2 = 12;
        }
        this.ds.add(2621697, n2);
        this.ds.add(2621698, n2 - 1);
        this.checkType1(524296, DEFAULT_DX_IMAGE_TYPE);
        this.checkType1(2625600, "LIN");
        this.checkType1(2625601, 1);
        this.force(2625618, 0);
        this.force(2625619, 1);
        this.force(2625620, "US");
        this.force(0x20500020, "MONOCHROME1".equals(this.ds.findString(2621444)) ? "INVERSE" : "IDENTITY");
        this.checkType1(2629904, "00");
        if ("01".equals(this.ds.findString(2629904))) {
            this.checkType1(0x282112, 1);
        }
        this.checkType1(0x200020, DEFAULT_PATIENT_ORIENTATION);
        this.checkType1(2622209, "NO");
        if ("FOR PRESENTATION".equals(this.ds.findString(524392)) && !this.ds.has(2633744)) {
            int n3 = this.ds.findInt(2621697);
            n3 = 1 << n3;
            this.checkType1(2625616, n3 / 2);
            this.checkType1(2625617, n3);
        }
    }

    private void modDXDetector() {
        this.checkType2(1601540);
        if (this.ds.has(1601588)) {
            this.checkType1(1601586, 0);
        } else if (this.ds.has(1601586)) {
            this.checkType1(1601588, "NO");
        }
        if (this.ds.has(1601588)) {
            this.checkType1(1601584, DEFAULT_FIELD_OF_VIEW_ORIGIN);
        }
        this.checkType1(1577316, this.ds.has(2621488) ? (Object)this.ds.findValue(2621488) : DEFAULT_PIXEL_SPACING);
    }

    private void modAcquisitionContext() {
        this.checkType2(0x400555);
    }

    private void modMammoSeries() {
    }

    private void modMammoImage() {
        this.checkType1(1578248, "NONE");
        this.checkType1(0x200062, "B");
        this.force(4195096, "BREAST");
        this.checkType2(533016);
        if (this.ds.findValue(5505568) == null) {
            DataSet dataSet = new DataSet();
            dataSet.add(524544, "R-10224");
            dataSet.add(524546, "SNM3");
            dataSet.add(524548, "medio-lateral");
            dataSet.add(5505570, null);
            this.coercion(5505568, dataSet);
        }
    }

    private void modIntraOralSeries() {
    }

    private void modIntraOralImage() {
        this.checkType1(1578248, "NONE");
        this.checkType1(0x200062, "B");
        this.checkType2(533016);
    }

    private void modVLImage() throws DicomException {
        String[] stringArray;
        int n = this.ds.findInt(0x280002);
        switch (n) {
            case 1: {
                this.force(2621444, "MONOCHROME2");
                break;
            }
            case 3: {
                stringArray = this.ds.findString(2621444);
                if (!("YBR_FULL_422".equals(stringArray) || "RGB".equals(stringArray) || "YBR_ICT".equals(stringArray) || "YBR_RCT".equals(stringArray))) {
                    this.force(2621444, "RGB");
                }
                this.ds.add(2621446, 0);
                break;
            }
            default: {
                throw new DicomException("ProtocoleViolation", "VL images need to be 1 band or 3 bands");
            }
        }
        if (this.ds.findInt(2621696) != 8) {
            throw new DicomException("ProtocoleViolation", "VL images need to be 8 bits");
        }
        this.ds.add(2621697, 8);
        this.ds.add(2621698, 7);
        this.checkType1(524296, DEFAULT_VL_IMAGE_TYPE);
        this.checkType2(2629904);
        stringArray = (String[])this.ds.findValue(524296, String;.class);
        if (stringArray.length > 2 && stringArray[2] != null && stringArray[2].startsWith("STEREO") && !this.ds.has(528704)) {
            stringArray[2] = "";
            this.coercion(524296, stringArray);
        }
    }

    private void modSpecimenIdentification() {
        this.checkType1(4195594, "No accession number");
        this.checkType2(0x400550);
    }

    private void modSlideCoordinates() {
        this.checkType2(4196122);
    }

    private void modPETSeries() {
        Time time;
        Day day = (Day)this.ds.findValue(524320, Day.class);
        if (day == null) {
            day = new Day();
        }
        if ((time = (Time)this.ds.findValue(524336, Time.class)) == null) {
            time = new Time();
        }
        this.checkType1(524321, day);
        this.checkType1(524337, time);
        this.checkType1(5509121, "CNTS");
        this.checkType1(5509122, "EMISSION");
        this.checkType1(5509120, DEFAULT_PT_SERIES_TYPE);
        String[] stringArray = (String[])this.ds.findValue(5509120, String;.class);
        if (stringArray != null && stringArray.length > 1 && "REPROJECTION".equals(stringArray[1])) {
            this.checkType2(5509124);
        }
        if (stringArray != null && stringArray.length > 0) {
            if ("GATED".equals(stringArray[0])) {
                this.checkType1(5505121, 600);
                this.checkType1(5505137, 16);
            } else if ("DYNAMIC".equals(stringArray[0])) {
                this.checkType1(5505281, 16);
            }
        }
        this.checkType1(5505153, 64);
        this.checkType2(2621521);
        this.checkType1(5509378, "START");
        this.checkType2(0x181181);
    }

    private void modPETIsotope() {
        this.checkType2(5505046);
    }

    private void modPETMultiGatedAcquisition() {
        this.checkType2(0x181080);
    }

    private void modPETImage() throws DicomException {
        if (this.ds.findInt(0x280002) != 1) {
            throw new DicomException("ProtocoleViolation", "PET images must be 1 band");
        }
        this.force(2621444, "MONOCHROME2");
        if (this.ds.findInt(2621696) != 16) {
            throw new DicomException("ProtocoleViolation", "PET images must be 16 bits");
        }
        this.ds.add(2621697, 16);
        this.ds.add(2621698, 15);
        this.checkType1(524296, DEFAULT_PT_IMAGETYPE);
        this.force(2625618, 0);
        this.checkType1(2625619, 1);
        this.checkType1(5509888, 0);
        String[] stringArray = (String[])this.ds.findValue(5509120, String;.class);
        if (stringArray != null && stringArray.length > 0 && "GATED".equals(stringArray[1])) {
            this.checkType1(1577056, 0);
            this.checkType1(1577059, new Float(62.5));
            if ("Y".equals(this.ds.findString(0x181080))) {
                this.checkType1(0x181081, 200);
                this.checkType1(1577090, 2000);
            }
        }
        this.checkType1(5509936, 1);
        this.checkType2(524322, 524323);
        this.checkType2(524338, 524339);
        this.checkType2(1577538);
        if (!"NONE".equals(this.ds.findString(5509378))) {
            this.checkType1(5509921, 0);
        }
    }

    private void modHardcopyEquipment() {
    }

    private void modHCGrayscaleImage() throws DicomException {
        int n;
        this.modImagePixel();
        if (this.ds.findInt(0x280002) != 1) {
            throw new DicomException("ProtocoleViolation", "HC grayscale images must be 1 band");
        }
        if (this.ds.findInt(2621699) != 0) {
            throw new DicomException("ProtocoleViolation", "HC grayscale images must be unsigned");
        }
        String string = this.ds.findString(2621444);
        if (!"MONOCHROME1".equals(string) && !"MONOCHROME2".equals(string)) {
            this.force(2621444, "MONOCHROME2");
        }
        if ((n = this.ds.findInt(2621696)) != 8 && n != 16) {
            throw new DicomException("ProtocoleViolation", "HC grayscale images must be 8 or 16 bits");
        }
        if (this.ds.findInt(2621697) <= 8) {
            this.ds.add(2621697, 8);
            this.ds.add(2621698, 7);
        } else {
            this.ds.add(2621697, 12);
            this.ds.add(2621698, 11);
        }
    }

    private void modHCColorImage() throws DicomException {
        this.modImagePixel();
        if (this.ds.findInt(0x280002) != 3) {
            throw new DicomException("ProtocoleViolation", "HC color images must be 3 bands");
        }
        if (this.ds.findInt(2621699) != 0) {
            throw new DicomException("ProtocoleViolation", "HC color images must be unsigned");
        }
        this.force(2621444, "RGB");
        this.ds.add(2621446, 1);
        if (this.ds.findInt(2621696) != 8) {
            throw new DicomException("ProtocoleViolation", "HC color images must be 8 bits");
        }
        this.ds.add(2621697, 8);
        this.ds.add(2621698, 7);
    }

    private DataSet getShared() {
        Object object = this.ds.findValue(1375769129);
        if (object instanceof Collection && ((Collection)object).size() >= 1) {
            object = ((Collection)object).iterator().next();
        }
        if (object instanceof DataSet) {
            return (DataSet)object;
        }
        DataSet dataSet = new DataSet();
        this.ds.add(1375769129, dataSet);
        return dataSet;
    }

    private Collection getPerFrames() {
        Object object = this.ds.findValue(1375769136);
        int n = this.getNumberOfFrames();
        if (object instanceof Collection && ((Collection)object).size() == n) {
            return (Collection)object;
        }
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new DataSet());
        }
        this.ds.add(1375769136, arrayList);
        return arrayList;
    }

    private void modMultiframeFunctionalGroups(ColorModel[] colorModelArray) throws DicomException {
        Iterator<Object> iterator;
        Serializable serializable;
        DataSet dataSet = this.getShared();
        Collection collection = this.getPerFrames();
        String[] stringArray = (String[])this.ds.findValue(524296, String;.class);
        if (this.sopClass.equals("1.2.840.10008.5.1.4.1.1.2.1")) {
            this.enhancedCTFunctionalGroupMacros(dataSet, collection, stringArray, colorModelArray);
        } else {
            this.enhancedMRFunctionalGroupMacros(dataSet, collection, stringArray, colorModelArray);
        }
        HashSet hashSet = new HashSet();
        Object object = collection.iterator();
        while (object.hasNext()) {
            serializable = (DataSet)object.next();
            iterator = ((TreeMap)serializable).keySet().iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            serializable = (Integer)object.next();
            if ((Integer)serializable == 2134289) {
                dataSet.remove(serializable);
                continue;
            }
            iterator = collection.iterator();
            DataSet dataSet2 = (DataSet)iterator.next();
            Object v = dataSet2.get(serializable);
            if (v == null) continue;
            boolean bl = true;
            while (iterator.hasNext()) {
                DataSet dataSet3 = (DataSet)iterator.next();
                if (v.equals(dataSet3.get(serializable))) continue;
                bl = false;
                break;
            }
            if (bl) {
                dataSet.put(serializable, v);
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    ((DataSet)iterator.next()).remove(serializable);
                }
                continue;
            }
            dataSet.remove(serializable);
        }
        this.checkType1(2097171, 1);
        object = new Date();
        this.checkType1(524323, object);
        this.checkType1(524339, object);
        this.ds.add(0x280008, this.getNumberOfFrames());
        if (this.ds.has(2134369)) {
            if (!this.ds.has(2134568)) {
                throw new DicomException("MissingMandatoryAttribute", "ConcatenationFrameOffsetNumber");
            }
            if (!this.ds.has(2134370)) {
                throw new DicomException("MissingMandatoryAttribute", "InConcatenationNumber");
            }
        }
    }

    private void modCTSeries() {
    }

    void enhancedCTFunctionalGroupMacros(DataSet dataSet, Collection collection, String[] stringArray, ColorModel[] colorModelArray) {
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.CTImageFrameTypeMacro(dataSet, (DataSet)iterator.next(), colorModelArray[n++]);
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            DataSet dataSet2 = (DataSet)iterator.next();
            this.pixelMeasuresMacro(dataSet, dataSet2, 1610537);
            this.frameContentMacro(dataSet, dataSet2, 1610537);
            this.planePositionMacro(dataSet, dataSet2, 1610537);
            this.planeOrientationMacro(dataSet, dataSet2, 1610537);
            this.frameAnatomyMacro(dataSet, dataSet2);
            this.CTPixelValueTransformationMacro(dataSet, dataSet2);
            if ("ORIGINAL".equals(stringArray[0]) || "MIXED".equals(stringArray[0])) {
                String string = this.ds.findString(1609783);
                if (string != null && !"NONE".equals(string)) {
                    this.cardiacTriggerMacro(dataSet, dataSet2);
                }
                this.CTAcquisitionTypeMacro(dataSet, dataSet2);
                this.CTAcquisitionDetailsMacro(dataSet, dataSet2);
                this.CTTableDynamicsMacro(dataSet, dataSet2);
                this.CTPositionMacro(dataSet, dataSet2);
                this.CTGeometryMacro(dataSet, dataSet2);
                if (!"CONSTANT_ANGLE".equals(this.findStringInMacro(dataSet, dataSet2, 1610497, 1610498))) {
                    this.CTReconstructionMacro(dataSet, dataSet2);
                }
                this.CTExposureMacro(dataSet, dataSet2);
                this.CTXRayDetailsMacro(dataSet, dataSet2);
            }
            ++this.im;
        }
    }

    void enhancedMRFunctionalGroupMacros(DataSet dataSet, Collection collection, String[] stringArray, ColorModel[] colorModelArray) {
        Object object;
        DataSet dataSet2;
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.MRImageFrameTypeMacro(dataSet, (DataSet)iterator.next(), colorModelArray[n++]);
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            dataSet2 = (DataSet)iterator.next();
            this.pixelMeasuresMacro(dataSet, dataSet2, 1610278);
            this.frameContentMacro(dataSet, dataSet2, 1610278);
            this.planePositionMacro(dataSet, dataSet2, 1610278);
            this.planeOrientationMacro(dataSet, dataSet2, 1610278);
            this.frameAnatomyMacro(dataSet, dataSet2);
            this.pixelValueTransformationMacro(dataSet, dataSet2);
            if ("ORIGINAL".equals(stringArray[0]) || "MIXED".equals(stringArray[0])) {
                object = this.ds.findString(1609783);
                if (object != null && !"NONE".equals(object)) {
                    this.cardiacTriggerMacro(dataSet, dataSet2);
                }
                this.MRTimingAndRelatedParametersMacro(dataSet, dataSet2);
                if ("RECTILINEAR".equals(this.ds.findString(1609778))) {
                    this.MRFOVGeometryMacro(dataSet, dataSet2);
                }
                this.MREchoMacro(dataSet, dataSet2);
                this.MRModifierMacro(dataSet, dataSet2);
                this.MRImagingModifierMacro(dataSet, dataSet2);
                this.MRReceiveCoilMacro(dataSet, dataSet2);
                this.MRTransmitCoilMacro(dataSet, dataSet2);
                this.MRAveragesMacro(dataSet, dataSet2);
                if ("YES".equals(this.ds.findString(1609748))) {
                    this.MRVelocityEncodingMacro(dataSet, dataSet2);
                }
            }
            if ("METABOLITE_MAP".equals(stringArray[2])) {
                this.MRMetaboliteMapMacro(dataSet, dataSet2);
            }
            ++this.im;
        }
        this.im = 0;
        if ("ORIGINAL".equals(stringArray[0]) || "MIXED".equals(stringArray[0])) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                dataSet2 = (DataSet)iterator.next();
                if ("DIFFUSION".equals(this.findStringInMacro(null, dataSet2, 1610278, 561673))) {
                    object = collection.iterator();
                    while (object.hasNext()) {
                        this.MRDiffusionMacro(dataSet, (DataSet)object.next());
                    }
                    break;
                }
                ++this.im;
            }
            this.im = 0;
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                dataSet2 = (DataSet)iterator.next();
                if ("SLAB".equals(this.findStringInMacro(null, dataSet2, 1610005, 1609767))) {
                    object = collection.iterator();
                    while (object.hasNext()) {
                        this.MRSpatialSaturationMacro(dataSet, (DataSet)object.next());
                    }
                    break;
                }
                ++this.im;
            }
            this.im = 0;
        }
    }

    private void checkType1Macro(DataSet dataSet, DataSet dataSet2, int n) {
        if (DicomObject.findMacro(n, dataSet, dataSet2) == null) {
            dataSet2.add(n, new DataSet());
        }
    }

    private void checkType1InMacro(DataSet dataSet, DataSet dataSet2, int n, int n2, Object object) {
        DataSet dataSet3 = dataSet2.findDataSet(n);
        if (dataSet3 != null) {
            if (dataSet3.findValue(n2) == null) {
                this.coercion(dataSet3, n2, object);
            }
            return;
        }
        DataSet dataSet4 = dataSet.findDataSet(n);
        if (dataSet4 == null) {
            dataSet3 = new DataSet();
            dataSet2.add(n, dataSet3);
        } else {
            if (dataSet4.findValue(n2) != null) {
                return;
            }
            dataSet3 = (DataSet)Cloner.cloneElement(dataSet4);
            dataSet2.add(n, dataSet3);
        }
        this.coercion(dataSet3, n2, object);
    }

    private void checkType2InMacro(DataSet dataSet, DataSet dataSet2, int n, int n2) {
        DataSet dataSet3 = dataSet2.findDataSet(n);
        if (dataSet3 != null) {
            if (!dataSet3.has(n2)) {
                dataSet3.add(n2, null);
            }
            return;
        }
        DataSet dataSet4 = dataSet.findDataSet(n);
        if (dataSet4 == null) {
            dataSet3 = new DataSet();
            dataSet2.add(n, dataSet3);
        } else {
            if (dataSet4.has(n2)) {
                return;
            }
            dataSet3 = (DataSet)Cloner.cloneElement(dataSet4);
            dataSet2.add(n, dataSet3);
        }
        dataSet3.add(n2, null);
    }

    private void checkType1InMacro(DataSet dataSet, DataSet dataSet2, int n, int n2, int n3) {
        this.checkType1InMacro(dataSet, dataSet2, n, n2, new Integer(n3));
    }

    private void checkType1InMacro(DataSet dataSet, DataSet dataSet2, int n, int n2, float f) {
        this.checkType1InMacro(dataSet, dataSet2, n, n2, new Float(f));
    }

    private void checkType1InMacro(DataSet dataSet, DataSet dataSet2, int n, int n2, double d) {
        this.checkType1InMacro(dataSet, dataSet2, n, n2, new Double(d));
    }

    private Object findValueInMacro(DataSet dataSet, DataSet dataSet2, int n, int n2, Class clazz) {
        DataSet dataSet3 = DicomObject.findMacro(n, dataSet, dataSet2);
        return dataSet3 == null ? this.ds.findValue(n2, clazz) : dataSet3.findValue(n2, clazz);
    }

    private String findStringInMacro(DataSet dataSet, DataSet dataSet2, int n, int n2) {
        DataSet dataSet3 = DicomObject.findMacro(n, dataSet, dataSet2);
        return dataSet3 == null ? this.ds.findString(n2) : dataSet3.findString(n2);
    }

    private String getFrameTypeValue1(DataSet dataSet, DataSet dataSet2, int n) {
        String[] stringArray = (String[])this.findValueInMacro(dataSet, dataSet2, n, 561159, String;.class);
        return stringArray[0];
    }

    private String getMRFrameTypeValue1(DataSet dataSet, DataSet dataSet2) {
        String[] stringArray = (String[])this.findValueInMacro(dataSet, dataSet2, 1610278, 561159, String;.class);
        return stringArray[0];
    }

    private String getCTFrameTypeValue1(DataSet dataSet, DataSet dataSet2) {
        String[] stringArray = (String[])this.findValueInMacro(dataSet, dataSet2, 1610537, 561159, String;.class);
        return stringArray[0];
    }

    private void pixelMeasuresMacro(DataSet dataSet, DataSet dataSet2, int n) {
        this.checkType1Macro(dataSet, dataSet2, 2658576);
        String string = this.findStringInMacro(dataSet, dataSet2, n, 561670);
        if (!"DISTORTED".equals(string) && !"SAMPLED".equals(string)) {
            this.checkType1InMacro(dataSet, dataSet2, 2658576, 2621488, DEFAULT_PIXEL_SPACING);
        }
        if ("VOLUME".equals(string) || "SAMPLED".equals(string)) {
            this.checkType1InMacro(dataSet, dataSet2, 2658576, 1572944, 1);
        }
    }

    private void frameContentMacro(DataSet dataSet, DataSet dataSet2, int n) {
        this.checkType1Macro(null, dataSet2, 2134289);
        if ("ORIGINAL".equals(this.getFrameTypeValue1(dataSet, dataSet2, n))) {
            Date date = new Date();
            this.checkType1InMacro(null, dataSet2, 2134289, 1610065, date);
            this.checkType1InMacro(null, dataSet2, 2134289, 1609844, date);
            this.checkType1InMacro((DataSet)null, dataSet2, 2134289, 1610272, 0);
        }
    }

    private void planePositionMacro(DataSet dataSet, DataSet dataSet2, int n) {
        this.checkType1Macro(dataSet, dataSet2, 2134291);
        String string = this.findStringInMacro(dataSet, dataSet2, n, 561670);
        if ("ORIGINAL".equals(this.getFrameTypeValue1(dataSet, dataSet2, n)) && !"DISTORTED".equals(string)) {
            this.checkType1InMacro(dataSet, dataSet2, 2134291, 0x200032, DEFAULT_IMAGE_POSITION_PATIENT);
        }
    }

    private void planeOrientationMacro(DataSet dataSet, DataSet dataSet2, int n) {
        this.checkType1Macro(dataSet, dataSet2, 2134294);
        String string = this.findStringInMacro(dataSet, dataSet2, n, 561670);
        if ("ORIGINAL".equals(this.getFrameTypeValue1(dataSet, dataSet2, n)) && !"DISTORTED".equals(string)) {
            this.checkType1InMacro(dataSet, dataSet2, 2134294, 2097207, DEFAULT_IMAGE_ORIENTATION_PATIENT);
        }
    }

    private void cardiacTriggerMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1InMacro(dataSet, dataSet2, 0x189118, 2134355, 0);
    }

    private void frameAnatomyMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1InMacro(dataSet, dataSet2, 2134129, 2134130, "U");
        this.checkType2InMacro(dataSet, dataSet2, 2134129, 533016);
    }

    private void pixelValueTransformationMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1InMacro(dataSet, dataSet2, 2658629, 2625618, 0.0f);
        this.checkType1InMacro(dataSet, dataSet2, 2658629, 2625619, 1.0f);
        this.checkType1InMacro(dataSet, dataSet2, 2658629, 2625620, "US");
    }

    private void commonCTMRImageDescriptionMacro(DataSet dataSet, DataSet dataSet2, int n, ColorModel colorModel) {
        this.checkType1InMacro(dataSet, dataSet2, n, 561669, colorModel instanceof IndexColorModel ? "COLOR" : "MONOCHROME");
        this.checkType1InMacro(dataSet, dataSet2, n, 561670, "VOLUME");
        this.checkType1InMacro(dataSet, dataSet2, n, 561671, "NONE");
    }

    private void MRImageFrameTypeMacro(DataSet dataSet, DataSet dataSet2, ColorModel colorModel) {
        this.checkType1InMacro(dataSet, dataSet2, 1610278, 561159, DEFAULT_ENHMR_IMAGE_TYPE);
        this.commonCTMRImageDescriptionMacro(dataSet, dataSet2, 1610278, colorModel);
        this.checkType1InMacro(dataSet, dataSet2, 1610278, 561672, "MAGNITUDE");
        this.checkType1InMacro(dataSet, dataSet2, 1610278, 561673, "UNKNOWN");
    }

    private void MRTimingAndRelatedParametersMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1610002);
        if ("ORIGINAL".equals(this.getMRFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610002, 0x180080, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610002, 1577748, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610002, 1573009, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610002, 1610304, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610002, 1610305, 0);
        }
    }

    private void MRFOVGeometryMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1610021);
        if ("ORIGINAL".equals(this.getMRFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610021, 1577746, "OTHER");
            this.checkType1InMacro(dataSet, dataSet2, 1610021, 1609816, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610021, 1610289, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610021, 1610289, 0);
            if ("3D".equals(this.ds.findString(1572899))) {
                this.checkType1InMacro(dataSet, dataSet2, 1610021, 1610290, 0);
            }
            this.checkType1InMacro(dataSet, dataSet2, 1610021, 1573011, 100);
            this.checkType1InMacro(dataSet, dataSet2, 1610021, 1573012, 100);
        }
    }

    private void MREchoMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1610004);
        if ("ORIGINAL".equals(this.getMRFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610004, 1609858, 0);
        }
    }

    private void MRModifierMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1610005);
        if ("ORIGINAL".equals(this.getMRFrameTypeValue1(dataSet, dataSet2))) {
            String string;
            this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609737, "NO");
            if ("YES".equals(this.findStringInMacro(dataSet, dataSet2, 1610005, 1609737))) {
                this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609849, 0);
            }
            this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609744, "NONE");
            if (!"NONE".equals(this.findStringInMacro(dataSet, dataSet2, 1610005, 1609744))) {
                this.checkType1InMacro(dataSet, dataSet2, 1610005, 1610115, "OTHER");
            }
            if ("GRADIENT".equals(string = this.ds.findString(1609736)) || "BOTH".equals(string)) {
                this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609750, "NONE");
            }
            this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609761, "NO");
            this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609766, "NONE");
            this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609767, "NONE");
            this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609857, "NO");
            if ("YES".equals(this.findStringInMacro(dataSet, dataSet2, 1610005, 1609857))) {
                this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609782, "PHASE");
            }
            this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609847, "NO");
            if ("YES".equals(this.findStringInMacro(dataSet, dataSet2, 1610005, 1609847))) {
                this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609848, "OTHER");
                this.checkType1InMacro(dataSet, dataSet2, 1610005, 1609833, 1);
                this.checkType1InMacro(dataSet, dataSet2, 1610005, 1610069, 1);
            }
        }
    }

    private void MRImagingModifierMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1609734);
        if ("ORIGINAL".equals(this.getMRFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1609734, 1609760, "NONE");
            this.checkType1InMacro(dataSet, dataSet2, 1609734, 1609762, "NO");
            this.checkType1InMacro(dataSet, dataSet2, 1609734, 1609768, "NONE");
            String string = this.findStringInMacro(dataSet, dataSet2, 1609734, 1609768);
            if ("GRID".equals(string) || "LINE".equals(string)) {
                this.checkType1InMacro(dataSet, dataSet2, 1609734, 1609776, 0);
                this.checkType1InMacro(dataSet, dataSet2, 1609734, 1609753, 0);
                if ("GRID".equals(string)) {
                    this.checkType1InMacro(dataSet, dataSet2, 1609734, 1610264, 0);
                    this.checkType1InMacro(dataSet, dataSet2, 1609734, 1610265, 0);
                }
                this.checkType1InMacro(dataSet, dataSet2, 1609734, 1609781, 0);
            }
            this.checkType1InMacro(dataSet, dataSet2, 1609734, 1609880, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1609734, 1573013, 0);
        }
    }

    private void MRReceiveCoilMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1609794);
        if ("ORIGINAL".equals(this.getMRFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1609794, 1577552, "Unknown");
            this.checkType2InMacro(dataSet, dataSet2, 1609794, 1609793);
            this.checkType1InMacro(dataSet, dataSet2, 1609794, 1609795, "BODY");
            this.checkType1InMacro(dataSet, dataSet2, 1609794, 1609796, "NO");
            if ("MULTICOIL".equals(this.findStringInMacro(dataSet, dataSet2, 1609794, 1609795))) {
                DataSet dataSet3 = new DataSet();
                dataSet3.add(1609799, "Unknown");
                dataSet3.add(1609800, "NO");
                this.checkType1InMacro(dataSet, dataSet2, 1609794, 1609797, dataSet3);
            }
        }
    }

    private void MRTransmitCoilMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1609801);
        if ("ORIGINAL".equals(this.getMRFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1609801, 1577553, "Unknown");
            this.checkType2InMacro(dataSet, dataSet2, 1609801, 1609808);
            this.checkType1InMacro(dataSet, dataSet2, 1609801, 1609809, "BODY");
        }
    }

    private void MRDiffusionMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1610007);
        String[] stringArray = (String[])this.findValueInMacro(dataSet, dataSet2, 1610278, 561159, String;.class);
        if ("ORIGINAL".equals(stringArray[0])) {
            this.checkType1InMacro(dataSet, dataSet2, 1610007, 1609863, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610007, 1609845, "NONE");
        }
        if ("DIRECTIONAL".equals(this.findStringInMacro(dataSet, dataSet2, 1610007, 1609845))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610007, 1609846, new DataSet());
        }
        if ("DIFFUSION_ANISO".equals(stringArray[3])) {
            this.checkType1InMacro(dataSet, dataSet2, 1610007, 1610055, "FRACTIONAL");
        }
    }

    private void MRAveragesMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 0x189119);
        if ("ORIGINAL".equals(this.getMRFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 0x189119, 1572995, 1);
        }
    }

    private void MRSpatialSaturationMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1609991);
    }

    private void MRMetaboliteMapMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1610066);
        if ("ORIGINAL".equals(this.getMRFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610066, 1609856, "Unknown");
        }
    }

    private void MRVelocityEncodingMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1Macro(dataSet, dataSet2, 1610278);
        if ("ORIGINAL".equals(this.getMRFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610135, 1609872, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610135, 1609873, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610135, 1610263, 0);
        }
    }

    private void modMRPulseSeq() {
        String[] stringArray = (String[])this.ds.findValue(524296, String;.class);
        if ("ORIGINAL".equals(stringArray[0]) || "MIXED".equals(stringArray[0])) {
            this.checkType1(1609733, "Unknown");
            this.checkType1(1572899, "2D");
            this.checkType1(1609736, "SPIN");
            String string = this.ds.findString(1609736);
            if ("SPIN".equals(string) || "BOTH".equals(string)) {
                this.checkType1(1609745, "NO");
            }
            this.checkType1(1609746, "NO");
            this.checkType1(1609748, "NO");
            this.checkType1(1609749, "NO");
            this.checkType1(1609751, "NONE");
            this.checkType1(1609752, "NO");
            this.checkType1(1609764, "NO");
            this.checkType1(1609765, "NONE");
            this.checkType1(1609769, "NONE");
            this.checkType1(1609778, "RECTILINEAR");
            if ("RECTILINEAR".equals(this.ds.findString(1609778))) {
                this.checkType1(1609780, "LINEAR");
            }
            this.checkType1(1609779, "FULL");
            if ("3D".equals(this.ds.findString(1572899))) {
                this.checkType1(1609876, "FULL");
            }
            this.checkType1(1609875, 0);
        }
    }

    private void modMultiframeDimension() {
        this.checkType2(2134561);
        this.checkType2(0x209222);
    }

    private void CTImageFrameTypeMacro(DataSet dataSet, DataSet dataSet2, ColorModel colorModel) {
        this.checkType1InMacro(dataSet, dataSet2, 1610537, 561159, DEFAULT_ENHCT_IMAGE_TYPE);
        this.commonCTMRImageDescriptionMacro(dataSet, dataSet2, 1610537, colorModel);
    }

    private void CTAcquisitionTypeMacro(DataSet dataSet, DataSet dataSet2) {
        if ("ORIGINAL".equals(this.getCTFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610497, 1610498, "SEQUENCED");
            if ("CONSTANT_ANGLE".equals(this.findStringInMacro(dataSet, dataSet2, 1610497, 1610498))) {
                this.checkType1InMacro(dataSet, dataSet2, 1610497, 1610499, 0);
            }
            this.checkType1InMacro(dataSet, dataSet2, 1610497, 1610547, "NO");
            this.checkType1InMacro(dataSet, dataSet2, 1610497, 1610548, "NO");
        }
    }

    private void CTAcquisitionDetailsMacro(DataSet dataSet, DataSet dataSet2) {
        if ("ORIGINAL".equals(this.getCTFrameTypeValue1(dataSet, dataSet2))) {
            if (!"CONSTANT_ANGLE".equals(this.findStringInMacro(dataSet, dataSet2, 1610497, 1610498))) {
                this.checkType1InMacro(dataSet, dataSet2, 1610500, 1577280, "CW");
                this.checkType1InMacro(dataSet, dataSet2, 1610500, 1610501, 0);
            }
            this.checkType1InMacro(dataSet, dataSet2, 1610500, 1610502, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610500, 1610503, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610500, 1577264, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610500, 1577248, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610500, 1573008, 0);
        }
    }

    private void CTTableDynamicsMacro(DataSet dataSet, DataSet dataSet2) {
        if ("ORIGINAL".equals(this.getCTFrameTypeValue1(dataSet, dataSet2))) {
            String string = this.findStringInMacro(dataSet, dataSet2, 1610497, 1610498);
            if ("SPIRAL".equals(string) || "CONSTANT_ANGLE".equals(string)) {
                this.checkType1InMacro(dataSet, dataSet2, 1610504, 1610505, 0);
            }
            if ("SPIRAL".equals(string)) {
                this.checkType1InMacro(dataSet, dataSet2, 1610504, 1610512, 0);
                this.checkType1InMacro(dataSet, dataSet2, 1610504, 1610513, 0);
            }
        }
    }

    private void CTPositionMacro(DataSet dataSet, DataSet dataSet2) {
        if ("ORIGINAL".equals(this.getCTFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610534, 1610535, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610534, 1610515, new double[]{0.0, 0.0, 0.0});
            this.checkType1InMacro(dataSet, dataSet2, 1610534, 1610520, new double[]{0.0, 0.0, 0.0});
        }
    }

    private void CTGeometryMacro(DataSet dataSet, DataSet dataSet2) {
        if ("ORIGINAL".equals(this.getCTFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610514, 0x181110, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610514, 1610549, 0);
        }
    }

    private void CTReconstructionMacro(DataSet dataSet, DataSet dataSet2) {
        if ("ORIGINAL".equals(this.getCTFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610516, 1610517, "FILTER_BACK_PROJ");
            this.checkType1InMacro(dataSet, dataSet2, 1610516, 1577488, "Unknown");
            this.checkType1InMacro(dataSet, dataSet2, 1610516, 1610518, "CONSTANT_ANGLE");
            if (this.findValueInMacro(dataSet, dataSet2, 1610516, 1610519, Object;.class) == null) {
                this.checkType1InMacro(dataSet, dataSet2, 1610516, 0x181100, "0");
            }
            this.checkType1InMacro(dataSet, dataSet2, 1610516, 1610530, new double[]{0.0, 0.0});
            this.checkType1InMacro(dataSet, dataSet2, 1610516, 1610521, 360);
            this.checkType1InMacro(dataSet, dataSet2, 1610516, 1610528, "Unknown");
        }
    }

    private void CTExposureMacro(DataSet dataSet, DataSet dataSet2) {
        if ("ORIGINAL".equals(this.getCTFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610529, 1610536, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610529, 1610544, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610529, 1610546, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610529, 1610531, "NONE");
            if (!"NONE".equals(this.findStringInMacro(dataSet, dataSet2, 1610529, 1610531))) {
                this.checkType2InMacro(dataSet, dataSet2, 1610529, 1610532);
            }
        }
        this.checkType2InMacro(dataSet, dataSet2, 1610529, 1610565);
    }

    private void CTXRayDetailsMacro(DataSet dataSet, DataSet dataSet2) {
        if ("ORIGINAL".equals(this.getCTFrameTypeValue1(dataSet, dataSet2))) {
            this.checkType1InMacro(dataSet, dataSet2, 1610533, 1572960, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610533, 1577360, 0);
            this.checkType1InMacro(dataSet, dataSet2, 1610533, 1577312, "NONE");
            this.checkType1InMacro(dataSet, dataSet2, 1610533, 1601616, "LEAD");
        }
    }

    private void CTPixelValueTransformationMacro(DataSet dataSet, DataSet dataSet2) {
        this.checkType1InMacro(dataSet, dataSet2, 2658629, 2625618, 0);
        this.checkType1InMacro(dataSet, dataSet2, 2658629, 2625619, 1.0);
        this.checkType1InMacro(dataSet, dataSet2, 2658629, 2625620, "HU");
    }

    private void modOphthalmicPhotographySeries() {
    }

    private void modOphthalmicPhotographyImage(int n) throws DicomException {
        Object object;
        int n2 = this.ds.findInt(0x280002);
        switch (n2) {
            case 1: {
                this.force(2621444, "MONOCHROME2");
                this.checkType1(0x20500020, "IDENTITY");
                break;
            }
            case 3: {
                object = this.ds.findString(2621444);
                if (!("RGB".equals(object) || "YBR_FULL_422".equals(object) || "YBR_PARTIAL_420".equals(object) || "YBR_ICT".equals(object) || "YBR_RCT".equals(object))) {
                    this.force(2621444, "RGB");
                }
                this.ds.add(2621446, 0);
                break;
            }
            default: {
                throw new DicomException("ProtocoleViolation", "OP images need to be 1 band or 3 bands");
            }
        }
        if (this.ds.findInt(2621696) != n) {
            throw new DicomException("ProtocoleViolation", n + "-bit OP images must be " + n + " bit");
        }
        this.ds.add(2621697, n);
        this.ds.add(2621698, n - 1);
        if (this.ds.findInt(2621699) != 0) {
            throw new DicomException("ProtocoleViolation", "OP images need to be unsigned");
        }
        this.checkType1(524296, DEFAULT_OP_IMAGETYPE);
        if (this.codeSequenceHasItem(2228245, "SRT", "R-1021A")) {
            this.checkType1(2621488, DEFAULT_PIXEL_SPACING);
        }
        object = new Date();
        this.checkType1(524323, object);
        this.checkType1(524339, object);
        String[] stringArray = (String[])this.ds.findValue(524296, String;.class);
        if (stringArray.length > 0 && "ORIGINAL".equals(stringArray[0])) {
            this.checkType1(524330, object);
        }
        if (stringArray.length > 0 && "DERIVED".equals(stringArray[0])) {
            this.checkType2(532754);
        }
        this.checkType1(2629904, "00");
        if ("01".equals(this.ds.findString(2629904))) {
            this.checkType1(0x282112, 1);
            this.checkType1(2629908, "ISO_10918_1");
        }
        this.checkType1(2622209, "NO");
    }

    private void modOphthalmicPhotographicParameters() {
        if (this.ds.findValue(2228245) == null) {
            DataSet dataSet = new DataSet();
            dataSet.add(524544, "R-1021B");
            dataSet.add(524546, "SRT");
            dataSet.add(524548, "External Camera");
            this.coercion(2228245, dataSet);
        }
        this.checkType2(2228246);
        this.checkType2(2228247);
        this.checkType2(2228248);
        this.checkType2(2228249);
        this.checkType2(1601540);
    }

    private void modOphthalmicPhotographyAcquisitionParameters() throws DicomException {
        this.checkType2(0x220005);
        if ("YES".equals(this.ds.findString(0x220005)) && !this.ds.has(0x220006)) {
            throw new DicomException("MissingMandatoryAttribute", "PatientEyeMovementCommandCodeSequence");
        }
        this.checkType2(2228251);
        this.checkType2(0x22000A);
        this.checkType2(0x22000B);
        this.checkType2(0x22000C);
        this.checkType2(0x22000D);
        if ("YES".equals(this.ds.findString(0x22000D))) {
            this.checkType2(2228252);
            this.checkType2(0x22000E);
        }
    }

    private void modOcularRegionImaged() {
        this.checkType1(0x200062, "B");
    }

    private void modSoftCopyPresentationLUT() {
        if (!this.ds.has(542113808)) {
            this.checkType1(0x20500020, "IDENTITY");
        }
    }
}

