/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import java.io.Serializable;

public class PersonName
implements Serializable {
    final String[][] groups = new String[3][];
    private int nb_groups = 0;

    public PersonName() {
    }

    public PersonName(String string) {
        this.groups[0] = new String[]{string, null, null, null, null};
        this.nb_groups = 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PersonName)) {
            return false;
        }
        PersonName personName = (PersonName)object;
        if (this.nb_groups != personName.nb_groups) {
            return false;
        }
        for (int i = 0; i < this.nb_groups; ++i) {
            for (int j = 0; j < 5; ++j) {
                String string = this.groups[i][j];
                if (!(string == null ? personName.groups[i][j] != null : !string.equalsIgnoreCase(personName.groups[i][j]))) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized String toString() {
        if (this.nb_groups == 0) {
            return "";
        }
        String[] stringArray = this.groups[0];
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            if (stringArray[3] != null) {
                stringBuffer.append(stringArray[3]);
            }
            if (stringArray[1] != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(stringArray[1]);
            }
            if (stringArray[2] != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(stringArray[2]);
            }
            if (stringArray[0] != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(stringArray[0].toUpperCase());
            }
            if (stringArray[4] != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[4]);
            }
        }
        return new String(stringBuffer);
    }

    synchronized void encode(StringBuffer stringBuffer) {
        if (this.nb_groups < 1) {
            return;
        }
        stringBuffer.append(this.componentGroup(0));
        for (int i = 1; i < this.nb_groups; ++i) {
            stringBuffer.append('=');
            stringBuffer.append(this.componentGroup(i));
        }
    }

    private synchronized StringBuffer componentGroup(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.groups[n];
        for (n2 = stringArray.length - 1; n2 >= 0 && stringArray[n2] == null; --n2) {
        }
        for (int i = 0; i <= n2; ++i) {
            if (i > 0) {
                stringBuffer.append('^');
            }
            stringBuffer.append(stringArray[i]);
        }
        if (stringBuffer.length() > 64) {
            stringBuffer.setLength(64);
        }
        return stringBuffer;
    }

    public void add(String[] stringArray) {
        this.groups[this.nb_groups++] = stringArray;
    }

    public String[] get(int n) {
        return this.groups[n];
    }

    public void remove(int n) {
        if (n < this.nb_groups) {
            this.groups[n] = null;
            for (int i = n + 1; i < this.nb_groups; ++i) {
                this.groups[i - 1] = this.groups[i];
            }
            this.groups[--this.nb_groups] = null;
        }
    }

    public int size() {
        return this.nb_groups;
    }

    public void set(int n, String[] stringArray) {
        this.groups[n] = stringArray;
    }
}

