/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.DataSetReaderWriter;
import fr.apteryx.imageio.dicom.Modality;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Plugin {
    static final boolean demo = true;
    static final boolean debug = false;
    static final boolean rescaleToFloat = true;
    static final int DICOM_PORT = 104;
    static final int DICOM_TLS_PORT = 2762;
    private static long serial = 0L;
    private static int subserial = 0;
    private static int max_user;
    private static boolean evaluation;
    private static String appli;
    static final String version = "1.10";
    static int ARTIM;
    static boolean serverDaemon;
    static String specificCharacterSet;
    private static final BigInteger modulus;
    private static final BigInteger pub;
    private static HashMap CHARSETS_JAVA_DICOM;

    public static synchronized void setLicenseKey(String string) {
    }

    public static synchronized void setSubSerial(int n) {
        throw new Error("Insufficient License");
    }

    public static synchronized void setApplicationTitle(String string) {
        appli = string;
    }

    static synchronized long getSerial() {
        return serial;
    }

    static synchronized String getSerialString() {
        Plugin.getSerial();
        return subserial == 0 ? String.valueOf(serial) : serial + "." + subserial;
    }

    public static synchronized String getApplicationTitle() {
        return appli;
    }

    public static void setARTIM(int n) {
        ARTIM = n;
    }

    public static boolean serversAreDaemons() {
        return serverDaemon;
    }

    public static void setServersAreDaemons(boolean bl) {
        serverDaemon = bl;
    }

    Plugin() {
    }

    public static void addSupportedSOPClass(String string) {
        Modality.sop2mod.put(string, null);
    }

    public static void removeSupportedSOPClass(String string) {
        Modality.sop2mod.remove(string);
    }

    public static synchronized void setSpecificCharacterSet(String string) throws UnsupportedEncodingException {
        specificCharacterSet = Plugin.userToDicomCharacterSet(string);
    }

    static synchronized String userToDicomCharacterSet(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        String string2 = (String)DataSetReaderWriter.CHARSETS_DICOM_JAVA.get(string = string.toUpperCase());
        if (string2 == null) {
            string2 = Charset.forName(string).name();
            if (CHARSETS_JAVA_DICOM == null) {
                CHARSETS_JAVA_DICOM = new HashMap();
                Iterator iterator = DataSetReaderWriter.CHARSETS_DICOM_JAVA.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    CHARSETS_JAVA_DICOM.put(entry.getValue(), entry.getKey());
                }
            }
            if ((string = (String)CHARSETS_JAVA_DICOM.get(string2)) == null) {
                throw new UnsupportedEncodingException(string2);
            }
        } else if (!Charset.isSupported(string2)) {
            throw new UnsupportedEncodingException(string2);
        }
        return string;
    }

    static {
        appli = "ImageIO Plugin";
        ARTIM = 30000;
        serverDaemon = true;
        specificCharacterSet = "ISO_IR 100";
        pub = null;
        modulus = null;
    }
}

