/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

final class ZipImageInputStream
extends ImageInputStreamImpl {
    final ImageInputStream iis;
    private byte[] singleByteBuf = new byte[1];
    private Inflater inf = new Inflater(false);
    private byte[] buf = new byte[512];

    ZipImageInputStream(ImageInputStream imageInputStream) {
        this.iis = imageInputStream;
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public int read() throws IOException {
        return this.read(this.singleByteBuf, 0, 1) == -1 ? -1 : this.singleByteBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            int n3;
            while ((n3 = this.inf.inflate(byArray, n, n2)) == 0) {
                if (this.inf.finished() || this.inf.needsDictionary()) {
                    return -1;
                }
                if (!this.inf.needsInput()) continue;
                this.fill();
            }
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            String string = dataFormatException.getMessage();
            throw new IOException(string != null ? string : "Invalid ZLIB data format");
        }
    }

    private void fill() throws IOException {
        int n = this.iis.read(this.buf, 0, this.buf.length);
        this.iis.flush();
        if (n == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inf.setInput(this.buf, 0, n);
    }
}

