/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.Loader;
import org.hibernate.loader.custom.CollectionFetchReturn;
import org.hibernate.loader.custom.CollectionReturn;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.EntityFetchReturn;
import org.hibernate.loader.custom.FetchReturn;
import org.hibernate.loader.custom.NonScalarReturn;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.RootReturn;
import org.hibernate.loader.custom.ScalarReturn;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public class CustomLoader
extends Loader {
    private final String sql;
    private final Set querySpaces = new HashSet();
    private final Map namedParameterBindPoints;
    private final Queryable[] entityPersisters;
    private final int[] entiytOwners;
    private final EntityAliases[] entityAliases;
    private final QueryableCollection[] collectionPersisters;
    private final int[] collectionOwners;
    private final CollectionAliases[] collectionAliases;
    private final LockMode[] lockModes;
    private final ResultRowProcessor rowProcessor;
    private Type[] resultTypes;
    private String[] transformerAliases;

    public CustomLoader(CustomQuery customQuery, SessionFactoryImplementor factory) {
        super(factory);
        int i;
        this.sql = customQuery.getSQL();
        this.querySpaces.addAll(customQuery.getQuerySpaces());
        this.namedParameterBindPoints = customQuery.getNamedParameterBindPoints();
        ArrayList<Queryable> entityPersisters = new ArrayList<Queryable>();
        ArrayList<Integer> entityOwners = new ArrayList<Integer>();
        ArrayList<EntityAliases> entityAliases = new ArrayList<EntityAliases>();
        ArrayList<QueryableCollection> collectionPersisters = new ArrayList<QueryableCollection>();
        ArrayList<Integer> collectionOwners = new ArrayList<Integer>();
        ArrayList<CollectionAliases> collectionAliases = new ArrayList<CollectionAliases>();
        ArrayList<LockMode> lockModes = new ArrayList<LockMode>();
        ArrayList<ResultColumnProcessor> resultColumnProcessors = new ArrayList<ResultColumnProcessor>();
        ArrayList<Return> nonScalarReturnList = new ArrayList<Return>();
        ArrayList<Type> resultTypes = new ArrayList<Type>();
        ArrayList<String> specifiedAliases = new ArrayList<String>();
        int returnableCounter = 0;
        boolean hasScalars = false;
        Iterator itr = customQuery.getCustomQueryReturns().iterator();
        while (itr.hasNext()) {
            Queryable ownerPersister;
            NonScalarReturn ownerDescriptor;
            FetchReturn fetchRtn;
            Return rtn = (Return)itr.next();
            if (rtn instanceof ScalarReturn) {
                ScalarReturn scalarRtn = (ScalarReturn)rtn;
                resultTypes.add(scalarRtn.getType());
                specifiedAliases.add(scalarRtn.getColumnAlias());
                resultColumnProcessors.add(new ScalarResultColumnProcessor(scalarRtn.getColumnAlias(), scalarRtn.getType()));
                hasScalars = true;
                continue;
            }
            if (rtn instanceof RootReturn) {
                RootReturn rootRtn = (RootReturn)rtn;
                Queryable persister = (Queryable)factory.getEntityPersister(rootRtn.getEntityName());
                entityPersisters.add(persister);
                lockModes.add(rootRtn.getLockMode());
                resultColumnProcessors.add(new NonScalarResultColumnProcessor(returnableCounter++));
                nonScalarReturnList.add(rtn);
                entityOwners.add(new Integer(-1));
                resultTypes.add(persister.getType());
                specifiedAliases.add(rootRtn.getAlias());
                entityAliases.add(rootRtn.getEntityAliases());
                ArrayHelper.addAll(this.querySpaces, persister.getQuerySpaces());
                continue;
            }
            if (rtn instanceof CollectionReturn) {
                CollectionReturn collRtn = (CollectionReturn)rtn;
                String role = collRtn.getOwnerEntityName() + "." + collRtn.getOwnerProperty();
                QueryableCollection persister = (QueryableCollection)factory.getCollectionPersister(role);
                collectionPersisters.add(persister);
                lockModes.add(collRtn.getLockMode());
                resultColumnProcessors.add(new NonScalarResultColumnProcessor(returnableCounter++));
                nonScalarReturnList.add(rtn);
                collectionOwners.add(new Integer(-1));
                resultTypes.add(persister.getType());
                specifiedAliases.add(collRtn.getAlias());
                collectionAliases.add(collRtn.getCollectionAliases());
                Type elementType = persister.getElementType();
                if (!elementType.isEntityType()) continue;
                Queryable elementPersister = (Queryable)((EntityType)elementType).getAssociatedJoinable(factory);
                entityPersisters.add(elementPersister);
                entityOwners.add(new Integer(-1));
                entityAliases.add(collRtn.getElementEntityAliases());
                ArrayHelper.addAll(this.querySpaces, elementPersister.getQuerySpaces());
                continue;
            }
            if (rtn instanceof EntityFetchReturn) {
                fetchRtn = (EntityFetchReturn)rtn;
                ownerDescriptor = fetchRtn.getOwner();
                int ownerIndex = nonScalarReturnList.indexOf(ownerDescriptor);
                entityOwners.add(new Integer(ownerIndex));
                lockModes.add(fetchRtn.getLockMode());
                ownerPersister = this.determineAppropriateOwnerPersister(ownerDescriptor);
                EntityType fetchedType = (EntityType)ownerPersister.getPropertyType(fetchRtn.getOwnerProperty());
                String entityName = fetchedType.getAssociatedEntityName(this.getFactory());
                Queryable persister = (Queryable)factory.getEntityPersister(entityName);
                entityPersisters.add(persister);
                nonScalarReturnList.add(rtn);
                specifiedAliases.add(fetchRtn.getAlias());
                entityAliases.add(((EntityFetchReturn)fetchRtn).getEntityAliases());
                ArrayHelper.addAll(this.querySpaces, persister.getQuerySpaces());
                continue;
            }
            if (rtn instanceof CollectionFetchReturn) {
                fetchRtn = (CollectionFetchReturn)rtn;
                ownerDescriptor = fetchRtn.getOwner();
                int ownerIndex = nonScalarReturnList.indexOf(ownerDescriptor);
                collectionOwners.add(new Integer(ownerIndex));
                lockModes.add(fetchRtn.getLockMode());
                ownerPersister = this.determineAppropriateOwnerPersister(ownerDescriptor);
                String role = ownerPersister.getEntityName() + '.' + fetchRtn.getOwnerProperty();
                QueryableCollection persister = (QueryableCollection)factory.getCollectionPersister(role);
                collectionPersisters.add(persister);
                nonScalarReturnList.add(rtn);
                specifiedAliases.add(fetchRtn.getAlias());
                collectionAliases.add(((CollectionFetchReturn)fetchRtn).getCollectionAliases());
                Type elementType = persister.getElementType();
                if (!elementType.isEntityType()) continue;
                Queryable elementPersister = (Queryable)((EntityType)elementType).getAssociatedJoinable(factory);
                entityPersisters.add(elementPersister);
                entityOwners.add(new Integer(ownerIndex));
                entityAliases.add(((CollectionFetchReturn)fetchRtn).getElementEntityAliases());
                ArrayHelper.addAll(this.querySpaces, elementPersister.getQuerySpaces());
                continue;
            }
            throw new HibernateException("unexpected custom query return type : " + rtn.getClass().getName());
        }
        this.entityPersisters = new Queryable[entityPersisters.size()];
        for (i = 0; i < entityPersisters.size(); ++i) {
            this.entityPersisters[i] = (Queryable)entityPersisters.get(i);
        }
        this.entiytOwners = ArrayHelper.toIntArray(entityOwners);
        this.entityAliases = new EntityAliases[entityAliases.size()];
        for (i = 0; i < entityAliases.size(); ++i) {
            this.entityAliases[i] = (EntityAliases)entityAliases.get(i);
        }
        this.collectionPersisters = new QueryableCollection[collectionPersisters.size()];
        for (i = 0; i < collectionPersisters.size(); ++i) {
            this.collectionPersisters[i] = (QueryableCollection)collectionPersisters.get(i);
        }
        this.collectionOwners = ArrayHelper.toIntArray(collectionOwners);
        this.collectionAliases = new CollectionAliases[collectionAliases.size()];
        for (i = 0; i < collectionAliases.size(); ++i) {
            this.collectionAliases[i] = (CollectionAliases)collectionAliases.get(i);
        }
        this.lockModes = new LockMode[lockModes.size()];
        for (i = 0; i < lockModes.size(); ++i) {
            this.lockModes[i] = (LockMode)lockModes.get(i);
        }
        this.resultTypes = ArrayHelper.toTypeArray(resultTypes);
        this.transformerAliases = ArrayHelper.toStringArray(specifiedAliases);
        this.rowProcessor = new ResultRowProcessor(hasScalars, resultColumnProcessors.toArray(new ResultColumnProcessor[resultColumnProcessors.size()]));
    }

    private Queryable determineAppropriateOwnerPersister(NonScalarReturn ownerDescriptor) {
        String entityName = null;
        if (ownerDescriptor instanceof RootReturn) {
            entityName = ((RootReturn)ownerDescriptor).getEntityName();
        } else if (ownerDescriptor instanceof CollectionReturn) {
            CollectionReturn collRtn = (CollectionReturn)ownerDescriptor;
            String role = collRtn.getOwnerEntityName() + "." + collRtn.getOwnerProperty();
            CollectionPersister persister = this.getFactory().getCollectionPersister(role);
            EntityType ownerType = (EntityType)persister.getElementType();
            entityName = ownerType.getAssociatedEntityName(this.getFactory());
        } else if (ownerDescriptor instanceof FetchReturn) {
            Type ownerCollectionElementType;
            FetchReturn fetchRtn = (FetchReturn)ownerDescriptor;
            Queryable persister = this.determineAppropriateOwnerPersister(fetchRtn.getOwner());
            Type ownerType = persister.getPropertyType(fetchRtn.getOwnerProperty());
            if (ownerType.isEntityType()) {
                entityName = ((EntityType)ownerType).getAssociatedEntityName(this.getFactory());
            } else if (ownerType.isCollectionType() && (ownerCollectionElementType = ((CollectionType)ownerType).getElementType(this.getFactory())).isEntityType()) {
                entityName = ((EntityType)ownerCollectionElementType).getAssociatedEntityName(this.getFactory());
            }
        }
        if (entityName == null) {
            throw new HibernateException("Could not determine fetch owner : " + ownerDescriptor);
        }
        return (Queryable)this.getFactory().getEntityPersister(entityName);
    }

    protected String getQueryIdentifier() {
        return this.sql;
    }

    protected String getSQLString() {
        return this.sql;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    protected LockMode[] getLockModes(Map lockModesMap) {
        return this.lockModes;
    }

    protected Loadable[] getEntityPersisters() {
        return this.entityPersisters;
    }

    protected CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    protected int[] getCollectionOwners() {
        return this.collectionOwners;
    }

    protected int[] getOwners() {
        return this.entiytOwners;
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        return this.list(session, queryParameters, this.querySpaces, this.resultTypes);
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        return this.scroll(queryParameters, this.resultTypes, CustomLoader.getHolderInstantiator(queryParameters.getResultTransformer(), this.getReturnAliasesForTransformer()), session);
    }

    private static HolderInstantiator getHolderInstantiator(ResultTransformer resultTransformer, String[] queryReturnAliases) {
        if (resultTransformer != null) {
            return HolderInstantiator.NOOP_INSTANTIATOR;
        }
        return new HolderInstantiator(resultTransformer, queryReturnAliases);
    }

    protected Object getResultColumnOrRow(Object[] row, ResultTransformer transformer, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return this.rowProcessor.buildResultRow(row, rs, transformer != null, session);
    }

    protected List getResultList(List results, ResultTransformer resultTransformer) throws QueryException {
        HolderInstantiator holderInstantiator = HolderInstantiator.getHolderInstantiator(null, resultTransformer, this.getReturnAliasesForTransformer());
        if (holderInstantiator.isRequired()) {
            for (int i = 0; i < results.size(); ++i) {
                Object[] row = (Object[])results.get(i);
                Object result = holderInstantiator.instantiate(row);
                results.set(i, result);
            }
            return resultTransformer.transformList(results);
        }
        return results;
    }

    private String[] getReturnAliasesForTransformer() {
        return this.transformerAliases;
    }

    protected EntityAliases[] getEntityAliases() {
        return this.entityAliases;
    }

    protected CollectionAliases[] getCollectionAliases() {
        return this.collectionAliases;
    }

    public int[] getNamedParameterLocs(String name) throws QueryException {
        Object loc = this.namedParameterBindPoints.get(name);
        if (loc == null) {
            throw new QueryException("Named parameter does not appear in Query: " + name, this.sql);
        }
        if (loc instanceof Integer) {
            return new int[]{(Integer)loc};
        }
        return ArrayHelper.toIntArray((List)loc);
    }

    protected void autoDiscoverTypes(ResultSet rs) {
        try {
            Metadata metadata = new Metadata(this.getFactory(), rs);
            ArrayList aliases = new ArrayList();
            ArrayList types = new ArrayList();
            this.rowProcessor.prepareForAutoDiscovery(metadata);
            for (int i = 0; i < this.rowProcessor.columnProcessors.length; ++i) {
                this.rowProcessor.columnProcessors[i].performDiscovery(metadata, types, aliases);
            }
            this.resultTypes = ArrayHelper.toTypeArray(types);
            this.transformerAliases = ArrayHelper.toStringArray(aliases);
        }
        catch (SQLException e) {
            throw new HibernateException("Exception while trying to autodiscover types.", e);
        }
    }

    private static class Metadata {
        private final SessionFactoryImplementor factory;
        private final ResultSet resultSet;
        private final ResultSetMetaData resultSetMetaData;

        public Metadata(SessionFactoryImplementor factory, ResultSet resultSet) throws HibernateException {
            try {
                this.factory = factory;
                this.resultSet = resultSet;
                this.resultSetMetaData = resultSet.getMetaData();
            }
            catch (SQLException e) {
                throw new HibernateException("Could not extract result set metadata", e);
            }
        }

        public int getColumnCount() throws HibernateException {
            try {
                return this.resultSetMetaData.getColumnCount();
            }
            catch (SQLException e) {
                throw new HibernateException("Could not determine result set column count", e);
            }
        }

        public int resolveColumnPosition(String columnName) throws HibernateException {
            try {
                return this.resultSet.findColumn(columnName);
            }
            catch (SQLException e) {
                throw new HibernateException("Could not resolve column name in result set [" + columnName + "]", e);
            }
        }

        public String getColumnName(int position) throws HibernateException {
            try {
                return this.resultSetMetaData.getColumnName(position);
            }
            catch (SQLException e) {
                throw new HibernateException("Could not resolve column name [" + position + "]", e);
            }
        }

        public Type getHibernateType(int columnPos) throws SQLException {
            int columnType = this.resultSetMetaData.getColumnType(columnPos);
            int scale = this.resultSetMetaData.getScale(columnPos);
            int precision = this.resultSetMetaData.getPrecision(columnPos);
            return TypeFactory.heuristicType(this.factory.getDialect().getHibernateTypeName(columnType, precision, precision, scale));
        }
    }

    public class NonScalarResultColumnProcessor
    implements ResultColumnProcessor {
        private final int position;

        public NonScalarResultColumnProcessor(int position) {
            this.position = position;
        }

        public Object extract(Object[] data, ResultSet resultSet, SessionImplementor session) throws SQLException, HibernateException {
            return data[this.position];
        }

        public void performDiscovery(Metadata metadata, List types, List aliases) {
        }
    }

    private static interface ResultColumnProcessor {
        public Object extract(Object[] var1, ResultSet var2, SessionImplementor var3) throws SQLException, HibernateException;

        public void performDiscovery(Metadata var1, List var2, List var3) throws SQLException, HibernateException;
    }

    public class ResultRowProcessor {
        private final boolean hasScalars;
        private ResultColumnProcessor[] columnProcessors;

        public ResultRowProcessor(boolean hasScalars, ResultColumnProcessor[] columnProcessors) {
            this.hasScalars = hasScalars || columnProcessors == null || columnProcessors.length == 0;
            this.columnProcessors = columnProcessors;
        }

        public void prepareForAutoDiscovery(Metadata metadata) throws SQLException {
            if (this.columnProcessors == null || this.columnProcessors.length == 0) {
                int columns = metadata.getColumnCount();
                this.columnProcessors = new ResultColumnProcessor[columns];
                for (int i = 1; i <= columns; ++i) {
                    this.columnProcessors[i - 1] = new ScalarResultColumnProcessor(i);
                }
            }
        }

        public Object buildResultRow(Object[] data, ResultSet resultSet, boolean hasTransformer, SessionImplementor session) throws SQLException, HibernateException {
            Object[] resultRow;
            if (!this.hasScalars) {
                resultRow = data;
            } else {
                resultRow = new Object[this.columnProcessors.length];
                for (int i = 0; i < this.columnProcessors.length; ++i) {
                    resultRow[i] = this.columnProcessors[i].extract(data, resultSet, session);
                }
            }
            return hasTransformer ? resultRow : (resultRow.length == 1 ? resultRow[0] : resultRow);
        }
    }

    public class ScalarResultColumnProcessor
    implements ResultColumnProcessor {
        private int position = -1;
        private String alias;
        private Type type;

        public ScalarResultColumnProcessor(int position) {
            this.position = position;
        }

        public ScalarResultColumnProcessor(String alias, Type type) {
            this.alias = alias;
            this.type = type;
        }

        public Object extract(Object[] data, ResultSet resultSet, SessionImplementor session) throws SQLException, HibernateException {
            return this.type.nullSafeGet(resultSet, this.alias, session, null);
        }

        public void performDiscovery(Metadata metadata, List types, List aliases) throws SQLException {
            if (this.alias == null) {
                this.alias = metadata.getColumnName(this.position);
            } else if (this.position < 0) {
                this.position = metadata.resolveColumnPosition(this.alias);
            }
            if (this.type == null) {
                this.type = metadata.getHibernateType(this.position);
            }
            types.add(this.type);
            aliases.add(this.alias);
        }
    }
}

