/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

import java.util.StringTokenizer;
import org.dcm4che.util.DcmProtocol;

public final class DcmURL {
    public static final int DICOM_PORT = 104;
    private static final int DELIMITER = -1;
    private static final int CALLED_AET = 0;
    private static final int CALLING_AET = 1;
    private static final int HOST = 2;
    private static final int PORT = 3;
    private static final int END = 4;
    private DcmProtocol protocol;
    private String calledAET;
    private String callingAET;
    private String host;
    private int port = 104;

    public DcmURL(String spec) {
        this.parse(spec.trim());
        if (this.calledAET == null) {
            throw new IllegalArgumentException("Missing called AET");
        }
        if (this.host == null) {
            throw new IllegalArgumentException("Missing host name");
        }
    }

    public DcmURL(String protocol, String calledAET, String callingAET, String host, int port) {
        this.protocol = DcmProtocol.valueOf(protocol);
        this.calledAET = calledAET;
        this.callingAET = callingAET;
        this.host = host;
        this.port = port;
    }

    public final String getProtocol() {
        return this.protocol.toString();
    }

    public final String[] getCipherSuites() {
        return this.protocol.getCipherSuites();
    }

    public final boolean isTLS() {
        return this.protocol.isTLS();
    }

    public final String getCallingAET() {
        return this.callingAET;
    }

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.protocol).append("://").append(this.calledAET);
        if (this.callingAET != null) {
            sb.append(':').append(this.callingAET);
        }
        sb.append('@').append(this.host).append(':').append(this.port);
        return sb.toString();
    }

    private void parse(String s) {
        int delimPos = s.indexOf("://");
        if (delimPos == -1) {
            throw new IllegalArgumentException(s);
        }
        this.protocol = DcmProtocol.valueOf(s.substring(0, delimPos));
        StringTokenizer stk = new StringTokenizer(s.substring(delimPos + 3), ":@/", true);
        int state = 0;
        boolean tcpPart = false;
        block11: while (stk.hasMoreTokens()) {
            String tk = stk.nextToken();
            switch (tk.charAt(0)) {
                case ':': {
                    state = tcpPart ? 3 : 1;
                    continue block11;
                }
                case '@': {
                    tcpPart = true;
                    state = 2;
                    continue block11;
                }
                case '/': {
                    return;
                }
            }
            switch (state) {
                case 0: {
                    this.calledAET = tk;
                    break;
                }
                case 1: {
                    this.callingAET = tk;
                    break;
                }
                case 2: {
                    this.host = tk;
                    break;
                }
                case 3: {
                    this.port = Integer.parseInt(tk);
                    return;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            state = -1;
        }
    }
}

