/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

public class MLLP_Protocol {
    public static final MLLP_Protocol MLLP = new MLLP_Protocol("mllp", null);
    public static final MLLP_Protocol MLLP_TLS = new MLLP_Protocol("mllp-tls", new String[]{"SSL_RSA_WITH_NULL_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"});
    public static final MLLP_Protocol MLLP_TLS_3DES = new MLLP_Protocol("mllp-tls.3des", new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA"});
    public static final MLLP_Protocol MLLP_TLS_AES = new MLLP_Protocol("mllp-tls.3des", new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"});
    public static final MLLP_Protocol MLLP_TLS_NODES = new MLLP_Protocol("mllp-tls.nodes", new String[]{"SSL_RSA_WITH_NULL_SHA"});
    private final String name;
    private final String[] cipherSuites;

    public static MLLP_Protocol valueOf(String protocol) {
        String lower = protocol.toLowerCase();
        if (lower.equals("mllp")) {
            return MLLP;
        }
        if (lower.equals("mllp-tls")) {
            return MLLP_TLS;
        }
        if (lower.equals("mllp-tls.3des")) {
            return MLLP_TLS_3DES;
        }
        if (lower.equals("mllp-tls.aes")) {
            return MLLP_TLS_AES;
        }
        if (lower.equals("mllp-tls.nodes")) {
            return MLLP_TLS_NODES;
        }
        throw new IllegalArgumentException("protocol:" + protocol);
    }

    private MLLP_Protocol(String name, String[] cipherSuites) {
        this.name = name;
        this.cipherSuites = cipherSuites;
    }

    public String toString() {
        return this.name;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites == null ? null : (String[])this.cipherSuites.clone();
    }

    public boolean isTLS() {
        return this.cipherSuites != null;
    }
}

