/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.DcmElementImpl;
import org.dcm4cheri.util.StringUtils;

abstract class FragmentElement
extends DcmElementImpl {
    private final ArrayList list = new ArrayList();

    public FragmentElement(int tag) {
        super(tag);
    }

    public final int vm(SpecificCharacterSet cs) {
        return this.list.size();
    }

    public final int countItems() {
        return this.list.size();
    }

    public final boolean hasDataFragments() {
        return true;
    }

    public final ByteBuffer getDataFragment(int index) {
        return index < this.list.size() ? (ByteBuffer)this.list.get(index) : null;
    }

    public final ByteBuffer getDataFragment(int index, ByteOrder byteOrder) {
        ByteBuffer data = this.getDataFragment(index);
        if (data != null && data.order() != byteOrder) {
            this.swapOrder(data);
        }
        return data;
    }

    public final int getDataFragmentLength(int index) {
        return ((ByteBuffer)this.list.get(index)).limit() + 1 & 0xFFFFFFFE;
    }

    public String getString(int index, Charset cs) {
        return this.getBoundedString(Integer.MAX_VALUE, index, cs);
    }

    public String getBoundedString(int maxLen, int index, Charset cs) {
        return index < this.list.size() ? StringUtils.promptValue(this.vr(), (ByteBuffer)this.list.get(index), maxLen) : null;
    }

    public String[] getStrings(Charset cs) {
        return this.getBoundedStrings(Integer.MAX_VALUE, cs);
    }

    public String[] getBoundedStrings(int maxLen, Charset cs) {
        String[] a = new String[this.list.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = StringUtils.promptValue(this.vr(), (ByteBuffer)this.list.get(i), maxLen);
        }
        return a;
    }

    int calcLength() {
        int len = 8;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            len += this.getDataFragmentLength(i) + 8;
        }
        return len;
    }

    public void addDataFragment(ByteBuffer data) {
        this.list.add(data != null ? data : EMPTY_VALUE);
    }

    protected void swapOrder(ByteBuffer data) {
        data.order(FragmentElement.swap(data.order()));
    }

    public static DcmElement createOB(int tag) {
        return new OB(tag);
    }

    public static DcmElement createOF(int tag) {
        return new OF(tag);
    }

    public static DcmElement createOW(int tag) {
        return new OW(tag);
    }

    public static DcmElement createUN(int tag) {
        return new UN(tag);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(DICT.toString(this.tag));
        sb.append(",").append(VRs.toString(this.vr()));
        if (!this.isEmpty()) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                sb.append("\n\tFrag-").append(i + 1).append(",#").append(this.getDataFragmentLength(i)).append("[").append(StringUtils.promptValue(this.vr(), (ByteBuffer)this.list.get(i), 64)).append("]");
            }
        }
        return sb.toString();
    }

    private static final class UN
    extends FragmentElement {
        UN(int tag) {
            super(tag);
        }

        public final int vr() {
            return 21838;
        }
    }

    private static final class OW
    extends FragmentElement {
        OW(int tag) {
            super(tag);
        }

        public final int vr() {
            return 20311;
        }

        public void addDataFragment(ByteBuffer data) {
            if ((data.limit() & 1) != 0) {
                log.warn("Ignore odd length fragment of " + Tags.toString(this.tag) + " OW #" + data.limit());
                data = null;
            }
            super.addDataFragment(data);
        }

        protected void swapOrder(ByteBuffer data) {
            OW.swapWords(data);
        }
    }

    private static final class OF
    extends FragmentElement {
        OF(int tag) {
            super(tag);
        }

        public final int vr() {
            return 20294;
        }

        public void addDataFragment(ByteBuffer data) {
            if ((data.limit() & 3) != 0) {
                log.warn("Ignore odd length fragment of " + Tags.toString(this.tag) + " OF #" + data.limit());
                data = null;
            }
            super.addDataFragment(data);
        }

        protected void swapOrder(ByteBuffer data) {
            OF.swapInts(data);
        }
    }

    private static final class OB
    extends FragmentElement {
        OB(int tag) {
            super(tag);
        }

        public final int vr() {
            return 20290;
        }
    }
}

