/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.WeakHashMap;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4che.dict.Tags;
import org.dcm4cheri.data.DcmElementImpl;
import org.dcm4cheri.util.StringUtils;

abstract class ValueElement
extends DcmElementImpl {
    private static final WeakHashMap whm = new WeakHashMap();
    protected final ByteBuffer data;

    ValueElement(int tag, ByteBuffer data) {
        super(tag);
        this.data = data;
    }

    public int hashCode() {
        if (this.data == null || this.data.limit() == 0) {
            return this.tag;
        }
        return this.tag ^ this.data.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueElement)) {
            return false;
        }
        ValueElement ve = (ValueElement)o;
        if (this.tag != ve.tag) {
            return false;
        }
        if (this.data == null || this.data.limit() == 0) {
            return ve.data == null || ve.data.limit() == 0;
        }
        if (ve.data == null || ve.data.limit() == 0) {
            return false;
        }
        return this.data.equals(ve.data);
    }

    public DcmElement share() {
        DcmElement e;
        WeakReference wr = (WeakReference)whm.get(this);
        if (wr != null && (e = (DcmElement)wr.get()) != null) {
            return e;
        }
        this.streamPos = -1L;
        whm.put(this, new WeakReference<ValueElement>(this));
        return this;
    }

    public final int length() {
        return this.data.limit() + 1 & 0xFFFFFFFE;
    }

    public final boolean isEmpty() {
        return this.data.limit() == 0;
    }

    public final ByteBuffer getByteBuffer() {
        return this.data.duplicate().order(this.data.order());
    }

    public final ByteBuffer getByteBuffer(ByteOrder byteOrder) {
        if (this.data.order() != byteOrder) {
            this.swapOrder();
        }
        return this.getByteBuffer();
    }

    public int vm(SpecificCharacterSet cs) {
        return this.data.limit() == 0 ? 0 : 1;
    }

    public String getString(int index, SpecificCharacterSet cs) throws DcmValueException {
        return index < this.vm(null) ? Integer.toString(this.getInt(index)) : null;
    }

    public String[] getStrings(SpecificCharacterSet cs) throws DcmValueException {
        String[] ss = new String[this.vm(null)];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = Integer.toString(this.getInt(i));
        }
        return ss;
    }

    protected void swapOrder() {
        this.data.order(ValueElement.swap(this.data.order()));
    }

    private static ByteBuffer setShort(int v) {
        return ByteBuffer.wrap(new byte[2]).order(ByteOrder.LITTLE_ENDIAN).putShort(0, (short)v);
    }

    private static ByteBuffer setShorts(int[] a) {
        if (a.length == 0) {
            return EMPTY_VALUE;
        }
        if (a.length == 1) {
            return ValueElement.setShort(a[0]);
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[a.length << 1]).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < a.length; ++i) {
            bb.putShort((short)a[i]);
        }
        bb.rewind();
        return bb;
    }

    static DcmElement createSS(int tag, ByteBuffer data) {
        if ((data.limit() & 1) != 0) {
            log.warn("Ignore illegal value of " + Tags.toString(tag) + " SS #" + data.limit());
            return new SS(tag, EMPTY_VALUE);
        }
        return new SS(tag, data);
    }

    static DcmElement createSS(int tag) {
        return new SS(tag, EMPTY_VALUE);
    }

    static DcmElement createSS(int tag, int v) {
        return new SS(tag, ValueElement.setShort(v));
    }

    static DcmElement createSS(int tag, int[] a) {
        return new SS(tag, ValueElement.setShorts(a));
    }

    static DcmElement createUS(int tag, ByteBuffer data) {
        if ((data.limit() & 1) != 0) {
            log.warn("Ignore illegal value of " + Tags.toString(tag) + " US #" + data.limit());
            return new US(tag, EMPTY_VALUE);
        }
        return new US(tag, data);
    }

    static DcmElement createUS(int tag) {
        return new US(tag, EMPTY_VALUE);
    }

    static DcmElement createUS(int tag, int s) {
        return new US(tag, ValueElement.setShort(s));
    }

    static DcmElement createUS(int tag, int[] s) {
        return new US(tag, ValueElement.setShorts(s));
    }

    private static ByteBuffer setInt(int v) {
        return ByteBuffer.wrap(new byte[4]).order(ByteOrder.LITTLE_ENDIAN).putInt(0, v);
    }

    private static ByteBuffer setInts(int[] a) {
        if (a.length == 0) {
            return EMPTY_VALUE;
        }
        if (a.length == 1) {
            return ValueElement.setInt(a[0]);
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[a.length << 2]).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < a.length; ++i) {
            bb.putInt(a[i]);
        }
        bb.rewind();
        return bb;
    }

    static DcmElement createSL(int tag, ByteBuffer data) {
        if ((data.limit() & 3) != 0) {
            log.warn("Ignore illegal value of " + Tags.toString(tag) + " SL #" + data.limit());
            return new SL(tag, EMPTY_VALUE);
        }
        return new SL(tag, data);
    }

    static DcmElement createSL(int tag) {
        return new SL(tag, EMPTY_VALUE);
    }

    static DcmElement createSL(int tag, int v) {
        return new SL(tag, ValueElement.setInt(v));
    }

    static DcmElement createSL(int tag, int[] a) {
        return new SL(tag, ValueElement.setInts(a));
    }

    static DcmElement createUL(int tag, ByteBuffer data) {
        if ((data.limit() & 3) != 0) {
            log.warn("Ignore illegal value of " + Tags.toString(tag) + " UL #" + data.limit());
            return new UL(tag, EMPTY_VALUE);
        }
        return new UL(tag, data);
    }

    static DcmElement createUL(int tag) {
        return new UL(tag, EMPTY_VALUE);
    }

    static DcmElement createUL(int tag, int v) {
        return new UL(tag, ValueElement.setInt(v));
    }

    static DcmElement createUL(int tag, int[] a) {
        return new UL(tag, ValueElement.setInts(a));
    }

    private static ByteBuffer setTag(int v) {
        return ByteBuffer.wrap(new byte[4]).order(ByteOrder.LITTLE_ENDIAN).putShort(0, (short)(v >> 16)).putShort(2, (short)v);
    }

    private static ByteBuffer setTags(int[] a) {
        if (a.length == 0) {
            return EMPTY_VALUE;
        }
        if (a.length == 1) {
            return ValueElement.setTag(a[0]);
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[a.length << 2]).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < a.length; ++i) {
            bb.putShort((short)(a[i] >> 16)).putShort((short)a[i]);
        }
        bb.rewind();
        return bb;
    }

    static DcmElement createAT(int tag, ByteBuffer data) {
        if ((data.limit() & 3) != 0) {
            log.warn("Ignore illegal value of " + Tags.toString(tag) + " AT #" + data.limit());
            return new AT(tag, EMPTY_VALUE);
        }
        return new AT(tag, data);
    }

    static DcmElement createAT(int tag) {
        return new AT(tag, EMPTY_VALUE);
    }

    static DcmElement createAT(int tag, int v) {
        return new AT(tag, ValueElement.setTag(v));
    }

    static DcmElement createAT(int tag, int[] a) {
        return new AT(tag, ValueElement.setTags(a));
    }

    private static ByteBuffer setFloat(float v) {
        return ByteBuffer.wrap(new byte[4]).order(ByteOrder.LITTLE_ENDIAN).putFloat(0, v);
    }

    private static ByteBuffer setFloats(float[] a) {
        if (a.length == 0) {
            return EMPTY_VALUE;
        }
        if (a.length == 1) {
            return ValueElement.setFloat(a[0]);
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[a.length << 2]).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < a.length; ++i) {
            bb.putFloat(a[i]);
        }
        bb.rewind();
        return bb;
    }

    static DcmElement createFL(int tag, ByteBuffer data) {
        if ((data.limit() & 3) != 0) {
            log.warn("Ignore illegal value of " + Tags.toString(tag) + " FL #" + data.limit());
            return new FL(tag, EMPTY_VALUE);
        }
        return new FL(tag, data);
    }

    static DcmElement createFL(int tag) {
        return new FL(tag, EMPTY_VALUE);
    }

    static DcmElement createFL(int tag, float v) {
        return new FL(tag, ValueElement.setFloat(v));
    }

    static DcmElement createFL(int tag, float[] a) {
        return new FL(tag, ValueElement.setFloats(a));
    }

    private static ByteBuffer setDouble(double v) {
        return ByteBuffer.wrap(new byte[8]).order(ByteOrder.LITTLE_ENDIAN).putDouble(0, v);
    }

    private static ByteBuffer setDoubles(double[] a) {
        if (a.length == 0) {
            return EMPTY_VALUE;
        }
        if (a.length == 1) {
            return ValueElement.setDouble(a[0]);
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[a.length << 3]).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < a.length; ++i) {
            bb.putDouble(a[i]);
        }
        bb.rewind();
        return bb;
    }

    static DcmElement createFD(int tag, ByteBuffer data) {
        if ((data.limit() & 7) != 0) {
            log.warn("Ignore illegal value of " + Tags.toString(tag) + " FD #" + data.limit());
            return new FD(tag, EMPTY_VALUE);
        }
        return new FD(tag, data);
    }

    static DcmElement createFD(int tag) {
        return new FD(tag, EMPTY_VALUE);
    }

    static DcmElement createFD(int tag, double v) {
        return new FD(tag, ValueElement.setDouble(v));
    }

    static DcmElement createFD(int tag, double[] a) {
        return new FD(tag, ValueElement.setDoubles(a));
    }

    static DcmElement createOF(int tag) {
        return new OF(tag, EMPTY_VALUE);
    }

    static DcmElement createOF(int tag, float[] v) {
        ByteBuffer buf = ByteBuffer.allocate(v.length << 2);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < v.length; ++i) {
            buf.putFloat(v[i]);
        }
        buf.rewind();
        return new OF(tag, buf);
    }

    static DcmElement createOF(int tag, ByteBuffer data) {
        if ((data.limit() & 3) != 0) {
            log.warn("Ignore illegal value of " + Tags.toString(tag) + " OW #" + data.limit());
            return new OF(tag, EMPTY_VALUE);
        }
        return new OF(tag, data);
    }

    static DcmElement createOW(int tag) {
        return new OW(tag, EMPTY_VALUE);
    }

    static DcmElement createOW(int tag, short[] v) {
        ByteBuffer buf = ByteBuffer.allocate(v.length << 1);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < v.length; ++i) {
            buf.putShort(v[i]);
        }
        buf.rewind();
        return new OW(tag, buf);
    }

    static DcmElement createOW(int tag, ByteBuffer data) {
        if ((data.limit() & 1) != 0) {
            log.warn("Ignore illegal value of " + Tags.toString(tag) + " OW #" + data.limit());
            return new OW(tag, EMPTY_VALUE);
        }
        return new OW(tag, data);
    }

    static DcmElement createOB(int tag) {
        return new OB(tag, EMPTY_VALUE);
    }

    static DcmElement createOB(int tag, ByteBuffer v) {
        return new OB(tag, v);
    }

    static DcmElement createOB(int tag, byte[] v) {
        return new OB(tag, ByteBuffer.wrap(v).order(ByteOrder.LITTLE_ENDIAN));
    }

    static DcmElement createUN(int tag) {
        return new UN(tag, EMPTY_VALUE);
    }

    static DcmElement createUN(int tag, ByteBuffer v) {
        return new UN(tag, v);
    }

    static DcmElement createUN(int tag, byte[] v) {
        return new UN(tag, ByteBuffer.wrap(v).order(ByteOrder.LITTLE_ENDIAN));
    }

    private static final class UN
    extends ValueElement {
        UN(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vr() {
            return 21838;
        }

        public String getString(int index, SpecificCharacterSet cs) {
            return this.getBoundedString(Integer.MAX_VALUE, index, cs);
        }

        public String getBoundedString(int maxLen, int index, SpecificCharacterSet cs) {
            return index < this.vm(null) ? StringUtils.promptOB(this.getByteBuffer(), maxLen) : null;
        }

        public String[] getStrings(SpecificCharacterSet cs) throws DcmValueException {
            return this.getBoundedStrings(Integer.MAX_VALUE, cs);
        }

        public String[] getBoundedStrings(int maxLen, SpecificCharacterSet cs) {
            String[] a = new String[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = StringUtils.promptOB(this.getByteBuffer(), maxLen);
            }
            return a;
        }
    }

    private static final class OB
    extends ValueElement {
        OB(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vr() {
            return 20290;
        }

        public String getString(int index, SpecificCharacterSet cs) {
            return this.getBoundedString(Integer.MAX_VALUE, index, cs);
        }

        public String getBoundedString(int maxLen, int index, SpecificCharacterSet cs) {
            return index < this.vm(null) ? StringUtils.promptOB(this.getByteBuffer(), maxLen) : null;
        }

        public String[] getStrings(SpecificCharacterSet cs) {
            return this.getBoundedStrings(Integer.MAX_VALUE, cs);
        }

        public String[] getBoundedStrings(int maxLen, SpecificCharacterSet cs) {
            String[] a = new String[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = StringUtils.promptOB(this.getByteBuffer(), maxLen);
            }
            return a;
        }
    }

    private static final class OW
    extends ValueElement {
        OW(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vr() {
            return 20311;
        }

        public final int getInt(int index) {
            return index < this.data.limit() >> 1 ? this.data.getShort(index << 1) & 0xFFFF : 0;
        }

        public final int[] getInts() {
            int[] a = new int[this.data.limit() >> 1];
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.data.getShort(i << 1) & 0xFFFF;
            }
            return a;
        }

        public String getString(int index, SpecificCharacterSet cs) {
            return this.getBoundedString(Integer.MAX_VALUE, index, cs);
        }

        public String getBoundedString(int maxLen, int index, SpecificCharacterSet cs) {
            return index < this.vm(null) ? StringUtils.promptOW(this.getByteBuffer(), maxLen) : null;
        }

        public String[] getStrings(SpecificCharacterSet cs) {
            return this.getBoundedStrings(Integer.MAX_VALUE, cs);
        }

        public String[] getBoundedStrings(int maxLen, SpecificCharacterSet cs) {
            String[] a = new String[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = StringUtils.promptOW(this.getByteBuffer(), maxLen);
            }
            return a;
        }

        protected void swapOrder() {
            OW.swapWords(this.data);
        }
    }

    private static final class OF
    extends ValueElement {
        OF(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vr() {
            return 20294;
        }

        public final float getFloat(int index) {
            return index < this.data.limit() >> 2 ? this.data.getFloat(index << 2) : 0.0f;
        }

        public final float[] getFloats() {
            float[] a = new float[this.data.limit() >> 2];
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.data.getFloat(i << 2);
            }
            return a;
        }

        public String getString(int index, SpecificCharacterSet cs) {
            return this.getBoundedString(Integer.MAX_VALUE, index, cs);
        }

        public String getBoundedString(int maxLen, int index, SpecificCharacterSet cs) {
            return index < this.vm(null) ? StringUtils.promptOF(this.getByteBuffer(), maxLen) : null;
        }

        public String[] getStrings(SpecificCharacterSet cs) throws DcmValueException {
            return this.getBoundedStrings(Integer.MAX_VALUE, cs);
        }

        public String[] getBoundedStrings(int maxLen, SpecificCharacterSet cs) {
            String[] a = new String[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = StringUtils.promptOF(this.getByteBuffer(), maxLen);
            }
            return a;
        }

        protected void swapOrder() {
            OF.swapInts(this.data);
        }
    }

    private static final class FD
    extends ValueElement {
        FD(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vm(SpecificCharacterSet cs) {
            return this.data.limit() >>> 3;
        }

        public final int vr() {
            return 17988;
        }

        public final double getDouble(int index) {
            return index < this.vm(null) ? this.data.getDouble(index << 3) : 0.0;
        }

        public final double[] getDoubles() {
            double[] a = new double[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.data.getDouble(i << 3);
            }
            return a;
        }

        public String getString(int index, SpecificCharacterSet cs) {
            return index < this.vm(null) ? Double.toString(this.data.getDouble(index << 3)) : null;
        }

        public String[] getStrings(SpecificCharacterSet cs) throws DcmValueException {
            String[] a = new String[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = Double.toString(this.data.getDouble(i << 3));
            }
            return a;
        }

        protected void swapOrder() {
            FD.swapLongs(this.data);
        }

        protected boolean matchValue(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS, SpecificCharacterSet dsCS) {
            double v;
            try {
                v = key.getDouble();
            }
            catch (DcmValueException e) {
                throw new IllegalArgumentException("key: " + key);
            }
            int n = this.vm(null);
            for (int i = 0; i < n; ++i) {
                if (this.data.getDouble(i << 3) != v) continue;
                return true;
            }
            return false;
        }
    }

    private static final class FL
    extends ValueElement {
        FL(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vm(SpecificCharacterSet cs) {
            return this.data.limit() >> 2;
        }

        public final int vr() {
            return 17996;
        }

        public final float getFloat(int index) {
            return index < this.vm(null) ? this.data.getFloat(index << 2) : 0.0f;
        }

        public final float[] getFloats() {
            float[] a = new float[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.data.getFloat(i << 2);
            }
            return a;
        }

        public String getString(int index, SpecificCharacterSet cs) {
            return index < this.vm(null) ? Float.toString(this.data.getFloat(index << 2)) : null;
        }

        public String[] getStrings(SpecificCharacterSet cs) throws DcmValueException {
            String[] a = new String[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = Float.toString(this.data.getFloat(i << 2));
            }
            return a;
        }

        protected void swapOrder() {
            FL.swapInts(this.data);
        }

        protected boolean matchValue(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS, SpecificCharacterSet dsCS) {
            float v;
            try {
                v = key.getFloat();
            }
            catch (DcmValueException e) {
                throw new IllegalArgumentException("key: " + key);
            }
            int n = this.vm(null);
            for (int i = 0; i < n; ++i) {
                if (this.data.getFloat(i << 2) != v) continue;
                return true;
            }
            return false;
        }
    }

    private static final class AT
    extends ValueElement {
        AT(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vr() {
            return 16724;
        }

        public final int vm(SpecificCharacterSet cs) {
            return this.data.limit() >> 2;
        }

        public final int getTag(int index) {
            return index < this.vm(null) ? this.toTag(index) : 0;
        }

        public final int[] getTags() {
            int[] a = new int[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.toTag(i);
            }
            return a;
        }

        private final int toTag(int i) {
            return this.data.getShort(i << 2) << 16 | this.data.getShort((i << 2) + 2) & 0xFFFF;
        }

        public String getString(int index, SpecificCharacterSet cs) throws DcmValueException {
            return index < this.vm(null) ? Tags.toHexString(this.toTag(index), 8) : null;
        }

        public String[] getStrings(SpecificCharacterSet cs) throws DcmValueException {
            String[] a = new String[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = Tags.toHexString(this.toTag(i), 8);
            }
            return a;
        }

        protected void swapOrder() {
            AT.swapWords(this.data);
        }

        protected boolean matchValue(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS, SpecificCharacterSet dsCS) {
            int v;
            try {
                v = key.getTag();
            }
            catch (DcmValueException e) {
                throw new IllegalArgumentException("key: " + key);
            }
            int n = this.vm(null);
            for (int i = 0; i < n; ++i) {
                if (this.getTag(i) != v) continue;
                return true;
            }
            return false;
        }
    }

    static class UL
    extends Int {
        UL(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vr() {
            return 21836;
        }

        public String getString(int index, SpecificCharacterSet cs) throws DcmValueException {
            return index < this.vm(null) ? Long.toString((long)this.getInt(index) & 0xFFFFFFFFL) : null;
        }

        public String[] getStrings(SpecificCharacterSet cs) throws DcmValueException {
            String[] ss = new String[this.vm(null)];
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = Long.toString((long)this.getInt(i) & 0xFFFFFFFFL);
            }
            return ss;
        }
    }

    private static class SL
    extends Int {
        SL(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vr() {
            return 21324;
        }
    }

    private static abstract class Int
    extends ValueElement {
        Int(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vm(SpecificCharacterSet cs) {
            return this.data.limit() >> 2;
        }

        public final int getInt(int index) {
            return index < this.vm(null) ? this.data.getInt(index << 2) : 0;
        }

        public final int[] getInts() {
            int[] a = new int[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.data.getInt(i << 2);
            }
            return a;
        }

        protected void swapOrder() {
            Int.swapInts(this.data);
        }

        protected boolean matchValue(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS, SpecificCharacterSet dsCS) {
            int v;
            try {
                v = key.getInt();
            }
            catch (DcmValueException e) {
                throw new IllegalArgumentException("key: " + key);
            }
            int n = this.data.limit() >> 2;
            for (int i = 0; i < n; ++i) {
                if (this.data.getInt(i >> 2) != v) continue;
                return true;
            }
            return false;
        }
    }

    private static final class US
    extends ValueElement {
        US(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vr() {
            return 21843;
        }

        public final int vm(SpecificCharacterSet cs) {
            return this.data.limit() >> 1;
        }

        public final int getInt(int index) {
            return index < this.vm(null) ? this.data.getShort(index << 1) & 0xFFFF : 0;
        }

        public final int[] getInts() {
            int[] a = new int[this.data.limit() >> 1];
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.data.getShort(i << 1) & 0xFFFF;
            }
            return a;
        }

        protected void swapOrder() {
            US.swapWords(this.data);
        }

        protected boolean matchValue(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS, SpecificCharacterSet dsCS) {
            int v;
            try {
                v = key.getInt();
            }
            catch (DcmValueException e) {
                throw new IllegalArgumentException("key: " + key);
            }
            int n = this.data.limit() >> 1;
            for (int i = 0; i < n; ++i) {
                if ((this.data.getShort(i >> 1) & 0xFFFF) != v) continue;
                return true;
            }
            return false;
        }
    }

    private static final class SS
    extends ValueElement {
        SS(int tag, ByteBuffer data) {
            super(tag, data);
        }

        public final int vr() {
            return 21331;
        }

        public final int vm(SpecificCharacterSet cs) {
            return this.data.limit() >> 1;
        }

        public final int getInt(int index) {
            return index < this.vm(null) ? (int)this.data.getShort(index << 1) : 0;
        }

        public final int[] getInts() {
            int[] a = new int[this.vm(null)];
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.data.getShort(i << 1);
            }
            return a;
        }

        protected void swapOrder() {
            SS.swapWords(this.data);
        }

        protected boolean matchValue(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS, SpecificCharacterSet dsCS) {
            int v;
            try {
                v = key.getInt();
            }
            catch (DcmValueException e) {
                throw new IllegalArgumentException("key: " + key);
            }
            int n = this.data.limit() >> 1;
            for (int i = 0; i < n; ++i) {
                if (this.data.getShort(i >> 1) != v) continue;
                return true;
            }
            return false;
        }
    }
}

