/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.dict;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4cheri.dict.UIDDictionaryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class UIDDictionaryLoader
extends DefaultHandler {
    private final UIDDictionaryImpl dict;
    private final SAXParser parser;

    public UIDDictionaryLoader(UIDDictionaryImpl dict) {
        this.dict = dict;
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception ex) {
            throw new ConfigurationError("Could not create SAX Parser", ex);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        if ("uid".equals(qName)) {
            this.dict.add(new UIDDictionary.Entry(attr.getValue("value"), attr.getValue("name")));
        }
    }

    public void parse(InputSource xmlSource) throws SAXException, IOException {
        this.parser.parse(xmlSource, (DefaultHandler)this);
    }

    public void parse(File xmlFile) throws SAXException, IOException {
        this.parser.parse(xmlFile, (DefaultHandler)this);
    }

    static class ConfigurationError
    extends Error {
        ConfigurationError(String msg, Exception x) {
            super(msg, x);
        }
    }
}

