/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import com.sun.media.imageio.stream.SegmentedImageInputStream;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.FileFormat;
import org.dcm4che.image.ColorModelFactory;
import org.dcm4che.image.ColorModelParam;
import org.dcm4che.imageio.plugins.DcmImageReadParam;
import org.dcm4cheri.image.ImageReaderFactory;
import org.dcm4cheri.image.ItemParser;
import org.dcm4cheri.imageio.plugins.DcmImageReadParamImpl;
import org.dcm4cheri.imageio.plugins.DcmMetadataImpl;
import org.dcm4cheri.imageio.plugins.SimpleYBRColorSpace;

public class DcmImageReader
extends ImageReader {
    private static final Logger log = Logger.getLogger(DcmImageReader.class);
    private static final String J2KIMAGE_READER = "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader";
    private static final ColorModelFactory cmFactory = ColorModelFactory.getInstance();
    private ImageInputStream stream = null;
    private ImageReader decompressor = null;
    private ItemParser itemParser = null;
    private BufferedImage theImage = null;
    private WritableRaster theTile = null;
    private DcmParser theParser = null;
    private DcmMetadataImpl theMetadata = null;
    private Dataset theDataset = null;
    private long frame1StartPos;
    private int frameLength;
    private int width = -1;
    private int height = -1;
    private int planes = 0;
    private int samplesPerPixel = 1;
    private int numberOfFrames = 0;
    private String pmi = null;
    private boolean ybr2rgb = false;
    private ColorModelParam cmParam;
    private int dataType = 0;
    private int stored = 0;
    private float aspectRatio = 0.0f;
    private int sourceXOffset;
    private int sourceYOffset;
    private int sourceWidth;
    private int sourceHeight;
    private int sourceXSubsampling;
    private int sourceYSubsampling;
    private int subsamplingXOffset;
    private int subsamplingYOffset;
    private int destXOffset;
    private int destYOffset;
    private int destWidth;
    private int totDestWidth;
    private int totDestHeight;
    private static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private static final ColorSpace CS_YBR_FULL = SimpleYBRColorSpace.createYBRFullColorSpace();
    private static final ColorSpace CS_YBR_PARTIAL = SimpleYBRColorSpace.createYBRPartialColorSpace();
    private static final ImageTypeSpecifier YBR_FULL_PLANE = ImageTypeSpecifier.createBanded(CS_YBR_FULL, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 0, false, false);
    private static final ImageTypeSpecifier YBR_FULL_PIXEL = ImageTypeSpecifier.createInterleaved(CS_YBR_FULL, new int[]{0, 1, 2}, 0, false, false);
    private static final ImageTypeSpecifier YBR_PARTIAL_PLANE = ImageTypeSpecifier.createBanded(CS_YBR_PARTIAL, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 0, false, false);
    private static final ImageTypeSpecifier YBR_PARTIAL_PIXEL = ImageTypeSpecifier.createInterleaved(CS_YBR_PARTIAL, new int[]{0, 1, 2}, 0, false, false);
    private static final ImageTypeSpecifier RGB_PLANE = ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 0, false, false);
    private static final ImageTypeSpecifier RGB_PIXEL = ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2}, 0, false, false);

    public DcmImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input != null) {
            if (!(input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)input;
        } else {
            this.stream = null;
        }
        this.resetStreamSettings();
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        this.readMetadata();
        return this.numberOfFrames;
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex >= this.numberOfFrames) {
            throw new IndexOutOfBoundsException("index: " + imageIndex + ", frames: " + this.numberOfFrames);
        }
    }

    public int getWidth(int imageIndex) throws IOException {
        this.readMetadata();
        this.checkIndex(imageIndex);
        return this.width;
    }

    public int getHeight(int imageIndex) throws IOException {
        this.readMetadata();
        this.checkIndex(imageIndex);
        return this.height;
    }

    public float getAspectRatio(int imageIndex) throws IOException {
        this.readMetadata();
        this.checkIndex(imageIndex);
        return this.aspectRatio;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        this.readMetadata();
        return this.theMetadata;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.readMetadata();
        this.checkIndex(imageIndex);
        return null;
    }

    private void readMetadata() throws IOException {
        if (this.theMetadata != null) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.theParser = DcmParserFactory.getInstance().newDcmParser(this.stream);
        FileFormat fileFormat = this.theParser.detectFileFormat();
        this.theDataset = DcmObjectFactory.getInstance().newDataset();
        this.theParser.setDcmHandler(this.theDataset.getDcmHandler());
        this.theParser.parseDcmFile(fileFormat, 2145386512);
        this.theMetadata = new DcmMetadataImpl(this.theDataset);
        if (this.theParser.getReadTag() != 2145386512) {
            this.numberOfFrames = 0;
        } else {
            this.initParams();
        }
    }

    private void initParams() throws IOException {
        int alloc = this.theDataset.getInt(2621696, 8);
        switch (alloc) {
            case 8: {
                this.dataType = 0;
                break;
            }
            case 16: {
                this.dataType = 1;
                break;
            }
            default: {
                throw new IOException("" + alloc + " Bits Allocated not supported!");
            }
        }
        this.stored = this.theDataset.getInt(2621697, alloc);
        this.width = this.theDataset.getInt(2621457, 0);
        this.height = this.theDataset.getInt(2621456, 0);
        this.samplesPerPixel = this.theDataset.getInt(0x280002, 1);
        this.pmi = this.theDataset.getString(2621444, "MONOCHROME2");
        log.debug("Samples per pixel is " + this.samplesPerPixel + " " + this.pmi + " for size " + this.width + "," + this.height);
        this.planes = this.theDataset.getInt(2621446, 0);
        this.aspectRatio = (float)this.width * this.pixelRatio() / (float)this.height;
        this.numberOfFrames = this.theDataset.getInt(0x280008, 1);
        int rLen = this.theParser.getReadLength();
        if (rLen == -1) {
            ImageReaderFactory f = ImageReaderFactory.getInstance();
            String ts = this.theDataset.getFileMetaInfo().getTransferSyntaxUID();
            this.ybr2rgb = ts.equals("1.2.840.10008.1.2.4.50") || ts.equals("1.2.840.10008.1.2.4.51");
            this.decompressor = f.getReaderForTransferSyntax(ts);
            this.itemParser = new ItemParser(this.theParser);
            return;
        }
        this.frame1StartPos = this.theParser.getStreamPosition();
        this.frameLength = rLen / this.numberOfFrames;
        if (this.samplesPerPixel > 1) {
            if (alloc == 16) {
                throw new IOException("RGB 16 Bits allocated not supported!");
            }
            if (this.frameLength < 3 * this.width * this.height) {
                throw new DcmValueException("Invalid Length of Pixel Data: " + rLen);
            }
            return;
        }
        if (this.frameLength < this.width * this.height * (alloc >> 3)) {
            throw new DcmValueException("Invalid Length of Pixel Data: " + rLen);
        }
    }

    private float pixelRatio() {
        int[] ratio = this.theDataset.getInts(2621492);
        if (ratio != null && ratio.length == 2) {
            if (ratio[0] == ratio[1] || ratio[0] <= 0 || ratio[1] <= 0) {
                return 1.0f;
            }
            return (float)ratio[1] / (float)ratio[0];
        }
        float[] spacing = this.theDataset.getFloats(2621488);
        if (!(spacing != null && spacing.length == 2 || (spacing = this.theDataset.getFloats(1577316)) != null && spacing.length == 2)) {
            return 1.0f;
        }
        if (spacing[0] == spacing[1] || spacing[0] <= 0.0f || spacing[1] <= 0.0f) {
            return 1.0f;
        }
        return spacing[1] / spacing[0];
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        return this.getImageTypes(imageIndex, null);
    }

    private Iterator getImageTypes(int imageIndex, DcmImageReadParam param) throws IOException {
        this.readMetadata();
        this.checkIndex(imageIndex);
        return Collections.singletonList(this.getImageTypeSpecifier(param != null ? param.getPValToDDL() : null)).iterator();
    }

    private ImageTypeSpecifier getImageTypeSpecifier(byte[] pv2dll) {
        if (this.samplesPerPixel == 3) {
            if (!this.ybr2rgb) {
                if (this.pmi.startsWith("YBR_FULL")) {
                    return this.planes != 0 ? YBR_FULL_PLANE : YBR_FULL_PIXEL;
                }
                if (this.pmi.startsWith("YBR_PARTIAL")) {
                    return this.planes != 0 ? YBR_PARTIAL_PLANE : YBR_PARTIAL_PIXEL;
                }
            }
            return this.planes != 0 ? RGB_PLANE : RGB_PIXEL;
        }
        this.cmParam = cmFactory.makeParam(this.theDataset, pv2dll);
        return new ImageTypeSpecifier(cmFactory.getColorModel(this.cmParam), new PixelInterleavedSampleModel(this.dataType, 1, 1, 1, 1, new int[]{0}));
    }

    public ImageReadParam getDefaultReadParam() {
        return new DcmImageReadParamImpl();
    }

    public synchronized BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.readMetadata();
        this.checkIndex(imageIndex);
        DcmImageReadParam readParam = (DcmImageReadParam)param;
        if (readParam == null) {
            readParam = (DcmImageReadParam)this.getDefaultReadParam();
        }
        Iterator imageTypes = this.getImageTypes(imageIndex, readParam);
        this.theImage = DcmImageReader.getDestination(param, imageTypes, this.width, this.height);
        if (this.decompressor != null) {
            ImageReadParam decompressorReadParam = this.decompressor.getDefaultReadParam();
            decompressorReadParam.setDestination(this.theImage);
            decompressorReadParam.setSourceRegion(readParam.getSourceRegion());
            decompressorReadParam.setSourceSubsampling(readParam.getSourceXSubsampling(), readParam.getSourceYSubsampling(), readParam.getSubsamplingXOffset(), readParam.getSubsamplingYOffset());
            decompressorReadParam.setDestinationOffset(readParam.getDestinationOffset());
            return this.adjustBufferedImage(this.decompress(imageIndex, decompressorReadParam), readParam);
        }
        this.stream.seek(this.frame1StartPos + (long)(imageIndex * this.frameLength));
        this.theTile = this.theImage.getWritableTile(0, 0);
        Rectangle rect = DcmImageReader.getSourceRegion(param, this.width, this.height);
        this.sourceXOffset = rect.x;
        this.sourceYOffset = rect.y;
        this.sourceWidth = rect.width;
        this.sourceHeight = rect.height;
        this.sourceXSubsampling = readParam.getSourceXSubsampling();
        this.sourceYSubsampling = readParam.getSourceYSubsampling();
        this.subsamplingXOffset = readParam.getSubsamplingXOffset();
        this.subsamplingYOffset = readParam.getSubsamplingYOffset();
        Point point = readParam.getDestinationOffset();
        this.destXOffset = point.x;
        this.destYOffset = point.y;
        this.destWidth = this.sourceWidth / this.sourceXSubsampling;
        this.totDestWidth = this.theTile.getWidth();
        this.totDestHeight = this.theTile.getHeight();
        if (this.destXOffset < 0) {
            this.sourceXOffset -= this.destXOffset * this.sourceXSubsampling;
            if ((this.sourceWidth += this.destXOffset * this.sourceXSubsampling) < 0) {
                this.sourceWidth = 0;
            }
            this.destXOffset = 0;
        }
        if (this.destYOffset < 0) {
            this.sourceYOffset -= this.destYOffset * this.sourceYSubsampling;
            if ((this.sourceHeight += this.destYOffset * this.sourceYSubsampling) < 0) {
                this.sourceHeight = 0;
            }
            this.destYOffset = 0;
        }
        DataBuffer db = this.theTile.getDataBuffer();
        if (this.dataType == 0) {
            if (this.samplesPerPixel == 3) {
                if (this.planes != 0) {
                    this.readByteSamples(1, ((DataBufferByte)db).getData(0));
                    this.readByteSamples(1, ((DataBufferByte)db).getData(1));
                    this.readByteSamples(1, ((DataBufferByte)db).getData(2));
                } else {
                    this.readByteSamples(3, ((DataBufferByte)db).getData());
                }
            } else {
                this.readByteSamples(1, ((DataBufferByte)db).getData());
            }
        } else {
            this.readWordSamples(1, ((DataBufferUShort)db).getData());
        }
        return this.adjustBufferedImage(this.theImage, readParam);
    }

    private BufferedImage adjustBufferedImage(BufferedImage bi, DcmImageReadParam readParam) {
        boolean autoWindowing;
        boolean bl = autoWindowing = this.cmParam != null && this.cmParam.isMonochrome() && this.cmParam.getNumberOfWindows() == 0 && readParam.isAutoWindowing();
        if (!autoWindowing && !readParam.isMaskPixelData()) {
            return bi;
        }
        WritableRaster raster = bi.getRaster();
        DataBuffer db = raster.getDataBuffer();
        if (db instanceof DataBufferUShort) {
            return this.adjustUShortBufferedImage(bi, readParam, autoWindowing, raster, db);
        }
        if (db instanceof DataBufferByte) {
            return this.adjustByteBufferedImage(bi, readParam, autoWindowing, raster, db);
        }
        return bi;
    }

    private BufferedImage adjustByteBufferedImage(BufferedImage bi, DcmImageReadParam readParam, boolean autoWindowing, WritableRaster raster, DataBuffer db) {
        int i;
        byte[] data = ((DataBufferByte)db).getData();
        int mask = -1 >>> 32 - this.stored;
        if (!autoWindowing) {
            int i2 = 0;
            while (i2 < data.length) {
                int n = i2++;
                data[n] = (byte)(data[n] & mask);
            }
            return bi;
        }
        int sign = this.theDataset.getInt(2621699, 0) == 0 ? 0 : ~mask;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int signBit = 1 << this.stored - 1;
        if (readParam.isMaskPixelData()) {
            for (i = 0; i < data.length; ++i) {
                int n = i;
                data[n] = (byte)(data[n] & mask);
                int val = data[i] & mask;
                if ((val & signBit) != 0) {
                    val |= sign;
                }
                if (val < min) {
                    min = val;
                }
                if (val <= max) continue;
                max = val;
            }
        } else {
            for (i = 0; i < data.length; ++i) {
                int val = data[i] & mask;
                if ((val & signBit) == signBit) {
                    val |= sign;
                }
                if (val < min) {
                    min = val;
                }
                if (val <= max) continue;
                max = val;
            }
        }
        float w = (float)(max - min) * this.cmParam.getRescaleSlope();
        float c = (float)((max + min) / 2) * this.cmParam.getRescaleSlope() + this.cmParam.getRescaleIntercept();
        log.debug("auto c,w=" + c + "," + w + " min,max=" + min + "," + max + " mask=" + mask + " sign=" + sign);
        ColorModel cm = cmFactory.getColorModel(this.cmParam.update(c, w, this.cmParam.isInverse()));
        return new BufferedImage(cm, raster, false, null);
    }

    private BufferedImage adjustUShortBufferedImage(BufferedImage bi, DcmImageReadParam readParam, boolean autoWindowing, WritableRaster raster, DataBuffer db) {
        int i;
        short[] data = ((DataBufferUShort)db).getData();
        int mask = -1 >>> 32 - this.stored;
        if (!autoWindowing) {
            int i2 = 0;
            while (i2 < data.length) {
                int n = i2++;
                data[n] = (short)(data[n] & mask);
            }
            return bi;
        }
        int sign = this.theDataset.getInt(2621699, 0) == 0 ? 0 : ~mask;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int signBit = 1 << this.stored - 1;
        if (readParam.isMaskPixelData()) {
            for (i = 0; i < data.length; ++i) {
                int n = i;
                data[n] = (short)(data[n] & mask);
                int val = data[i] & mask;
                if ((val & signBit) != 0) {
                    val |= sign;
                }
                if (val < min) {
                    min = val;
                }
                if (val <= max) continue;
                max = val;
            }
        } else {
            for (i = 0; i < data.length; ++i) {
                int val = data[i] & mask;
                if ((val & signBit) == signBit) {
                    val |= sign;
                }
                if (val < min) {
                    min = val;
                }
                if (val <= max) continue;
                max = val;
            }
        }
        float w = (float)(max - min) * this.cmParam.getRescaleSlope();
        float c = (float)((max + min) / 2) * this.cmParam.getRescaleSlope() + this.cmParam.getRescaleIntercept();
        log.debug("auto w,c=" + w + "," + c + " min,max=" + min + "," + max + " mask=" + mask + " sign=" + sign);
        ColorModel cm = cmFactory.getColorModel(this.cmParam.update(c, w, this.cmParam.isInverse()));
        return new BufferedImage(cm, raster, false, null);
    }

    private BufferedImage decompress(int imageIndex, ImageReadParam readParam) throws IOException {
        log.debug("Start decompressing frame#" + (imageIndex + 1));
        this.decompressor.setInput(this.itemStream(imageIndex));
        BufferedImage bi = this.decompressor.read(0, readParam);
        if (this.decompressor.getClass().getName().startsWith(J2KIMAGE_READER)) {
            this.decompressor.dispose();
            ImageReaderFactory f = ImageReaderFactory.getInstance();
            String ts = this.theDataset.getFileMetaInfo().getTransferSyntaxUID();
            this.decompressor = f.getReaderForTransferSyntax(ts);
        } else {
            this.decompressor.reset();
        }
        log.debug("Finished decompressed frame#" + (imageIndex + 1));
        return bi;
    }

    private SegmentedImageInputStream itemStream(int imageIndex) {
        if (this.numberOfFrames > 1) {
            ItemParser.Item item = this.itemParser.getItem(imageIndex);
            return new SegmentedImageInputStream(this.stream, new long[]{item.startPos}, new int[]{item.length});
        }
        return new SegmentedImageInputStream(this.stream, this.itemParser);
    }

    private void readByteSamples(int samples, byte[] dest) throws IOException {
        byte[] srcRow = null;
        int rowLen = this.width * samples;
        int srcRowLen = this.sourceWidth * samples;
        int srcXOffsetLen = this.sourceXOffset * samples;
        int destXOffsetLen = this.destXOffset * samples;
        if (this.sourceXSubsampling != 1) {
            srcRow = new byte[srcRowLen];
        }
        int maxPosMax = this.totDestHeight * this.totDestWidth;
        int totDestRowLen = this.totDestWidth * samples;
        this.stream.skipBytes(rowLen * this.sourceYOffset);
        int destY = this.destYOffset;
        int pos = 0;
        int posMax = 0;
        int x = 0;
        int y = 0;
        try {
            for (y = 0; y < this.sourceHeight; ++y) {
                if ((y - this.subsamplingYOffset) % this.sourceYSubsampling != 0) {
                    this.stream.skipBytes(rowLen);
                    continue;
                }
                this.stream.skipBytes(srcXOffsetLen);
                if (this.sourceXSubsampling == 1) {
                    this.stream.readFully(dest, destY * totDestRowLen + destXOffsetLen, srcRowLen);
                } else {
                    this.stream.readFully(srcRow);
                    pos = destY * this.totDestWidth + this.destXOffset;
                    posMax = Math.min(pos + this.destWidth, maxPosMax);
                    switch (samples) {
                        case 1: {
                            x = 0;
                            while (pos < posMax) {
                                if ((x - this.subsamplingXOffset) % this.sourceXSubsampling == 0) {
                                    dest[pos++] = srcRow[x];
                                }
                                ++x;
                            }
                            break;
                        }
                        case 3: {
                            x = 0;
                            int x3 = 0;
                            int pos3 = pos * 3;
                            while (pos < posMax) {
                                if ((x - this.subsamplingXOffset) % this.sourceXSubsampling == 0) {
                                    dest[pos3++] = srcRow[x3++];
                                    dest[pos3++] = srcRow[x3++];
                                    dest[pos3++] = srcRow[x3++];
                                    ++pos;
                                } else {
                                    x3 += 3;
                                }
                                ++x;
                            }
                            break;
                        }
                        default: {
                            throw new Error("Internal dcm4che Error");
                        }
                    }
                }
                this.stream.skipBytes(rowLen - srcXOffsetLen - srcRowLen);
                if (++destY < this.totDestHeight) continue;
                ++y;
                break;
            }
            this.stream.skipBytes(rowLen * (this.height - this.sourceYOffset - y));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IIOException("Exception in readByteSamples", ex);
        }
    }

    private void readWordSamples(int samples, short[] dest) throws IOException {
        int rowLen = this.width * samples;
        int srcRowLen = this.sourceWidth * samples;
        int srcXOffsetLen = this.sourceXOffset * samples;
        int destXOffsetLen = this.destXOffset * samples;
        byte[] srcRow = new byte[srcRowLen << 1];
        ShortBuffer srcRowBuf = ByteBuffer.wrap(srcRow).order(this.theParser.getDcmDecodeParam().byteOrder).asShortBuffer();
        int maxPosMax = this.totDestHeight * this.totDestWidth;
        int totDestRowLen = this.totDestWidth * samples;
        this.stream.skipBytes(rowLen * this.sourceYOffset << 1);
        int destY = this.destYOffset;
        int pos = 0;
        int posMax = 0;
        int x = 0;
        int y = 0;
        try {
            for (y = 0; y < this.sourceHeight; ++y) {
                if ((y - this.subsamplingYOffset) % this.sourceYSubsampling != 0) {
                    this.stream.skipBytes(rowLen << 1);
                    continue;
                }
                this.stream.skipBytes(srcXOffsetLen << 1);
                this.stream.readFully(srcRow);
                if (this.sourceXSubsampling == 1) {
                    srcRowBuf.rewind();
                    srcRowBuf.get(dest, destY * totDestRowLen + destXOffsetLen, srcRowLen);
                } else {
                    pos = destY * this.totDestWidth + this.destXOffset;
                    posMax = Math.min(pos + this.destWidth, maxPosMax);
                    switch (samples) {
                        case 1: {
                            x = 0;
                            while (pos < posMax) {
                                if ((x - this.subsamplingXOffset) % this.sourceXSubsampling == 0) {
                                    dest[pos++] = srcRowBuf.get(x);
                                }
                                ++x;
                            }
                            break;
                        }
                        case 3: {
                            x = 0;
                            int x3 = 0;
                            int pos3 = pos * 3;
                            while (pos < posMax) {
                                if ((x - this.subsamplingXOffset) % this.sourceXSubsampling == 0) {
                                    dest[pos3++] = srcRowBuf.get(x3++);
                                    dest[pos3++] = srcRowBuf.get(x3++);
                                    dest[pos3++] = srcRowBuf.get(x3++);
                                    ++pos;
                                } else {
                                    x3 += 3;
                                }
                                ++x;
                            }
                            break;
                        }
                        default: {
                            throw new Error("Internal dcm4che Error");
                        }
                    }
                }
                this.stream.skipBytes(rowLen - srcXOffsetLen - srcRowLen << 1);
                if (++destY < this.totDestHeight) continue;
                ++y;
                break;
            }
            this.stream.skipBytes(rowLen * (this.height - this.sourceYOffset - y) << 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IIOException("Exception in readWordSamples", ex);
        }
    }

    public void reset() {
        super.reset();
        this.stream = null;
        this.resetStreamSettings();
    }

    private void resetStreamSettings() {
        this.theParser = null;
        this.theMetadata = null;
        this.theDataset = null;
        this.pmi = null;
        this.cmParam = null;
        this.theImage = null;
        this.theTile = null;
        if (this.decompressor != null) {
            this.decompressor.dispose();
        }
        this.decompressor = null;
        this.ybr2rgb = false;
        this.itemParser = null;
    }
}

