/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.DataSource;
import org.dcm4che.net.Dimse;

class DimseImpl
implements Dimse {
    protected static final DcmObjectFactory objFact = DcmObjectFactory.getInstance();
    private final int pcid;
    private final Command cmd;
    private Dataset ds;
    private InputStream in;
    private final DataSource src;
    private String tsUID;

    public DimseImpl(int pcid, String tsUID, Command cmd, InputStream in) {
        this.pcid = pcid;
        this.cmd = cmd;
        this.ds = null;
        this.src = null;
        this.in = in;
        this.tsUID = tsUID;
    }

    public DimseImpl(int pcid, Command cmd, Dataset ds, DataSource src) {
        this.pcid = pcid;
        this.cmd = cmd;
        this.ds = ds;
        this.src = src;
        this.in = null;
        this.tsUID = null;
        this.cmd.putUS(2048, ds == null && src == null ? 257 : 0);
    }

    public final int pcid() {
        return this.pcid;
    }

    public final Command getCommand() {
        return this.cmd;
    }

    public final String getTransferSyntaxUID() {
        return this.tsUID;
    }

    final void setTransferSyntaxUID(String tsuid) {
        this.tsUID = tsuid;
    }

    public final Dataset getDataset() throws IOException {
        if (this.ds != null) {
            return this.ds;
        }
        if (this.in == null) {
            return null;
        }
        if (this.tsUID == null) {
            throw new IllegalStateException();
        }
        this.ds = objFact.newDataset();
        this.ds.readDataset(this.in, DcmDecodeParam.valueOf(this.tsUID), -1);
        this.in.close();
        this.in = null;
        return this.ds;
    }

    public final InputStream getDataAsStream() {
        return this.in;
    }

    public void writeTo(OutputStream out, String tsUID) throws IOException {
        if (this.src != null) {
            this.src.writeTo(out, tsUID);
            return;
        }
        if (this.ds == null) {
            throw new IllegalStateException("Missing Dataset");
        }
        this.ds.writeDataset(out, DcmDecodeParam.valueOf(tsUID));
    }

    public String toString() {
        return "[pc-" + this.pcid + "] " + this.cmd.toString();
    }

    public void closeDataStream() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

