/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.dcm4che.data.Command;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.net.AAbort;
import org.dcm4che.net.AReleaseRP;
import org.dcm4che.net.AReleaseRQ;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.PDU;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.PDataTF;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AReleaseRPImpl;
import org.dcm4cheri.net.DimseImpl;
import org.dcm4cheri.net.FsmImpl;
import org.dcm4cheri.util.LF_ThreadPool;

final class DimseReaderImpl {
    private static final DcmObjectFactory dcmObjFact = DcmObjectFactory.getInstance();
    private final FsmImpl fsm;
    private int timeout = 0;
    private PDataTF pDataTF = null;
    private PDataTF.PDV pdv = null;
    private Command cmd = null;
    private byte[] buf = null;
    private LF_ThreadPool pool = null;

    public DimseReaderImpl(FsmImpl fsm) {
        this.fsm = fsm;
    }

    public void setThreadPool(LF_ThreadPool pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Dimse read(int timeout) throws IOException {
        int pcid;
        String tsUID;
        this.timeout = timeout;
        try {
            if (!this.nextPDV()) {
                return null;
            }
        }
        catch (EOFException e) {
            FsmImpl.log.warn("Socket closed on open association:" + this.fsm.socket());
            return null;
        }
        if (!this.pdv.cmd()) {
            this.abort("Command PDV expected, but received " + this.pdv);
        }
        if ((tsUID = this.fsm.getAcceptedTransferSyntaxUID(pcid = this.pdv.pcid())) == null) {
            this.abort("No Presentation Context negotiated with pcid:" + pcid);
        }
        PDataTFInputStream in = new PDataTFInputStream(this.pdv.getInputStream());
        this.cmd = dcmObjFact.newCommand();
        boolean ds = false;
        try {
            this.cmd.read(in);
            ds = this.cmd.hasDataset();
        }
        catch (IllegalArgumentException e) {
            this.abort(e.getMessage());
        }
        catch (DcmValueException e) {
            this.abort(e.getMessage());
        }
        finally {
            ((InputStream)in).close();
        }
        in = null;
        if (ds) {
            if (!this.nextPDV()) {
                throw new EOFException("Association released during receive of DIMSE");
            }
            if (this.pdv.cmd()) {
                this.abort("Data PDV expected, but received " + this.pdv);
            }
            if (pcid != this.pdv.pcid()) {
                this.abort("Mismatch between Command PDV pcid: " + pcid + " and " + this.pdv);
            }
            in = new PDataTFInputStream(this.pdv.getInputStream());
        } else {
            this.forkNextReadNext();
        }
        DimseImpl retval = new DimseImpl(pcid, tsUID, this.cmd, in);
        this.fsm.fireReceived(retval);
        return retval;
    }

    private void forkNextReadNext() {
        if (this.pool == null) {
            return;
        }
        if (this.cmd.isRequest()) {
            switch (this.cmd.getCommandField()) {
                case 16: 
                case 32: 
                case 33: 
                case 4095: {
                    break;
                }
                default: {
                    if (this.fsm.getMaxOpsPerformed() != 1) break;
                    return;
                }
            }
        }
        this.pool.promoteNewLeader();
    }

    private InputStream nextStream() throws IOException {
        if (this.pdv != null && this.pdv.last()) {
            if (!this.pdv.cmd()) {
                this.forkNextReadNext();
            }
            return null;
        }
        if (!this.nextPDV()) {
            throw new EOFException("Association released during receive of DIMSE");
        }
        return this.pdv.getInputStream();
    }

    private boolean nextPDV() throws IOException {
        int prevPcid;
        boolean hasPrev = this.pdv != null && !this.pdv.last();
        boolean prevCmd = hasPrev && this.pdv.cmd();
        int n = prevPcid = hasPrev ? this.pdv.pcid() : 0;
        while (this.pDataTF == null || (this.pdv = this.pDataTF.readPDV()) == null) {
            if (this.nextPDataTF()) continue;
            return false;
        }
        if (hasPrev && (prevCmd != this.pdv.cmd() || prevPcid != this.pdv.pcid())) {
            this.abort("Mismatch of following PDVs: " + this.pdv);
        }
        return true;
    }

    private void abort(String msg) throws IOException {
        AAbortImpl aa = new AAbortImpl(0, 0);
        this.fsm.write(aa);
        throw new PDUException(msg, aa);
    }

    private boolean nextPDataTF() throws IOException {
        PDU pdu;
        if (this.buf == null) {
            this.buf = new byte[this.fsm.getReadMaxLength() + 6];
        }
        if ((pdu = this.fsm.read(this.timeout, this.buf)) instanceof PDataTF) {
            this.pDataTF = (PDataTF)pdu;
            return true;
        }
        if (pdu instanceof AReleaseRP) {
            return false;
        }
        if (pdu instanceof AReleaseRQ) {
            this.fsm.write(AReleaseRPImpl.getInstance());
            return false;
        }
        throw new PDUException("Received " + pdu, (AAbort)pdu);
    }

    private class PDataTFInputStream
    extends InputStream {
        private InputStream in;

        PDataTFInputStream(InputStream in) {
            this.in = in;
        }

        public int available() throws IOException {
            if (this.in == null) {
                return 0;
            }
            return this.in.available();
        }

        public int read() throws IOException {
            if (this.in == null) {
                return -1;
            }
            int c = this.in.read();
            if (c == -1) {
                this.in = DimseReaderImpl.this.nextStream();
                return this.read();
            }
            return c;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            while (this.in != null) {
                int n = this.in.read(b, off, len);
                if (n > 0) {
                    return n;
                }
                this.in = DimseReaderImpl.this.nextStream();
            }
            return -1;
        }

        public void close() throws IOException {
            while (this.in != null) {
                this.in = DimseReaderImpl.this.nextStream();
            }
        }
    }
}

