/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.dcm4che.hl7.HL7Exception;
import org.dcm4che.hl7.HL7Factory;
import org.dcm4che.hl7.HL7Message;
import org.dcm4che.hl7.HL7Service;
import org.dcm4che.hl7.MSHSegment;
import org.dcm4che.server.HL7Handler;
import org.dcm4che.util.MLLPInputStream;
import org.dcm4che.util.MLLPOutputStream;

public class HL7HandlerImpl
implements HL7Handler {
    static final Logger log = Logger.getLogger(HL7HandlerImpl.class);
    private static final HL7Factory hl7Fact = HL7Factory.getInstance();
    private int soTimeout = 0;
    private HashSet receivingApps = null;
    private HashSet sendingApps = null;
    private HashMap hl7Services = new HashMap();

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    public boolean addReceivingApp(String app) {
        if (this.receivingApps == null) {
            this.receivingApps = new HashSet();
        }
        return this.receivingApps.add(app);
    }

    public boolean addSendingApp(String app) {
        if (this.sendingApps == null) {
            this.sendingApps = new HashSet();
        }
        return this.sendingApps.add(app);
    }

    public String[] getReceivingApps() {
        return this.receivingApps != null ? this.receivingApps.toArray(new String[this.receivingApps.size()]) : null;
    }

    public String[] getSendingApps() {
        return this.sendingApps != null ? this.sendingApps.toArray(new String[this.sendingApps.size()]) : null;
    }

    public boolean removeReceivingApp(String app) {
        return this.receivingApps != null && this.receivingApps.remove(app);
    }

    public boolean removeSendingApp(String app) {
        return this.sendingApps != null && this.sendingApps.remove(app);
    }

    public void setReceivingApps(String[] apps) {
        this.receivingApps = apps != null ? new HashSet<String>(Arrays.asList(apps)) : null;
    }

    public void setSendingApps(String[] apps) {
        this.sendingApps = apps != null ? new HashSet<String>(Arrays.asList(apps)) : null;
    }

    public HL7Service putService(String msgTypeEvent, HL7Service service) {
        if (service != null) {
            return this.hl7Services.put(msgTypeEvent, service);
        }
        return (HL7Service)this.hl7Services.remove(msgTypeEvent);
    }

    private String toKey(String msgType, String trEvent) {
        StringBuffer sb = new StringBuffer(msgType.length() + trEvent.length() + 1);
        sb.append(msgType).append('^').append(trEvent);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Socket s) throws IOException {
        s.setSoTimeout(this.soTimeout);
        MLLPInputStream in = new MLLPInputStream(new BufferedInputStream(s.getInputStream()));
        MLLPOutputStream out = new MLLPOutputStream(new BufferedOutputStream(s.getOutputStream()));
        try {
            byte[] data;
            while ((data = in.readMessage()) != null) {
                HL7Message msg = hl7Fact.parse(data);
                log.info("RCV: " + msg);
                byte[] res = this.execute(msg.header(), data);
                log.info("SND: " + hl7Fact.parse(res));
                out.writeMessage(res);
                out.flush();
            }
        }
        catch (HL7Exception e) {
            log.error("Could not understand: ", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
            try {
                out.close();
            }
            catch (IOException ignore) {}
            try {
                s.close();
            }
            catch (IOException ignore) {}
        }
    }

    public byte[] execute(MSHSegment msh, byte[] data) {
        try {
            if (this.receivingApps != null && !this.receivingApps.contains(msh.getReceivingApplication())) {
                throw new HL7Exception.AR("Unrecognized Receiving Application: " + msh.getReceivingApplication());
            }
            if (this.sendingApps != null && !this.sendingApps.contains(msh.getSendingApplication())) {
                throw new HL7Exception.AR("Unrecognized Sending Application: " + msh.getSendingApplication());
            }
            HL7Service service = (HL7Service)this.hl7Services.get(this.toKey(msh.getMessageType(), msh.getTriggerEvent()));
            if (service == null) {
                service = (HL7Service)this.hl7Services.get(msh.getMessageType());
            }
            if (service == null) {
                throw new HL7Exception.AR("Unrecognized Message Type^TriggerEvent " + this.toKey(msh.getMessageType(), msh.getTriggerEvent()));
            }
            return service.execute(data);
        }
        catch (HL7Exception e) {
            log.warn(e.getMessage(), e);
            return e.makeACK(msh);
        }
    }

    public boolean isSockedClosedByHandler() {
        return true;
    }
}

