/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.server;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

final class SyslogMsg {
    private static final char PriStartDelim = '<';
    private static final char PriEndDelim = '>';
    private static final char FieldDelim = ' ';
    private static final int PriMaxLen = 3;
    private static final int DefaultPriValue = 13;
    private static final int DefaultFacility = 1;
    private static final int DefaultSeverity = 5;
    private static final String[] Facility = new String[]{"kernel", "user", "mail", "system daemons", "sec/auth", "syslogd", "lp subsystem", "network subsystem", "uucp subsystem", "clock daemon", "security/authority", "ftp daemon", "ntp subsystem", "log audit", "log alert", "clock daemon", "local use 0", "local use 1", "local use 2", "local use 3", "local use 4", "local use 5", "local use 6", "local use 7"};
    private static final String[] Severity = new String[]{"emergency", "alert", "critical", "error", "warning", "notice", "informational", "debug"};
    private static final String[] Month = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private int severity = -1;
    private int facility = -1;
    private Calendar hdrTimeStamp = null;
    private String hdrHost = null;
    private String tag = null;
    private String content = null;
    private boolean isValid;

    public Date getTimestamp() {
        return this.hdrTimeStamp.getTime();
    }

    public String getHost() {
        return this.hdrHost;
    }

    public String getContent() {
        return this.content;
    }

    public String getMessage() {
        if (this.tag == null) {
            return "";
        }
        return this.tag + this.content;
    }

    public SyslogMsg(byte[] bMsg, int len) {
        byte[] newMsg = new byte[len];
        System.arraycopy(bMsg, 0, newMsg, 0, len);
        this.parse(newMsg);
    }

    public SyslogMsg(byte[] bMsg) throws InvalidSyslogMsgException {
        this.parse(bMsg);
    }

    private void parse(byte[] bMsg) throws InvalidSyslogMsgException {
        Date date;
        this.isValid = true;
        int iEnd = -1;
        for (int i = 1; i < 5 && i < bMsg.length; ++i) {
            if (bMsg[i] != 62) continue;
            iEnd = i;
            break;
        }
        if (bMsg[0] != 60 || iEnd == -1) {
            throw new InvalidSyslogMsgException(bMsg);
        }
        int priority = Integer.parseInt(new String(bMsg, 1, iEnd - 1));
        int[] priFields = this.getPriorityFields(priority);
        this.facility = priFields[0];
        this.severity = priFields[1];
        int iStart = iEnd + 1;
        String MyDateFormat = "MMM dd HH:mm:ss";
        SimpleDateFormat dateFmt = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.US);
        String sDate = new String(bMsg, iStart, 15);
        if (bMsg[iStart + 3] != 32 || bMsg[iStart + 6] != 32 || bMsg[iStart + 15] != 32 || (date = dateFmt.parse(sDate, new ParsePosition(0))) == null) {
            this.hdrTimeStamp = new GregorianCalendar();
            this.hdrHost = "unknown";
            throw new InvalidSyslogMsgException(bMsg);
        }
        this.hdrTimeStamp = new GregorianCalendar();
        this.hdrTimeStamp.setTime(date);
        this.hdrTimeStamp.set(1, new GregorianCalendar().get(1));
        iEnd = this.nextOccurence(bMsg, iStart += 16, (byte)32);
        if (iEnd == -1) {
            throw new InvalidSyslogMsgException(bMsg);
        }
        this.hdrHost = new String(bMsg, iStart, iEnd - iStart);
        for (int i = iStart = iEnd + 1; i < iStart + 33 && i < bMsg.length; ++i) {
            if (Character.isLetterOrDigit((char)bMsg[i])) continue;
            iEnd = i;
            break;
        }
        if (iEnd < iStart) {
            throw new InvalidSyslogMsgException(bMsg);
        }
        this.tag = new String(bMsg, iStart, iEnd - iStart);
        this.content = new String(bMsg, iEnd, bMsg.length - iEnd);
    }

    private static boolean isAlphaNumeric(String str) {
        char[] chrs = new char[str.length()];
        str.getChars(0, str.length(), chrs, 0);
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isLetterOrDigit(chrs[i])) continue;
            return false;
        }
        return true;
    }

    private int nextOccurence(byte[] arr, int startIndex, byte value) {
        if (startIndex >= 0) {
            for (int i = startIndex; i < arr.length; ++i) {
                if (arr[i] != value) continue;
                return i;
            }
        }
        return -1;
    }

    private int[] getPriorityFields(int pri) {
        return new int[]{pri >> 3, pri & 7};
    }

    private String severityToString(int sev) {
        return Severity[sev];
    }

    private String facilityToString(int fac) {
        return Facility[fac];
    }

    private String priorityToString(int pri) throws IllegalArgumentException {
        int[] field = this.getPriorityFields(pri);
        if (field[0] >= Facility.length) {
            return "[invalid PRI]";
        }
        return "[" + Facility[field[0]] + "," + Severity[field[1]] + "]";
    }

    public String toString() {
        return this.priorityToString(this.facility << 3 | this.severity) + " [time=" + this.getDateString(this.hdrTimeStamp) + ", host=" + this.hdrHost + "] " + "TAG=" + this.tag + ", CONTENT=" + this.content;
    }

    private String getDateString(Calendar date) {
        SimpleDateFormat dtfmt = new SimpleDateFormat("MMM dd, yyyy HH.mm.ss Z");
        return dtfmt.format(date.getTime());
    }

    public class InvalidSyslogMsgException
    extends RuntimeException {
        InvalidSyslogMsgException(byte[] bMsg) {
            super(SyslogMsg.this.content = new String(bMsg));
            SyslogMsg.this.isValid = false;
        }
    }
}

