/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.util;

import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dcm4che.Implementation;
import org.dcm4che.util.UIDGenerator;

public final class UIDGeneratorImpl
extends UIDGenerator {
    private static final String IP;

    public String createUID() {
        return this.createUID(Implementation.getClassUID());
    }

    public String createUID(String root) {
        final StringBuffer sb = new StringBuffer(64).append(root).append('.');
        try {
            new UID().write(new DataOutput(){

                public void write(int b) {
                }

                public void write(byte[] b) {
                }

                public void write(byte[] b, int off, int len) {
                }

                public void writeBoolean(boolean v) {
                }

                public void writeByte(int v) {
                }

                public void writeShort(int v) {
                    sb.append('.').append(v & 0xFFFF);
                }

                public void writeChar(int v) {
                }

                public void writeInt(int v) {
                    if ("127.0.0.1".equals(IP)) {
                        sb.append((long)v & 0xFFFFFFFFL);
                    } else {
                        sb.append(IP);
                    }
                }

                public void writeLong(long v) {
                    sb.append('.').append(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date(v)));
                }

                public void writeFloat(float v) {
                }

                public void writeDouble(double v) {
                }

                public void writeBytes(String s) {
                }

                public void writeChars(String s) {
                }

                public void writeUTF(String str) {
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
        if (sb.length() > 64) {
            throw new IllegalArgumentException("Too long root prefix");
        }
        return sb.toString();
    }

    static {
        String tmp;
        try {
            tmp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            tmp = "127.0.0.1";
        }
        IP = tmp;
    }
}

