package open.dolphin.client;

//import open.dolphin.infomodel.DocumentModel;
//import open.dolphin.infomodel.IInfoModel;
//import open.dolphin.infomodel.PatientModel;
//import open.dolphin.infomodel.PatientLiteModel;
import open.dolphin.infomodel.IPatientModel;

/**
 * CLAIM インスタンスを通知するイベント。
 *
 * @author  Kazushi Minagawa, Digital Globe, Inc.
 */
public class ClaimMessageEvent extends java.util.EventObject {
    
    private String patientId;
    private String patientName;
    private String patientSex;
    private String title;
    private String instance;
    private int number;
    private String confirmDate;
    
    /** Creates new ClaimEvent
     * @param source
     */
    public ClaimMessageEvent(Object source, IPatientModel patient, String claimMessage)
   {
     super(source);
     setClaimInstance(claimMessage);
     setPatientId(patient.getPatientId());
     setPatientName(patient.getFullName());
     setPatientSex(patient.getGender());
   }

    public String getPatientId() {
        return patientId;
    }
    
    private void setPatientId(String val) {
        patientId = val;
    }
    
    public String getPatientName() {
        return patientName;
    }
    
    public void setPatientName(String val) {
        patientName = val;
    }
    
    public String getPatientSex() {
        return patientSex;
    }
    
    public void setPatientSex(String val) {
        patientSex = val;
    }
    
    /**
     *
     * @return
     */
    public String getTitle() {
        return title;
    }
    
    public void setTitle(String val) {
        title = val;
    }
    
    public String getClaimInsutance() {
        return instance;
    }
    
    private void setClaimInstance(String val) {
        instance = val;
    }
    
    public int getNumber() {
        return number;
    }
    
    public void setNumber(int val) {
        number = val;
    }
    
    public String getConfirmDate() {
        return confirmDate;
    }
    
    /**
     *
     * @param val
     */
    public void setConfirmDate(String val) {
        confirmDate = val;
    }
}