package open.dolphin.client;

import java.awt.print.PageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuBar;
import open.dolphin.helper.IMainCommandAccepter.MainCommand;
import open.dolphin.helper.MainMenuSupport;
import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.infomodel.PatientVisitModel;

/**
 * アプリケーションのメインウインドウインターフェイスクラス。
 *
 * @author Minagawa, Kazushi. Digital Globe, Inc.
 */
public interface IMainWindow {

    /**
     *
     * @param command
     * @return
     */
    public boolean dispatchMainCommand(MainCommand command);

    //   public Map<String, IMainService> getProviders();
    //   public IMainService getProvider(String name);
    //   public void putProvider(String name, IMainService value);
    public JMenuBar getMenuBar();

    public MainMenuSupport getMenuSupport();

    public void registerActions(ActionMap actions);

    public Action getAction(String name);

    public void enabledAction(String name, boolean b);

    public void openKarte(PatientVisitModel pvt, String keyword);

    public void block();

    public void unblock();

    public BlockGlass getGlassPane();

    public IMainService getPlugin(String name);

    public PageFormat getPageFormat();

    public boolean isKarteOpened(long patientId);

    public void addChart(IChart chart);

    public boolean removeChart(IChart chart);

    //  public List<IChart> getAllEditorFrames();
    public void addEditorFrame(IChart chart);

    public void removeEditorFrame(IChart chart);

    /**
     *
     * @return
     */
    public PlugInMenuSupport getPlugin();
    //  public boolean showStampBox();
    //   public boolean showSchemaBox();
    //  public boolean showTemplateEditor();
}
