package open.dolphin.client.settings;

import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import open.dolphin.utils.Adapter;

/**
 * AbstractSettingPanel
 *
 * @author  Kazushi Minagawa, Digital Globe, Inc.
 */
public interface IAbstractSettingPanel {

    public static final String STATE_PROP = "stateProp";

    public enum State {

        NONE_STATE, VALID_STATE, INVALID_STATE
    };

    /**
     * Creates a new instance of SettingPanel 
     */
    public void onChenge(Adapter<Boolean, Boolean> adapter);

    public String getId();

    /**
     *
     * @param id
     */
    public void setId(String id);

    public String getTitle();

    public void setTitle(String title);

    /**
     *
     * @return
     */
    public String getIcon();

    public void setIcon(String icon);

    public ProjectSettingDialog getContext();

    /**
     *
     * @param context
     */
    public void setContext(ProjectSettingDialog context);

    /**
     *
     * @return
     */
    public boolean isLoginState();

    public void setLogInState(boolean login);

    /**
     *
     * @return
     */
    public JPanel getPanel();

    public abstract void start();

    public abstract void save();

    public void addPropertyChangeListener(String prop, PropertyChangeListener l);

    public void removePropertyChangeListener(String prop, PropertyChangeListener l);

    public void setState(State state);

    public State getState();
}
