package open.dolphin.helper;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import open.dolphin.helper.IChartCommandAccepter.ChartCommand;

/**
 * MenuSupport
 *
 * @author Minagawa,Kazushi
 *
 */
public class ChartMenuSupport implements MenuListener, IChartCommandAccepter {

    private ActionMap actions;
    private LinkedList<IChartCommandAccepter> chains;

    public ChartMenuSupport(IChartCommandAccepter owner) {
        chains = new LinkedList<IChartCommandAccepter>();
        chains.add(owner);
        chains.add(this);
    }

    @Override
    public void menuSelected(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    public void registerActions(ActionMap actions) {
        this.actions = actions;
    }

    public Action getAction(String name) {
        if (actions != null) {
            return actions.get(name);
        }
        return null;
    }

    public ActionMap getActions() {
        return actions;
    }

    public void disableAllMenus() {
        if (actions != null) {
            Object[] keys = actions.keys();
            for (Object o : keys) {
                actions.get(o).setEnabled(false);
            }
        }
    }

    public void disableMenus(String[] menus) {
        if (actions != null) {
            if (menus != null) {
                for (String name : menus) {
                    Action action = actions.get(name);
                    if (action != null) {
                        action.setEnabled(false);
                    }
                }
            }
        }
    }

    /**
     *
     * @param menus
     */
    public void enableMenus(String[] menus) {
        if (actions != null) {
            if (menus != null) {
                for (String name : menus) {
                    Action action = actions.get(name);
                    if (action != null) {
                        action.setEnabled(true);
                    }
                }
            }
        }
    }

    public void enabledAction(String name, boolean enabled) {
        if (actions != null) {
            Action action = actions.get(name);
            if (action != null) {
                action.setEnabled(enabled);
            }
        }
    }

    public void setAccepter(IChartCommandAccepter obj) {
        if (chains.contains(obj)) {
            unsetAccepter(obj);
        }
        chains.add(obj);
    }

    public boolean unsetAccepter(IChartCommandAccepter obj) {
        return chains.remove(obj);
    }

    /**
     *
     * @return
     */
    public Object getLast() {
        return chains.getLast();
    }

    public int chainSize() {
        return chains.size();
    }

    private boolean execute(ChartCommand command) {
        Iterator<IChartCommandAccepter> it = chains.descendingIterator();
        while (it.hasNext()) {
            if (it.next().dispatchChartCommand(command)) {
                return true;
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    public boolean newKarteCommandExecute() {
        return execute(ChartCommand.newKarte);
    }

    /**
     *
     * @return
     */
    public boolean newDocumentCommandExecute() {
        return execute(ChartCommand.newDocument);
    }

    public boolean closeCommandExecute() {
        return execute(ChartCommand.close);
    }

    /**
     *
     * @return
     */
    public boolean saveCommandExecute() {
        return execute(ChartCommand.save);
    }

    public boolean deleteCommandExecute() {
        return execute(ChartCommand.delete);
    }

    public boolean directionCommandExecute() {
        return execute(ChartCommand.direction);
    }

    public boolean printCommandExecute() {
        return execute(ChartCommand.print);
    }

    public boolean modifyKarteCommandExecute() {
        return execute(ChartCommand.modifyKarte);
    }

    public boolean undoCommandExecute() {
        return execute(ChartCommand.undo);
    }

    public boolean redoCommandExecute() {
        return execute(ChartCommand.redo);
    }

    /**
     *
     * @return
     */
    public boolean letterPasteCommandExecute() {
        return execute(ChartCommand.letterPaste);
    }

    public boolean letterPasteFromKarteCommandExecute() {
        return execute(ChartCommand.letterPasteFromKarte);
    }

    /**
     *
     * @return
     */
    public boolean quickEditExcecute() {
        return execute(ChartCommand.quickEdit);
    }

    public boolean showModifiedCommandExecute() {
        return execute(ChartCommand.showModified);
    }

    public boolean hideModifiedCommandExecute() {
        return execute(ChartCommand.hideModified);
    }

    /**
     *
     * @return
     */
    public boolean showUnsendCommandExecute() {
        return execute(ChartCommand.showUnsend);
    }

    public boolean hideUnsendCommandExecute() {
        return execute(ChartCommand.hideUnsend);
    }

    /**
     *
     * @return
     */
    public boolean showSendCommandExecute() {
        return execute(ChartCommand.showSend);
    }

    /**
     *
     * @return
     */
    public boolean hideSendCommandExecute() {
        return execute(ChartCommand.hideSend);
    }

    /**
     *
     * @return
     */
    public boolean showNewestCommandExecute() {
        return execute(ChartCommand.showNewest);
    }

    /**
     *
     * @return
     */
    public boolean hideNewestCommandExecute() {
        return execute(ChartCommand.hideNewest);
    }

    public boolean ascendingCommandExecute() {
        return execute(ChartCommand.ascending);
    }

    public boolean descendingCommandExecute() {
        return execute(ChartCommand.descending);
    }

    public boolean fontLargerCommandExecute() {
        return execute(ChartCommand.fontLarger);
    }

    public boolean fontSmallerCommandExecute() {
        return execute(ChartCommand.fontSmaller);
    }

    public boolean fontStandardCommandExecute() {
        return execute(ChartCommand.fontStandard);
    }

    public boolean fontBoldCommandExecute() {
        return execute(ChartCommand.fontBold);
    }

    public boolean fontItalicCommandExecute() {
        return execute(ChartCommand.fontItalic);
    }

    public boolean fontUnderlineCommandExecute() {
        return execute(ChartCommand.fontUnderline);
    }

    public boolean leftJustifyCommandExecute() {
        return execute(ChartCommand.leftJustify);
    }

    /**
     *
     * @return
     */
    public boolean centerJustifyCommandExecute() {
        return execute(ChartCommand.centerJustify);
    }

    public boolean rightJustifyCommandExecute() {
        return execute(ChartCommand.rightJustify);
    }

    public boolean fontRedCommandExecute() {
        return execute(ChartCommand.fontRed);
    }

    public boolean fontOrangeCommandExecute() {
        return execute(ChartCommand.fontOrange);
    }

    /**
     *
     * @return
     */
    public boolean fontYellowCommandExecute() {
        return execute(ChartCommand.fontYellow);
    }

    /**
     *
     * @return
     */
    public boolean fontGreenCommandExecute() {
        return execute(ChartCommand.fontGreen);
    }

    public boolean fontBlueCommandExecute() {
        return execute(ChartCommand.fontBlue);
    }

    public boolean fontPurpleCommandExecute() {
        return execute(ChartCommand.fontPurple);
    }

    /**
     *
     * @return
     */
    public boolean fontGrayCommandExecute() {
        return execute(ChartCommand.fontGray);
    }

    /**
     *
     * @return
     */
    public boolean fontBlackCommandExecute() {
        return execute(ChartCommand.fontBlack);
    }

    /**
     *
     * @return
     */
    public boolean resetStyleCommandExecute() {
        return execute(ChartCommand.resetStyle);
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }
}
