/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import open.dolphin.queries.DolphinQuery;

/**
 *
 * @author oda
 */
public class StampInfo implements IStampInfo {

    private String stampName;
    private String stampRole;
    private int stampNumber;
    private String entity;
    private boolean editable = true;
    private boolean asp;
    private String stampId;
    private String memo;
    private boolean turnIn;
    private String stampStatus;

    @Override
    public boolean search(DolphinQuery query) {
        if (stampName != null) {
            if (stampName.indexOf(query.what("keyword")) != -1) {
                return true;
            }
        }
        return false;
    }


    @Override
    public void initialize(String stampId, String name, String text, String entity, String _role) {
        setStampId(stampId);   // Stamp ID
        setStampName(name);    //
        setStampMemo(text);    // Tooltip
        setEntity(entity);     // カテゴリ
        setStampRole(_role);

        setStampNumber(1);
        setStampStatus("");
        editable = true;
        asp = false;
        turnIn = true;
    }

    @Override
    public String getStampName() {
        return stampName;
    }

    /**
     *
     * @param text
     */
    @Override
    public void setStampName(String text) {
        this.stampName = text;
    }

    @Override
    public String getStampRole() {
        return stampRole;
    }

    /**
     *
     * @param _role
     */
    @Override
    public void setStampRole(String _role) {
        stampRole = _role;
    }

    @Override
    public String getStampStatus() {
        return stampStatus;
    }

    @Override
    public void setStampStatus(String status) {
        stampStatus = status;
    }

    /**
     *
     * @return
     */
    @Override
    public String getEntity() {
        return entity;
    }

    @Override
    public void setEntity(String entity) {
        this.entity = entity;
    }

    @Override
    public boolean isSerialized() {
        return stampId != null;
    }

    @Override
    public boolean isASP() {
        return asp;
    }

    @Override
    public void setASP(boolean asp) {
        this.asp = asp;
    }

    @Override
    public String getStampId() {
        return stampId;
    }

    @Override
    public void setStampId(String id) {
        stampId = id;
    }

    @Override
    public String getStampMemo() {
        return memo;
    }

    @Override
    public void setStampMemo(String memo) {
        this.memo = memo;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean isEditable() {
        return editable;
    }

    @Override
    public void setTurnIn(boolean turnIn) {
        this.turnIn = turnIn;
    }

    /**
     *
     * @return
     */
    @Override
    public boolean isTurnIn() {
        return turnIn;
    }

    @Override
    public void setStampNumber(int stampNumber) {
        this.stampNumber = stampNumber;
    }

    @Override
    public int getStampNumber() {
        return stampNumber;
    }

    @Override
    public int compareTo(Object other) {
        if (other != null && getClass() == other.getClass()) {
            int result = getStampNumber() - ((ModuleInfoBean) other).getStampNumber();
            return result;
        }

        return -1;
    }

    private String nullToString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    @Override
    public void serialize(Writer result) throws IOException {
        result.append("<ModuleInfoBean name='" + nullToString(stampName) + "' role='" + nullToString(stampRole) + "' stampNumber='" + Integer.toString(stampNumber) + "' entity='" + nullToString(entity) + "' />");
        result.append(System.getProperty("line.separator"));
    }
}
