package open.dolphin.project;

import java.awt.Window;
import java.io.OutputStream;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.security.auth.Subject;
import open.dolphin.client.GUIConst;
import open.dolphin.client.SaveParams;

import open.dolphin.infomodel.ID;
import open.dolphin.infomodel.RoleModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.utils.CombinedStringParser;

/**
 * プロジェクト情報管理クラス。
 *
 * @author  Kazushi Minagawa, Digital Globe, Inc.
 */
public class GlobalVariables {

    // Prpject Name
    public static final String PROJECT_NAME = "name";
    // USER
    /**
     *
     */
    public static final String USER_TYPE = "userType";
    /**
     *
     */
    public static final String USER_ID = "userId";
    public static final String FACILITY_ID = "facilityId";
    // SERVER
    public static final String DB_ADDRESS = "dbAddress";
    public static final String DB_PASSWORD = "dbPassword";
    public static final String DB_SSLSTATE = "dbSSLState";
    public static final String HOST_PORT = "hostPort";
    // CLAIM
    public static final String SEND_CLAIM = "sendClaim";
    public static final String SEND_DIAGNOSIS = "sendDiagnosis";
    /**
     *
     */
    public static final String CLAIM_HOST_NAME = "claimHostName";
    public static final String CLAIM_VERSION = "claimVersion";
    public static final String CLAIM_ENCODING = "claimEncoding";
    /**
     *
     */
    public static final String CLAIM_ADDRESS = "claimAddress";
    public static final String CLAIM_PORT = "claimPort";
    public static final String USE_AS_PVT_SERVER = "useAsPVTServer";
    public static final String IS_HOSPITAL = "isHospital";
    public static final String GREETINGS = "greetings";
    public static final String ORCA_CHARACTER_CODE = "orcacharactercode";
    // Area Network
    /**
     *
     */
    public static final String JOIN_AREA_NETWORK = "joinAreaNetwork";
    public static final String AREA_NETWORK_NAME = "jareaNetworkName";
    public static final String AREA_NETWORK_FACILITY_ID = "jareaNetworkFacilityId";
    public static final String AREA_NETWORK_CREATOR_ID = "jareaNetworkCreatorId";
    // MML
    public static final String SEND_MML = "mml.send";
    public static final String MML_VERSION = "mml.version";
    public static final String MML_ENCODING = "mml.encoding";
    public static final String SEND_MML_ADDRESS = "mml.address";
    public static final String SEND_MML_DIRECTORY = "mml.directory";
    public static final String SEND_MML_PROTOCOL = "mml.protocol";
    // ソフトウェア更新
    public static final String USE_PROXY = "useProxy";
    /**
     *
     */
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    /**
     *
     */
    public static final String LAST_MODIFIED = "lastModify";
    // インスペクタのメモ位置
    public static final String INSPECTOR_MEMO_LOCATION = "inspectorMemoLocation";
    // 文書履歴
    public static final String DOC_HISTORY_ASCENDING = "docHistory.ascending";
    public static final String DOC_HISTORY_SHOWMODIFIED = "docHistory.showModified";
    /**
     *
     */
    public static final String DOC_HISTORY_SHOWUNSEND = "docHistory.showUnsend";
    public static final String DOC_HISTORY_SHOWSEND = "docHistory.showSend";
    public static final String DOC_HISTORY_SHOWNEWEST = "docHistory.showNewest";
    /**
     *
     */
    public static final String DOC_HISTORY_FETCHCOUNT = "docHistory.fetchCount";
    public static final String DOC_HISTORY_PERIOD = "docHistory.period";
    public static final String KARTE_SCROLL_DIRECTION = "karte.scroll.direction";
    public static final String DOUBLE_KARTE = "karte.double";
    // 病名
    public static final String DIAGNOSIS_ASCENDING = "diagnosis.ascending";
    public static final String DIAGNOSIS_PERIOD = "diagnosis.period";
    /**
     *
     */
    public static final String OFFSET_OUTCOME_DATE = "diagnosis.offsetOutcomeDate";
    // 検体検査
    public static final String LABOTEST_PERIOD = "laboTest.period";
    // 処方
    /**
     *
     */
    public static final String RP_OUT = "rp.out";
    // 確認ダイアログ
    /**
     *
     */
    public static final String KARTE_SHOW_CONFIRM_AT_NEW = "karte.showConfirmAtNew";
    public static final String KARTE_CREATE_MODE = "karte.createMode";
    public static final String KARTE_PLACE_MODE = "karte.placeMode";
    public static final String KARTE_SHOW_CONFIRM_AT_SAVE = "karte.showConfirmAtSave";
    public static final String KARTE_PRINT_COUNT = "karte.printCount";
    public static final String KARTE_SAVE_ACTION = "karte.saveAction";
    /**
     *
     */
    public static final String DIRECTIONS = "karte.directions";
    public static final String CC_DIRECTIONS = "karte.cc_directions";
    public static final String FEP_CONTROL = "karte.fep_control";
    // ユーザの利用形式

    /**
     *
     */
    public enum UserType {

        ASP_MEMBER, ASP_TESTER, ASP_DEV,
        /**
         *
         */
        FACILITY_USER, UNKNOWN, EXPIRED
    };
    private static GlobalVariablesImplement stub;

    public static void createGlobalVariables() {
        stub = new GlobalVariablesImplement();
    }

    public static UserType getUserType() {
        return stub.getUserType();
    }

    public static void setUserType(UserType userType) {
        stub.setUserType(userType);
    }

    public static boolean isValid() {
        return stub.isValid();
    }

    public static Preferences getPreferences() {
        return stub.getPreferences();
    }

    public static DolphinPrincipal getDolphinPrincipal() {
        return stub.getDolphinPrincipal();
    }

    public static void setDolphinPrincipal(DolphinPrincipal principal) {
        stub.setDolphinPrincipal(principal);
    }

    public static UserModel getUserModel() {
        return stub.getUserModel();
    }

    public static void setUserModel(UserModel value) {
        stub.setUserModel(value);
    }

    /**
     *
     * @return
     */
    public static boolean isReadOnly() {
        String licenseCode = stub.getUserModel().getLicenseModel().getLicense();
        String userId = stub.getUserModel().getUserId();
        return (licenseCode.equals("doctor") || userId.equals("lasmanager")) ? false : true;
    }

    public static String getUserId() {
        return stub.getUserId();
    }

    public static void setUserId(String userid) {
        stub.setUserId(userid);
    }

    public static String getFacilityId() {
        return stub.getFacilityId();
    }

    public static void setFacilityId(String facilityId) {
        stub.setFacilityId(facilityId);
    }

    public static String getOrcaVersion() {
        return stub.getOrcaVersion();
    }

    public static void setOrcaVersion(String version) {
        stub.setOrcaVersion(version);
    }

    public static String getJMARICode() {
        return stub.getJMARICode();
    }

    public static void setJMARICode(String jmariCode) {
        stub.setJMARICode(jmariCode);
    }

    public static String getDbAddress() {
        return stub.getDbAddress();
    }

    public static void setDbAddress(String dbAddress) {
        stub.setDbAddress(dbAddress);
    }

    public static String getDbPasswordWithoutHash() {
        return stub.getDbPasswordWithoutHash();
    }

    /**
     *
     * @param dbPass
     */
    public static void setDbPassword(String dbPass) {
        stub.setDbPassword(dbPass);
    }

    /**
     *
     * @return
     */
    public static boolean getDbSSLState() {
        return stub.getDbSSLState();
    }

    public static void setDbSSLState(boolean state) {
        stub.setDbSSLState(state);
    }

    /**
     *
     * @return
     */
    public static int getHostPort() {
        return stub.getHostPort();
    }

    public static void setHostPort(int port) {
        stub.setHostPort(port);
    }

    // Directions
    public static CombinedStringParser getDirections() {
        return stub.getDirections();
    }

    public static void setDirections(CombinedStringParser lines) {
        stub.setDirections(lines);
    }

    public static CombinedStringParser getCcDirections() {
        return stub.getCcDirections();
    }

    public static void setCcDirections(CombinedStringParser cc_lines) {
        stub.setCcDirections(cc_lines);
    }

    //
    // CLAIM
    //
    /**
     * 診療行為の送信を行うかどうかを返す。
     * @return 行うとき true
     */
    public static boolean getSendClaim() {
        return stub.getSendClaim();
    }

    /**
     *
     * @param sendClaim
     */
    public static void setSendClaim(boolean sendClaim) {
        stub.setSendClaim(sendClaim);
    }

    /**
     * 病名の送信を行うかどうかを返す。
     * @return 行うとき true
     */
    public static boolean getSendDiagnosis() {
        return stub.getSendDiagnosis();
    }

    /**
     * CLAIM のホスト名を返す。
     * @return return CLAIM のホスト名
     */
    public static String getClaimHostName() {
        return stub.getClaimHostName();
    }

    public static void setClaimHostName(String claimHostName) {
        stub.setClaimHostName(claimHostName);
    }

    /**
     * 受付情報を受信するかどうかを返す。
     * @return 行うとき true
     */
    public static boolean getUseAsPVTServer() {
        return stub.getUseAsPVTServer();
    }

    public static void setUseAsPVTServer(boolean useAsPVTServer) {
        stub.setUseAsPVTServer(useAsPVTServer);
    }

    //入院か否か
    public static boolean getIsHospital() {
        return stub.getIsHospital();
    }

    /**
     *
     * @param val
     */
    public static void setIsHospital(boolean val) {
        stub.setIsHospital(val);
    }

    public static String getLetterGreetings() {
        return stub.getLetterGreetings();
    }

    public static void setLetterGreetings(String val) {
        stub.setLetterGreetings(val);
    }

    /**
     * CLAIM ホストの IP アドレスを返す。
     * @return CLAIM ホストの IP アドレス
     */
    public static String getClaimAddress() {
        return stub.getClaimAddress();
    }

    public static void setClaimAddress(String claimAddress) {
        stub.setClaimAddress(claimAddress);
    }

    /**
     * CLAIM ホストの診療行為送信先ポート番号を返す。
     * @return CLAIM ホスト名の診療行為送信先ポート番号
     */
    public static int getClaimPort() {
        return stub.getClaimPort();
    }

    public static void setClaimPort(int claimPort) {
        stub.setClaimPort(claimPort);
    }

    /**
     * CLAIM 送信時のXMLエンコーディングを返す。
     * @return CLAIM エンコーディング
     */
    public static String getClaimEncoding() {
        return stub.getClaimEncoding();
    }

    /**
     *
     * @return
     */
    public static String getProxyHost() {
        return stub.getProxyHost();
    }

    public static int getProxyPort() {
        return stub.getProxyPort();
    }

    public static long getLastModify() {
        return stub.getLastModify();
    }

    public static void setLastModify(long val) {
        stub.setLastModify(val);
    }

    /**
     * ProjectFactoryを返す。
     * @return Project毎に異なる部分の情報を生成するためのFactory
     */
    public static AbstractProjectFactory getProjectFactory() {
        return AbstractProjectFactory.getProjectFactory(stub.getName());
    }

    /**
     * 地域連携に参加するかどうかを返す。
     * @return 参加する時 true
     */
    public static boolean getJoinAreaNetwork() {
        return stub.getJoinAreaNetwork();
    }

    public static void setJoinAreaNetwork(boolean join) {
        stub.setJoinAreaNetwork(join);
    }

    public static String getAreaNetworkName() {
        return stub.getAreaNetworkName();
    }

    /**
     *
     * @param areaNetworkName
     */
    public static void setAreaNetworkName(String areaNetworkName) {
        stub.setAreaNetworkName(areaNetworkName);
    }

    /**
     * 地域連携用の施設IDを返す。
     * @return 地域連携で使用する施設ID
     */
    public static String getAreaNetworkFacilityId() {
        return stub.getAreaNetworkFacilityId();
    }

    public static void setAreaNetworkFacilityId(String areaNetworkFacilityId) {
        stub.setAreaNetworkFacilityId(areaNetworkFacilityId);
    }

    /**
     * 地域連携用のCreatorIDを返す。
     * @return 地域連携で使用するCreatorId
     */
    public static String getAreaNetworkCreatorId() {
        return stub.getAreaNetworkCreatorId();
    }

    public static void setAreaNetworkCreatorId(String areaNetworkCreatorId) {
        stub.setAreaNetworkCreatorId(areaNetworkCreatorId);
    }

    /**
     * 地域連携用の患者MasterIdを返す。
     * @return 地域連携で使用する患者MasterId
     */
    public static ID getMasterId(String pid) {
        String fid = stub.getAreaNetworkFacilityId();
        return getProjectFactory().createMasterId(pid, fid);
    }

    /**
     * CLAIM送信に使用する患者MasterIdを返す。
     * 地域連携ルールと異なるため。
     * @param pid
     */
    public static ID getClaimMasterId(String pid) {
        return new ID(pid, "facility", "MML0024");
    }

    public static Object createSaveDialog(Window parent, SaveParams params) {
        return getProjectFactory().createSaveDialog(parent, params);
    }

    /**
     * CSGW(Client Side Gate Way)へのパスを返す。
     */
    public static String getCSGWPath() {
        String uploader = getUploaderIPAddress();
        String share = getUploadShareDirectory();
        String id = stub.getAreaNetworkFacilityId() != null
                ? stub.getAreaNetworkFacilityId()
                : stub.getUserModel().getFacility().getFacilityId();
        return getProjectFactory().createCSGWPath(uploader, share, id);
    }

    // HOT
    public static boolean getSendMML() {
        return stub.getSendMML();
    }

    public static void setSendMML(boolean sendMML) {
        stub.setSendMML(sendMML);
    }

    /**
     *
     * @return
     */
    public static String getMMLVersion() {
        return stub.getMMLVersion();
    }

    /**
     *
     * @param version
     */
    public static void setMMLVersion(String version) {
        stub.setMMLVersion(version);
    }

    public static String getMMLEncoding() {
        return stub.getMMLEncoding();
    }

    public static String getUploaderIPAddress() {
        return stub.getUploaderIPAddress();
    }

    /**
     *
     * @param ipAddress
     */
    public static void setUploaderIPAddress(String ipAddress) {
        stub.setUploaderIPAddress(ipAddress);
    }

    public static String getUploadShareDirectory() {
        return stub.getUploadShareDirectory();
    }

    public static void setUploadShareDirectory(String directory) {
        stub.setUploadShareDirectory(directory);
    }

    public static boolean getShowModifiedKarte() {
        return stub.getShowModifiedKarte();
    }

    public static boolean getShowUnsendKarte() {
        return stub.getShowUnsendKarte();
    }

    public static boolean getShowSendKarte() {
        return stub.getShowSendKarte();
    }

    public static boolean getShowNewestKarte() {
        return stub.getShowNewestKarte();
    }

    /**
     *
     * @return
     */
    public static int getSaveKarteMode() {
        return stub.getSaveKarteMode();
    }

    public static void setSaveKarteMode(int mode) {
        stub.setSaveKarteMode(mode);
    }

    public static int getPrintKarteCount() {
        return stub.getPrintKarteCount();
    }

    public static void setPrintKarteCount(int cnt) {
        stub.setPrintKarteCount(cnt);
    }

    public static String getPDFStore() {
        return stub.getPDFStore();
    }

    public static void setPDFStore(String pdfDir) {
        stub.setPDFStore(pdfDir);
    }

    public static int getFetchKarteCount() {
        return stub.getFetchKarteCount();
    }

    public static boolean getScrollKarteV() {
        return stub.getScrollKarteV();
    }

    public static boolean getAscendingKarte() {
        return stub.getAscendingKarte();
    }

    public static int getKarteExtractionPeriod() {
        return stub.getKarteExtractionPeriod();
    }

    public static boolean getAscendingDiagnosis() {
        return stub.getAscendingDiagnosis();
    }

    public static int getDiagnosisExtractionPeriod() {
        return stub.getDiagnosisExtractionPeriod();
    }

    public static boolean isAutoOutcomeInput() {
        return stub.isAutoOutcomeInput();
    }

    public static int getLaboTestExtractionPeriod() {
        return stub.getLaboTestExtractionPeriod();
    }

    public static boolean isReplaceStamp() {
        return stub.isReplaceStamp();
    }

    public static boolean isStampSpace() {
        return stub.isStampSpace();
    }

    /**
     *
     * @return
     */
    public static boolean isLaboFold() {
        return stub.isLaboFold();
    }

    public static String getDefaultZyozaiNum() {
        return stub.getDefaultZyozaiNum();
    }

    public static String getDefaultMizuyakuNum() {
        return stub.getDefaultMizuyakuNum();
    }

    public static String getDefaultSanyakuNum() {
        return stub.getDefaultSanyakuNum();
    }

    public static String getDefaultRpNum() {
        return stub.getDefaultRpNum();
    }

    public static boolean isUseTop15AsTitle() {
        return stub.isUseTop15AsTitle();
    }

    public static boolean getConfirmAtNew() {
        return stub.getConfirmAtNew();
    }

    public static int getCreateKarteMode() {
        return stub.getCreateKarteMode();
    }

    public static boolean getPlaceKarteMode() {
        return stub.getPlaceKarteMode();
    }

    public static boolean getConfirmAtSave() {
        return stub.getConfirmAtSave();
    }

    public static void setFetchKarteCount(int fetchKarteCount) {
        stub.setFetchKarteCount(fetchKarteCount);
    }

    public static void setScrollKarteV(boolean scrollKarteV) {
        stub.setScrollKarteV(scrollKarteV);
    }

    public static void setAscendingKarte(boolean ascendingKarte) {
        stub.setAscendingKarte(ascendingKarte);
    }

    public static void setKarteExtractionPeriod(int karteExtractionPeriod) {
        stub.setKarteExtractionPeriod(karteExtractionPeriod);
    }

    public static void setShowModifiedKarte(boolean showModifiedKarte) {
        stub.setShowModifiedKarte(showModifiedKarte);
    }

    public static void setShowUnsendKarte(boolean showUnsendKarte) {
        stub.setShowUnsendKarte(showUnsendKarte);
    }

    public static void setShowSendKarte(boolean showSendKarte) {
        stub.setShowSendKarte(showSendKarte);
    }

    /**
     *
     * @param showNewestKarte
     */
    public static void setShowNewestKarte(boolean showNewestKarte) {
        stub.setShowNewestKarte(showNewestKarte);
    }

    public static void setAscendingDiagnosis(boolean ascendingDiagnosis) {
        stub.setAscendingDiagnosis(ascendingDiagnosis);
    }

    /**
     *
     * @param diagnosisExtractionPeriod
     */
    public static void setDiagnosisExtractionPeriod(int diagnosisExtractionPeriod) {
        stub.setDiagnosisExtractionPeriod(diagnosisExtractionPeriod);
    }

    public static void setAutoOutcomeInput(boolean autoOutcomeInput) {
        stub.setAutoOutcomeInput(autoOutcomeInput);
    }

    /**
     *
     * @param laboTestExtractionPeriod
     */
    public static void setLaboTestExtractionPeriod(int laboTestExtractionPeriod) {
        stub.setLaboTestExtractionPeriod(laboTestExtractionPeriod);
    }

    public static void setReplaceStamp(boolean replaceStamp) {
        stub.setReplaceStamp(replaceStamp);
    }

    public static void setStampSpace(boolean stampSpace) {
        stub.setStampSpace(stampSpace);
    }

    public static void setLaboFold(boolean laboFold) {
        stub.setLaboFold(laboFold);
    }

    public static void setDefaultZyozaiNum(String num) {
        stub.setDefaultZyozaiNum(num);
    }

    /**
     *
     * @param num
     */
    public static void setDefaultMizuyakuNum(String num) {
        stub.setDefaultMizuyakuNum(num);
    }

    public static void setDefaultSanyakuNum(String test) {
        stub.setDefaultSanyakuNum(test);
    }

    public static void setDefaultRpNum(String test) {
        stub.setDefaultRpNum(test);
    }

    public static void setUseTop15AsTitle(boolean useTop15AsTitle) {
        stub.setUseTop15AsTitle(useTop15AsTitle);
    }

    public static void setSendDiagnosis(boolean sendDiagnosis) {
        stub.setSendDiagnosis(sendDiagnosis);
    }

    public static void setConfirmAtNew(boolean confirmAtNew) {
        stub.setConfirmAtNew(confirmAtNew);
    }

    public static void setCreateKarteMode(int createKarteMode) {
        stub.setCreateKarteMode(createKarteMode);
    }

    public static void setPlaceKarteMode(boolean placeKarteMode) {
        stub.setPlaceKarteMode(placeKarteMode);
    }

    /**
     *
     * @param confirmAtSave
     */
    public static void setConfirmAtSave(boolean confirmAtSave) {
        stub.setConfirmAtSave(confirmAtSave);
    }

    public static void exportSubtree(OutputStream os) {
        stub.exportSubtree(os);
    }

    public static void clear() {
        stub.clear();
    }

    public static boolean isAdmin() {
        Set<RoleModel> roles = GlobalVariables.getUserModel().getRoles();
        for (RoleModel model : roles) {
            if (model.getRole().equals(GUIConst.ROLE_ADMIN)) {
                return true;
            }
        }
        return false;
    }

    public static String getDefaultKarteTitle() {
        return stub.getDefaultKarteTitle();
    }

    public static void setDefaultKarteTitle(String defaultKarteTitle) {
        stub.setDefaultKarteTitle(defaultKarteTitle);
    }

    // FIXME: weak security
    public static void setSubject(Subject subject) {
        stub.setSubject(subject);
    }

    // FIXME: weak security
    /**
     *
     * @return
     */
    public static Subject getSubject() {
        return stub.getSubject();
    }

    public static String getPreferencesPath() {
        return stub.getPreferencesPath();
    }

    public static void setCharacterCode(int code) {
        stub.setCharacterCode(code);
    }

    public static int getCharacterCode() {
        return stub.getCharacterCode();
    }

    public static boolean getFepControl() {
        return stub.getFepControl();
    }

    public static void setFepControl(boolean value) {
        stub.setFepControl(value);
    }
}
