/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package open.dolphin.utils;

import java.io.IOException;
import java.io.Serializable;

import open.dolphin.project.GlobalConstants;
import org.jdesktop.application.ApplicationContext;

/**
 *
 * @author oda
 */
public class Persistent {

    public static Serializable loadLayout(String klass, String type, Serializable defaultValue) {
        Serializable result = null;
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        try {
            result = (Serializable) appCtx.getLocalStorage().load(klass + "." + type + ".xml");
        } catch (Exception ex) {
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    /**
     *
     * @param klass
     * @param type
     * @param layout
     */
    public static void saveLayout(String klass, String type, Serializable layout) {
        try {
            GlobalConstants.getLocalStorage().save(layout, klass + "." + type + ".xml");
        } catch (IOException ex) {

        }
    }

    public static void deleteLayout(String klass, String type) {
        try {
            GlobalConstants.getLocalStorage().deleteFile(klass + "." + type + ".xml");
        } catch (IOException ex) {

        }
    }
}
