// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef ATB_SCHEDULER_HPP
#define ATB_SCHEDULER_HPP

#include "common/updatable.hpp"
class hero_party_btl;
class enemy_party_btl;
#include "common/general_queue.hpp"
class hero_btl;
class enemy_btl;

class atb_scheduler : public updatable
{
public:
	atb_scheduler();
	virtual ~atb_scheduler();

	void init( hero_party_btl*  hero_party,
	           enemy_party_btl* enemy_party,
	           general_queue< hero_btl*  >* hero_ready_queue,
	           general_queue< enemy_btl* >* enemy_ready_queue );

	virtual bool update();

private:
	hero_party_btl*  hero_party ;
	enemy_party_btl* enemy_party;

	general_queue< hero_btl*  >* hero_ready_queue ;
	general_queue< enemy_btl* >* enemy_ready_queue;
};

#endif // ATB_SCHEDULER_HPP
