// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef CHARACTER_GRAPHIC_BTL_HPP
#define CHARACTER_GRAPHIC_BTL_HPP

#include "graphics/drawable.hpp"
#include "common/util.hpp"
#include "graphics/character_graphic.hpp"

class character_graphic_btl : public drawable
{
public:
	static point battle_position[ 2 ][ 4 ];

	character_graphic_btl();
	character_graphic_btl( character_graphic* base_graphic );
	virtual ~character_graphic_btl();

	virtual void draw()  { this->base_graphic.draw (); }
	        void reset() { this->base_graphic.reset(); }

	character_graphic* get_base_graphic() { return &( this->base_graphic ); }

	void set_base_graphic( character_graphic* base_graphic ) { this->base_graphic = *base_graphic; }

private:
	character_graphic base_graphic;
};

#endif // CHARACTER_GRAPHIC_BTL_HPP
