// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/command_publisher.hpp"
#include "common/general_queue.hpp"
class hero_btl;
class enemy_btl;
class battle_event;
#include "battle/command_window.hpp"

command_publisher::command_publisher()
	: context( nullptr ),
	  hero_ready_queue( nullptr ),
	  enemy_ready_queue( nullptr ),
	  event_queue( nullptr ),
	  hero( nullptr ),
	  enemy( nullptr ),
	  cmd_window( nullptr ),
	  drawer( nullptr )
{
	this->state_dependent_update[ this->initial          ] = &command_publisher::update_initial         ;
	this->state_dependent_update[ this->window_opening   ] = &command_publisher::update_window_opening  ;
	this->state_dependent_update[ this->command_select   ] = &command_publisher::update_command_select  ;
	this->state_dependent_update[ this->command_specific ] = &command_publisher::update_command_specific;
	this->state_dependent_update[ this->window_closing   ] = &command_publisher::update_window_closing  ;

	this->state_dependent_draw[ this->initial          ] = &command_publisher::draw_initial         ;
	this->state_dependent_draw[ this->window_opening   ] = &command_publisher::draw_window_opening  ;
	this->state_dependent_draw[ this->command_select   ] = &command_publisher::draw_command_select  ;
	this->state_dependent_draw[ this->command_specific ] = &command_publisher::draw_command_specific;
	this->state_dependent_draw[ this->window_closing   ] = &command_publisher::draw_window_closing  ;
}

command_publisher::~command_publisher()
{
}

void command_publisher::init()
{
	this->state = this->initial;

	this->hero_ready_queue  = context->get_hero_ready_queue ();
	this->enemy_ready_queue = context->get_enemy_ready_queue();

	this->event_queue = context->get_event_queue();

	this->hero  = nullptr;
	this->enemy = nullptr;

	this->cmd_window = context->get_cmd_window();
}

bool command_publisher::update()
{
	return ( this->*state_dependent_update[ this->state ] )();
}

void command_publisher::draw()
{
	( this->*state_dependent_draw[ this->state ] )();
}

bool command_publisher::update_initial()
{
	if ( this->hero_ready_queue->empty() == false )
	{
		this->hero = this->hero_ready_queue->front();
		this->state = this->window_opening;

		this->drawer->add_to_layer( layered_drawer_btl::window_4, this->cmd_window );
	}
	return true;
}

bool command_publisher::update_window_opening()
{
	return true;
}

bool command_publisher::update_command_select()
{
	return true;
}

bool command_publisher::update_command_specific()
{
	return true;
}

bool command_publisher::update_window_closing()
{
	return true;
}

void command_publisher::draw_initial()
{
}

void command_publisher::draw_window_opening()
{
}

void command_publisher::draw_command_select()
{
}

void command_publisher::draw_command_specific()
{
}

void command_publisher::draw_window_closing()
{
}
