// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef COMMAND_PUBLISHER_HPP
#define COMMAND_PUBLISHER_HPP

#include "common/general_queue.hpp"
class hero_btl;
class enemy_btl;
class battle_event;
class command_window;

class command_publisher
{
public:
	enum state_t
	{
		initial,
		window_opening,
		command_select,
		command_specific,
		window_closing,
		sizeof_state_t,
	};

	command_publisher();
	virtual ~command_publisher();

	void init();

	bool update();
	void draw();

	bool update_initial();
	bool update_window_opening();
	bool update_command_select();
	bool update_command_specific();
	bool update_window_closing();

	void draw_initial();
	void draw_window_opening();
	void draw_command_select();
	void draw_command_specific();
	void draw_window_closing();

	state_t get_state() { return this->state; }
	void set_state( state_t state ) { this->state = state; }

private:
	state_t state;

	bool ( command_publisher::*state_dependent_update[ sizeof_state_t ] )();
	void ( command_publisher::*state_dependent_draw  [ sizeof_state_t ] )();

	general_queue< hero_btl*  >* hero_ready_queue ;
	general_queue< enemy_btl* >* enemy_ready_queue;

	general_queue< battle_event* >* event_queue;

	hero_btl*  hero ;
	enemy_btl* enemy;

	command_window* cmd_window;
};

#endif // COMMAND_PUBLISHER_HPP
