// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef ENEMY_PARTY_BTL_HPP
#define ENEMY_PARTY_BTL_HPP

#include "battle/party_btl.hpp"
class enemy_btl;
#include <cstddef>
class battle_joiner;
#include "common/character_id.hpp"

class enemy_party_btl : public party_btl
{
public:
	typedef enemy_btl**        iterator;
	typedef enemy_btl* const * const_iterator;

	enemy_party_btl();
	enemy_party_btl( battle_joiner* members[], std::size_t size );
	virtual ~enemy_party_btl();

	iterator       begin()       { return this->current_enemies; }
	const_iterator begin() const { return this->current_enemies; }
	iterator       end  ()       { return this->current_enemies + this->party_btl::current_size; }
	const_iterator end  () const { return this->current_enemies + this->party_btl::current_size; }

	int                   get_ordering( character_id::enemy_t enemy_id );
	character_id::enemy_t get_enemy_id( std::size_t           ordering );

private:
	enemy_btl** current_enemies;
	enemy_btl** initial_enemies;
};

#endif // ENEMY_PARTY_BTL_HPP
