// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/layered_updater_btl.hpp"
#include "common/updatable.hpp"
#include <cassert>

layered_updater_btl::layered_updater_btl()
{
	this->layers[ this->fully_exclusive ] = &( this->fully_exclusive_ );
	this->layers[ this->system          ] = &( this->system_          );
	this->layers[ this->event_exclusive ] = &( this->event_exclusive_ );

	this->layers[ this->event_0 ] = &( this->event_0_ );
	this->layers[ this->event_1 ] = &( this->event_1_ );
	this->layers[ this->event_2 ] = &( this->event_2_ );

	this->layers[ this->top     ] = &( this->top_     );
	this->layers[ this->hero    ] = &( this->hero_    );
	this->layers[ this->middle  ] = &( this->middle_  );
	this->layers[ this->enemy   ] = &( this->enemy_   );
	this->layers[ this->bottom  ] = &( this->bottom_  );

	this->layers[ this->event_3 ] = &( this->event_3_ );
	this->layers[ this->event_4 ] = &( this->event_4_ );
	this->layers[ this->event_5 ] = &( this->event_5_ );

	this->clear();
}

layered_updater_btl::~layered_updater_btl()
{
}

void layered_updater_btl::clear()
{
	updatable* ( *layer )[ capacity ] = nullptr;

	for ( int i = 0 ; i < this->sizeof_layer_t ; ++i )
	{
		layer = this->layers[ i ];

		for ( int j = 0 ; j < this->capacity ; ++j )
		{
			( *layer )[ j ] = nullptr;
		}

		this->layer_enabled[ i ] = true;
	}
}

void layered_updater_btl::update()
{
	updatable* ( *layer )[ capacity ] = nullptr;

	for ( int i = 0 ; i < this->event_0 ; ++i )
	{
		if ( this->layer_enabled[ i ] == false )
		{
			continue;
		}

		layer = this->layers[ i ];

		for ( int j = 0 ; j < this->capacity ; ++j )
		{
			if ( ( *layer )[ j ] != nullptr )
			{
				( *layer )[ j ]->update();

				if ( i == this->fully_exclusive )
				{
					return;
				}

				if ( i == this->event_exclusive )
				{
					this->update_joiner();
					return;
				}
			}
		}
	}

	for ( int i = this->event_0 ; i < this->sizeof_layer_t ; ++i )
	{
		if ( this->layer_enabled[ i ] == false )
		{
			continue;
		}

		layer = this->layers[ i ];

		for ( int j = 0 ; j < this->capacity ; ++j )
		{
			if ( ( *layer )[ j ] != nullptr )
			{
				( *layer )[ j ]->update();
			}
		}
	}
}

void layered_updater_btl::update_joiner()
{
	updatable* ( *layer )[ capacity ] = nullptr;

	for ( int i = this->top ; i < this->event_3 ; ++i )
	{
		if ( this->layer_enabled[ i ] == false )
		{
			continue;
		}

		layer = this->layers[ i ];

		for ( int j = 0 ; j < this->capacity ; ++j )
		{
			if ( ( *layer )[ j ] != nullptr )
			{
				( *layer )[ j ]->update();
			}
		}
	}
}

void layered_updater_btl::add_to_layer( layer_t l, updatable* u )
{
	updatable* ( *layer )[ capacity ] = this->layers[ l ];

	for ( int i = 0 ; i < this->capacity ; ++i )
	{
		if ( ( *layer )[ i ] == nullptr )
		{
			( *layer )[ i ] = u;
			return;
		}
	}
	assert( 0 );
}

void layered_updater_btl::remove_from_layer( layer_t l, updatable* u )
{
	updatable* ( *layer )[ capacity ] = this->layers[ l ];

	for ( int i = 0 ; i < this->capacity ; ++i )
	{
		if ( ( *layer )[ i ] == u )
		{
			( *layer )[ i ] = nullptr;
		}
	}
}
