// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef LAYERED_UPDATER_BTL_HPP
#define LAYERED_UPDATER_BTL_HPP

class updatable;

class layered_updater_btl
{
public:
	enum layer_t
	{
		fully_exclusive,
		system,
		event_exclusive,
		event_0,
		event_1,
		event_2,
		top,
		hero,
		middle,
		enemy,
		bottom,
		event_3,
		event_4,
		event_5,
		sizeof_layer_t,
		invalid_layer = -1,
	};

	layered_updater_btl();
	virtual ~layered_updater_btl();

	void clear();

	void update();
	void update_joiner();

	void add_to_layer     ( layer_t l, updatable* u );
	void remove_from_layer( layer_t l, updatable* u );

	bool is_layer_enabled ( layer_t l ) { return this->layer_enabled[ l ]; }
	void set_layer_enabled( layer_t l, bool layer_enabled ) { this->layer_enabled[ l ] = layer_enabled; }

private:
	enum { capacity = 10 };

	updatable* fully_exclusive_[ capacity ];
	updatable* system_         [ capacity ];
	updatable* event_exclusive_[ capacity ];

	updatable* event_0_[ capacity ];
	updatable* event_1_[ capacity ];
	updatable* event_2_[ capacity ];

	updatable* top_    [ capacity ];
	updatable* hero_   [ capacity ];
	updatable* middle_ [ capacity ];
	updatable* enemy_  [ capacity ];
	updatable* bottom_ [ capacity ];

	updatable* event_3_[ capacity ];
	updatable* event_4_[ capacity ];
	updatable* event_5_[ capacity ];

	updatable* ( *layers[ sizeof_layer_t ] )[ capacity ];

	bool layer_enabled[ sizeof_layer_t ];
};

#endif // LAYERED_UPDATER_BTL_HPP
