// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "common/character_id.hpp"

character_id::character_id()
	: category_( character_id::unknown ),
	  hero_id( character_id::invalid_hero ),
	  enemy_id( character_id::invalid_enemy )
{
}

character_id::character_id( hero_t hero_id )
	: category_( character_id::hero ),
	  hero_id( hero_id ),
	  enemy_id( character_id::invalid_enemy )
{
}

character_id::character_id( enemy_t enemy_id )
	: category_( character_id::enemy ),
	  hero_id( character_id::invalid_hero ),
	  enemy_id( enemy_id )
{
}

character_id::~character_id()
{
}

void character_id::init( hero_t hero_id )
{
	this->category_ = character_id::hero         ;
	this->hero_id   = hero_id                    ;
	this->enemy_id  = character_id::invalid_enemy;
}

void character_id::init( enemy_t enemy_id )
{
	this->category_ = character_id::enemy       ;
	this->hero_id   = character_id::invalid_hero;
	this->enemy_id  = enemy_id                  ;
}
