// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef CHARACTER_GRAPHIC_HPP
#define CHARACTER_GRAPHIC_HPP

#include "graphics/image.hpp"
#include "common/util.hpp"
class sprite;

class character_graphic
{
public:
	enum graphic_style
	{
		use_image,
		use_sprite,
		unknown = -1,
		invalid_style = -1
	};

	enum char_chip
	{
		looking_down_0,
		looking_down_1,
		looking_down_2,
		looking_down_3,
		looking_left_0,
		looking_left_1,
		looking_left_2,
		looking_left_3,
		looking_up_0,
		looking_up_1,
		looking_up_2,
		looking_up_3,
		looking_right_0,
		looking_right_1,
		looking_right_2,
		looking_right_3,
		battle_default = looking_left_1,
		dungeon_default = looking_down_1,
		world_map_default = looking_down_1
	};

	character_graphic();
	character_graphic( image* base_image, point base_position );
	character_graphic( sprite* base_sprite, int base_index, point base_position );
	virtual ~character_graphic();

	void init( image* base_image, point base_position );
	void init( sprite* base_sprite, int base_index, point base_position );

	void reset();

	void draw();

	void set_graphic_using_sprite( int index );
	void set_graphic_using_sprite( int x_chip, int y_chip );

	graphic_style get_style        () { return this->style        ; }
	image*        get_graphic      () { return &( this->graphic ) ; }
	point         get_position     () { return this->position     ; }
	image*        get_base_image   () { return this->base_image   ; }
	sprite*       get_base_sprite  () { return this->base_sprite  ; }
	int           get_base_index   () { return this->base_index   ; }
	point         get_base_position() { return this->base_position; }

	void set_style        ( graphic_style style         ) { this->style         = style        ; }
	void set_graphic      ( image*        graphic       ) { this->graphic       = *graphic     ; }
	void set_position     ( point         position      ) { this->position      = position     ; }
	void set_base_image   ( image*        base_image    ) { this->base_image    = base_image   ; }
	void set_base_sprite  ( sprite*       base_sprite   ) { this->base_sprite   = base_sprite  ; }
	void get_base_index   ( int           base_index    ) { this->base_index    = base_index   ; }
	void set_base_position( point         base_position ) { this->base_position = base_position; }

private:
	graphic_style style;

	image graphic;
	point position;

	image* base_image;

	sprite* base_sprite;
	int base_index;

	point base_position;
};

#endif // CHARACTER_GRAPHIC_HPP
