// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef IMAGE_LOOKUP_HPP
#define IMAGE_LOOKUP_HPP

#include "common/character_id.hpp"
#include "graphics/image.hpp"
#include "graphics/sprite.hpp"

class image_lookup
{
public:
	enum image_t
	{
		window_background,
		battle_background_plain,
		atb_gauge,
		sizeof_image_t,
	};

	enum sprite_t
	{
		window_frame,
		dino_char_chips,
		milia_char_chips,
		maria_char_chips,
		jay_char_chips,
		sizeof_sprite_t,
	};

	static sprite_t hero_to_sprite[ character_id::sizeof_hero_t ];

	static image_lookup* instance();

	image* get_image( image_t image_id );
	sprite* get_sprite( sprite_t sprite_id );

private:
	image images[ sizeof_image_t ];
	sprite sprites[ sizeof_sprite_t ];

	void ( image_lookup::*load_image [ sizeof_image_t  ] )();
	void ( image_lookup::*load_sprite[ sizeof_sprite_t ] )();

	void load_image_window_background();
	void load_image_battle_background_plain();
	void load_image_atb_gauge();

	void load_sprite_window_frame();
	void load_sprite_dino_char_chips();
	void load_sprite_milia_char_chips();
	void load_sprite_maria_char_chips();
	void load_sprite_jay_char_chips();

	image_lookup();
	virtual ~image_lookup();

	image_lookup( const image_lookup& );
	image_lookup& operator=( const image_lookup& );

	image_lookup( image_lookup&& );
	image_lookup& operator=( image_lookup&& );
};

#endif // IMAGE_LOOKUP_HPP
