// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "system_top/system_builder.hpp"
#include "system_top/main_loop.hpp"
#include <exception>
#include <iostream>

#if defined(_WIN32) && defined(_WINDOWS)

#include <windows.h>

// WIN32vÕGg|Cg
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nShowCmd ) try
{
	system_builder* sb = system_builder::instance();
	main_loop* ml = sb->initialize_system();
	ml->enter_main_loop();

	sb->finalize_system();
	return 0;
}
catch ( std::exception& e )
{
	std::cerr << e.what() << std::endl;
	return 1;
}

#else

// vÕGg|Cg
int main( int argc, char* argv[] ) try
{
	system_builder* sb = system_builder::instance();
	main_loop* ml = sb->initialize_system();
	ml->enter_main_loop();

	sb->finalize_system();
	return 0;
}
catch ( std::exception& e )
{
	std::cerr << e.what() << std::endl;
	return 1;
}

#endif // _WIN32 && _WINDOWS
