// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "base_system/sdl_driver.hpp"

#if defined(__linux__)

#include <iostream>
#include <SDL.h>
#include <SDL_image.h>
#include <SDL_ttf.h>

namespace base_system {

sdl_driver::sdl_driver()
	: screen( NULL ),
	  joystick( NULL ),
	  core_available( this->core_init() ),
	  joystick_available( this->joystick_open() ),
	  image_available( this->image_init() ),
	  ttf_available( this->ttf_init() )
{
	std::cout << "sdl_driver()" << std::endl;
}

sdl_driver::~sdl_driver()
{
	std::cout << "~sdl_driver()" << std::endl;

	// SDL̃RA@\ĂȂ΁AI
	if ( this->core_available )
		this->core_quit();

	// joystick I[vĂȂ΁AN[Y
	if ( this->joystick_available )
		this->joystick_close();

	// SDL_image ĂȂ΁AI
	if ( this->image_available )
		this->image_quit();

	// SDL_ttf ĂȂ΁AI
	if ( this->ttf_available )
		this->ttf_quit();
}

void sdl_driver::print_joystick_property()
{
	// ڑĂQ[pbh̐
	int n = ::SDL_NumJoysticks();
	std::cout << "# of joysticks: " << n << std::endl;

	// ڑĂQ[pbh̖O
	for ( int i = 0 ; i < n ; i++ )
	{
		std::cout << "name of #" << i << " joystick: " << ::SDL_JoystickName( i ) << std::endl;
	}

	if ( ::SDL_JoystickOpened( 0 ) )
	{
		std::cout << "# of #0 joystick axes: " << ::SDL_JoystickNumAxes( this->joystick ) << std::endl;

		std::cout << "# of #0 joystick trackballs: " << ::SDL_JoystickNumBalls( this->joystick ) << std::endl;

		std::cout << "# of #0 joystick hats: " << ::SDL_JoystickNumHats( this->joystick ) << std::endl;

		std::cout << "# of #0 joystick buttons: " << ::SDL_JoystickNumButtons( this->joystick ) << std::endl;
	}
}

::SDL_Surface* sdl_driver::get_screen()
{
	return this->screen;
}

::SDL_Joystick* sdl_driver::get_joystick()
{
	return this->joystick;
}

bool sdl_driver::core_init()
{
	// SDL
	if ( ::SDL_Init( SDL_INIT_TIMER
					 | SDL_INIT_AUDIO
					 | SDL_INIT_VIDEO
					 | SDL_INIT_JOYSTICK ) == -1 )
	{
		std::cerr << "SDL_Init: " << ::SDL_GetError() << std::endl;
		return false;
	}

	// screen 擾
	this->screen = ::SDL_SetVideoMode( 640, 480,
									   8,
//									   SDL_HWSURFACE | SDL_DOUBLEBUF );
									   SDL_SWSURFACE );
	if ( this->screen == NULL )
	{
		std::cerr << "SDL_SetVideoMode: " << ::SDL_GetError() << std::endl;

		// screen 擾ɎŝŁASDLI
		::SDL_Quit();

		return false;
	}

	//if ( this->screen == ::SDL_GetVideoSurface() )
	//	std::cout << "**********" << std::endl;

	return true;
}

void sdl_driver::core_quit()
{
	// SDLI
	::SDL_Quit();
}

bool sdl_driver::joystick_open()
{
	// Q[pbhڑĂȂ΁Â܂܋UԂ
	if ( ::SDL_NumJoysticks() == 0 )
		return false;

	// joystick I[v
	this->joystick = ::SDL_JoystickOpen( 0 );

	if ( this->joystick == NULL )
	{
		std::cerr << "SDL_JoystickOpen: " << ::SDL_GetError() << std::endl;
		return false;
	}

	// joystick ɊւCxg input_handler ň悤ɂ
	::SDL_JoystickEventState( SDL_ENABLE );

	return true;
}

void sdl_driver::joystick_close()
{
	// joystick I[vĂȂ΁AN[Y
	if ( ::SDL_JoystickOpened( 0 ) )
		::SDL_JoystickClose( this->joystick );
}

bool sdl_driver::image_init()
{
	// SDL_image 
	int flags = IMG_INIT_JPG | IMG_INIT_PNG;
	int initted = ::IMG_Init( flags );

	if ( initted & flags != flags )
	{
		std::cerr << "IMG_Init: Failed to init required jpg and png support!" << std::endl;
		std::cerr << "IMG_Init: " << ::IMG_GetError() << std::endl;
		return false;
	}

	return true;
}

void sdl_driver::image_quit()
{
	// SDL_image I
	::IMG_Quit();
}

bool sdl_driver::ttf_init()
{
	// SDL_ttf 
	if ( ::TTF_Init() == -1 )
	{
		std::cerr << "TTF_Init: " << ::TTF_GetError() << std::endl;
		return false;
	}

	return true;
}

void sdl_driver::ttf_quit()
{
	// SDL_ttf I
	::TTF_Quit();
}

} // namespace base_system

#endif // __linux__
