/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc4;

import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.postgresql.Driver;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc2.AbstractJdbc2Array;
import org.postgresql.jdbc3g.AbstractJdbc3gConnection;
import org.postgresql.jdbc4.Jdbc4Array;
import org.postgresql.jdbc4.Jdbc4SQLXML;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

abstract class AbstractJdbc4Connection
extends AbstractJdbc3gConnection {
    Properties _clientInfo;

    public AbstractJdbc4Connection(String host, int port, String user, String database, Properties info, String url) throws SQLException {
        super(host, port, user, database, info, url);
        TypeInfo types = this.getTypeInfo();
        if (this.haveMinimumServerVersion("8.3")) {
            types.addCoreType("xml", 142, 2009, "java.sql.SQLXML", 143);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "createClob()");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "createBlob()");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return new Jdbc4SQLXML(this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "createStruct(String, Object[])");
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        int oid = this.getTypeInfo().getPGArrayType(typeName);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unable to find server array type for provided name {0}.", typeName), PSQLState.INVALID_NAME);
        }
        StringBuffer sb = new StringBuffer();
        AbstractJdbc4Connection.appendArray(sb, elements);
        return new Jdbc4Array(this, oid, sb.toString());
    }

    private static void appendArray(StringBuffer sb, Object elements) {
        sb.append('{');
        int nElements = Array.getLength(elements);
        for (int i = 0; i < nElements; ++i) {
            Object o;
            if (i > 0) {
                sb.append(',');
            }
            if ((o = Array.get(elements, i)) == null) {
                sb.append("NULL");
                continue;
            }
            if (o.getClass().isArray()) {
                AbstractJdbc4Connection.appendArray(sb, o);
                continue;
            }
            String s = o.toString();
            AbstractJdbc2Array.escapeArrayElement(sb, s);
        }
        sb.append('}');
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "isValid(int)");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
        failures.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        throw new SQLClientInfoException(GT.tr("ClientInfo property not supported."), failures);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (properties == null || properties.size() == 0) {
            return;
        }
        HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
        Iterator<String> i = properties.stringPropertyNames().iterator();
        while (i.hasNext()) {
            failures.put(i.next(), ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        }
        throw new SQLClientInfoException(GT.tr("ClientInfo property not supported."), failures);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this._clientInfo == null) {
            this._clientInfo = new Properties();
        }
        return this._clientInfo;
    }

    public <T> T createQueryObject(Class<T> ifc) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "createQueryObject(Class<T>)");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "isWrapperFor(Class<?>)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "unwrap(Class<T>)");
    }
}

