/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;

public class Delete
extends Prepared {
    private Expression condition;
    private TableFilter tableFilter;

    public Delete(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() throws SQLException {
        this.tableFilter.startQuery(this.session);
        this.tableFilter.reset();
        Table table = this.tableFilter.getTable();
        this.session.getUser().checkRight(table, 2);
        table.fireBefore(this.session);
        table.lock(this.session, true, false);
        RowList rowList = new RowList(this.session);
        try {
            Row row;
            this.setCurrentRowNumber(0);
            while (this.tableFilter.next()) {
                this.setCurrentRowNumber(rowList.size() + 1);
                if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
                Row row2 = this.tableFilter.get();
                if (table.fireRow()) {
                    table.fireBeforeRow(this.session, row2, null);
                }
                rowList.add(row2);
            }
            int n = 0;
            rowList.reset();
            while (rowList.hasNext()) {
                if ((n++ & 0x7F) == 0) {
                    this.checkCanceled();
                }
                row = rowList.next();
                table.removeRow(this.session, row);
                this.session.log(table, (short)1, row);
            }
            if (table.fireRow()) {
                rowList.reset();
                while (rowList.hasNext()) {
                    row = rowList.next();
                    table.fireAfterRow(this.session, row, null);
                }
            }
            table.fireAfter(this.session);
            int n2 = rowList.size();
            return n2;
        }
        finally {
            rowList.close();
        }
    }

    public String getPlanSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ").append(this.tableFilter.getPlanSQL(false));
        if (this.condition != null) {
            stringBuilder.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        return stringBuilder.toString();
    }

    public void prepare() throws SQLException {
        if (this.condition != null) {
            this.condition.mapColumns(this.tableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.tableFilter);
        }
        PlanItem planItem = this.tableFilter.getBestPlanItem(this.session);
        this.tableFilter.setPlanItem(planItem);
        this.tableFilter.prepare();
    }

    public boolean isTransactional() {
        return true;
    }

    public LocalResult queryMeta() {
        return null;
    }
}

