/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.fulltext.IndexInfo;
import org.h2.util.New;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FullTextSettings {
    private static final HashMap<String, FullTextSettings> SETTINGS = New.hashMap();
    private boolean initialized;
    private HashSet<String> ignoreList = New.hashSet();
    private HashMap<String, Integer> words = New.hashMap();
    private HashMap<Integer, IndexInfo> indexes = New.hashMap();
    private PreparedStatement prepSelectMapByWordId;
    private PreparedStatement prepSelectRowById;

    private FullTextSettings() {
    }

    HashSet<String> getIgnoreList() {
        return this.ignoreList;
    }

    HashMap<String, Integer> getWordList() {
        return this.words;
    }

    IndexInfo getIndexInfo(int n) {
        return this.indexes.get(n);
    }

    void addIndexInfo(IndexInfo indexInfo) {
        this.indexes.put(indexInfo.id, indexInfo);
    }

    String convertWord(String string) {
        if (this.ignoreList.contains(string = string.toUpperCase())) {
            return null;
        }
        return string;
    }

    static FullTextSettings getInstance(Connection connection) throws SQLException {
        String string = FullTextSettings.getIndexPath(connection);
        FullTextSettings fullTextSettings = SETTINGS.get(string);
        if (fullTextSettings == null) {
            fullTextSettings = new FullTextSettings();
            SETTINGS.put(string, fullTextSettings);
        }
        return fullTextSettings;
    }

    private static String getIndexPath(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("CALL IFNULL(DATABASE_PATH(), 'MEM:' || DATABASE())");
        resultSet.next();
        String string = resultSet.getString(1);
        if ("MEM:UNNAMED".equals(string)) {
            throw new SQLException("FULLTEXT", "Fulltext search for private (unnamed) in-memory databases is not supported.");
        }
        resultSet.close();
        return string;
    }

    PreparedStatement getPrepSelectMapByWordId() {
        return this.prepSelectMapByWordId;
    }

    void setPrepSelectMapByWordId(PreparedStatement preparedStatement) {
        this.prepSelectMapByWordId = preparedStatement;
    }

    PreparedStatement getPrepSelectRowById() {
        return this.prepSelectRowById;
    }

    void setPrepSelectRowById(PreparedStatement preparedStatement) {
        this.prepSelectRowById = preparedStatement;
    }

    void removeAllIndexes() {
        this.indexes.clear();
    }

    void removeIndexInfo(IndexInfo indexInfo) {
        this.indexes.remove(indexInfo.id);
    }

    void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    boolean isInitialized() {
        return this.initialized;
    }
}

