/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.lang.ref.SoftReference;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.index.PageScanCursor;
import org.h2.index.PageScanIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.DataPage;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageDataLeaf
extends PageData {
    private static final int KEY_OFFSET_PAIR_LENGTH = 6;
    private static final int KEY_OFFSET_PAIR_START = 11;
    private int[] offsets;
    private Row[] rows;
    private SoftReference<Row> rowRef;
    private int firstOverflowPageId;
    private int start = 11;
    private int overflowRowSize;

    PageDataLeaf(PageScanIndex pageScanIndex, int n, Data data) {
        super(pageScanIndex, n, data);
    }

    public static Page read(PageScanIndex pageScanIndex, Data data, int n) throws SQLException {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(pageScanIndex, n, data);
        pageDataLeaf.read();
        return pageDataLeaf;
    }

    private void read() throws SQLException {
        this.data.reset();
        this.parentPageId = this.data.readInt();
        int n = this.data.readByte();
        int n2 = this.data.readInt();
        if (n2 != this.index.getId()) {
            throw Message.getSQLException(90030, "page:" + this.getPos() + " expected table:" + this.index.getId() + " got:" + n2 + " type:" + n);
        }
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.keys = new int[this.entryCount];
        this.rows = new Row[this.entryCount];
        if (n == 1) {
            this.firstOverflowPageId = this.data.readInt();
        }
        for (int i = 0; i < this.entryCount; ++i) {
            this.keys[i] = this.data.readInt();
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
    }

    int addRowTry(Row row) throws SQLException {
        int n;
        int n2;
        int n3;
        int n4 = row.getByteCount(this.data);
        int n5 = this.index.getPageStore().getPageSize();
        int n6 = n3 = this.entryCount == 0 ? n5 : this.offsets[this.entryCount - 1];
        if (this.entryCount > 0 && n3 - n4 < this.start + 6) {
            return this.find(row.getPos());
        }
        int n7 = n3 - n4;
        int[] nArray = new int[this.entryCount + 1];
        int[] nArray2 = new int[this.entryCount + 1];
        Row[] rowArray = new Row[this.entryCount + 1];
        if (this.entryCount == 0) {
            n2 = 0;
        } else {
            this.readAllRows();
            n2 = this.find(row.getPos());
            if (SysProperties.CHECK && n2 < this.keys.length && this.keys[n2] == row.getPos()) {
                throw Message.throwInternalError("" + row.getPos());
            }
            System.arraycopy(this.offsets, 0, nArray, 0, n2);
            System.arraycopy(this.keys, 0, nArray2, 0, n2);
            System.arraycopy(this.rows, 0, rowArray, 0, n2);
            if (n2 < this.entryCount) {
                for (n = n2; n < this.entryCount; ++n) {
                    nArray[n + 1] = this.offsets[n] - n4;
                }
                System.arraycopy(this.keys, n2, nArray2, n2 + 1, this.entryCount - n2);
                System.arraycopy(this.rows, n2, rowArray, n2 + 1, this.entryCount - n2);
            }
        }
        this.written = false;
        n3 = n2 == 0 ? n5 : this.offsets[n2 - 1];
        n7 = n3 - n4;
        ++this.entryCount;
        this.start += 6;
        nArray[n2] = n7;
        nArray2[n2] = row.getPos();
        rowArray[n2] = row;
        this.offsets = nArray;
        this.keys = nArray2;
        this.rows = rowArray;
        this.index.getPageStore().updateRecord(this, true, this.data);
        if (n7 < this.start) {
            int n8;
            int n9;
            if (this.entryCount > 1) {
                Message.throwInternalError();
            }
            this.start += 4;
            n = n4 - (n5 - this.start);
            this.offsets[n2] = n7 = this.start;
            int n10 = this.getPos();
            int n11 = n5;
            this.firstOverflowPageId = n9 = this.index.getPageStore().allocatePage();
            this.overflowRowSize = n5 + n4;
            this.write();
            this.rowRef = new SoftReference<Row>(this.rows[0]);
            this.rows[0] = null;
            do {
                int n12;
                int n13;
                if (n <= n5 - 11) {
                    n13 = 19;
                    n8 = n;
                    n12 = 0;
                } else {
                    n13 = 3;
                    n8 = n5 - 13;
                    n12 = this.index.getPageStore().allocatePage();
                }
                PageDataOverflow pageDataOverflow = new PageDataOverflow(this.index, n9, n13, n10, n12, this.data, n11, n8);
                this.index.getPageStore().updateRecord(pageDataOverflow, true, null);
                n11 += n8;
                n10 = n9;
                n9 = n12;
            } while ((n -= n8) > 0);
            this.data.truncate(this.index.getPageStore().getPageSize());
        }
        return -1;
    }

    private void removeRow(int n) throws SQLException {
        this.written = false;
        this.readAllRows();
        --this.entryCount;
        if (this.entryCount < 0) {
            Message.throwInternalError();
        }
        int[] nArray = new int[this.entryCount];
        int[] nArray2 = new int[this.entryCount];
        Row[] rowArray = new Row[this.entryCount];
        System.arraycopy(this.offsets, 0, nArray, 0, n);
        System.arraycopy(this.keys, 0, nArray2, 0, n);
        System.arraycopy(this.rows, 0, rowArray, 0, n);
        int n2 = n > 0 ? this.offsets[n - 1] : this.index.getPageStore().getPageSize();
        int n3 = n2 - this.offsets[n];
        for (int i = n; i < this.entryCount; ++i) {
            nArray[i] = this.offsets[i + 1] + n3;
        }
        System.arraycopy(this.keys, n + 1, nArray2, n, this.entryCount - n);
        System.arraycopy(this.rows, n + 1, rowArray, n, this.entryCount - n);
        this.start -= 6;
        this.offsets = nArray;
        this.keys = nArray2;
        this.rows = rowArray;
    }

    Cursor find(Session session) {
        return new PageScanCursor(session, this, 0, this.index.isMultiVersion);
    }

    Row getRowAt(int n) throws SQLException {
        Row row = this.rows[n];
        if (row == null) {
            if (this.firstOverflowPageId != 0) {
                PageDataOverflow pageDataOverflow;
                if (this.rowRef != null && (row = this.rowRef.get()) != null) {
                    return row;
                }
                PageStore pageStore = this.index.getPageStore();
                int n2 = pageStore.getPageSize();
                this.data.setPos(n2);
                int n3 = this.firstOverflowPageId;
                while ((n3 = (pageDataOverflow = this.index.getPageOverflow(n3)).readInto(this.data)) != 0) {
                }
                this.overflowRowSize = this.data.length();
            }
            this.data.setPos(this.offsets[n]);
            row = this.index.readRow(this.data);
            row.setPos(this.keys[n]);
            if (this.firstOverflowPageId != 0) {
                this.rowRef = new SoftReference<Row>(row);
            } else {
                this.rows[n] = row;
            }
        }
        return row;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    PageData split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageDataLeaf pageDataLeaf = new PageDataLeaf(this.index, n2, this.index.getPageStore().createData());
        pageDataLeaf.parentPageId = this.parentPageId;
        int n3 = n;
        while (n3 < this.entryCount) {
            pageDataLeaf.addRowTry(this.getRowAt(n));
            this.removeRow(n);
        }
        return pageDataLeaf;
    }

    int getLastKey() throws SQLException {
        if (this.entryCount == 0) {
            return 0;
        }
        return this.getRowAt(this.entryCount - 1).getPos();
    }

    PageDataLeaf getNextPage() throws SQLException {
        if (this.parentPageId == 0) {
            return null;
        }
        PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId, -1);
        return pageDataNode.getNextPage(this.keys[this.entryCount - 1]);
    }

    PageDataLeaf getFirstLeaf() {
        return this;
    }

    protected void remapChildren() throws SQLException {
        if (this.firstOverflowPageId == 0) {
            return;
        }
        PageDataOverflow pageDataOverflow = this.index.getPageOverflow(this.firstOverflowPageId);
        pageDataOverflow.setParentPageId(this.getPos());
        this.index.getPageStore().updateRecord(pageDataOverflow, true, null);
    }

    boolean remove(int n) throws SQLException {
        int n2 = this.find(n);
        if (this.keys[n2] != n) {
            throw Message.getSQLException(90112, this.index.getSQL() + ": " + n);
        }
        if (this.entryCount == 1) {
            this.freeChildren();
            return true;
        }
        this.removeRow(n2);
        this.index.getPageStore().updateRecord(this, true, this.data);
        return false;
    }

    void freeChildren() throws SQLException {
        if (this.firstOverflowPageId != 0) {
            PageDataOverflow pageDataOverflow;
            PageStore pageStore = this.index.getPageStore();
            int n = this.firstOverflowPageId;
            do {
                pageDataOverflow = this.index.getPageOverflow(n);
                pageStore.freePage(n, false, null);
            } while ((n = pageDataOverflow.getNextOverflow()) != 0);
        }
    }

    Row getRow(int n) throws SQLException {
        int n2 = this.find(n);
        return this.getRowAt(n2);
    }

    int getRowCount() {
        return this.entryCount;
    }

    void setRowCountStored(int n) {
    }

    public int getByteCount(DataPage dataPage) {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.write();
        this.index.getPageStore().writePage(this.getPos(), this.data);
        this.data.truncate(this.index.getPageStore().getPageSize());
    }

    private void readAllRows() throws SQLException {
        for (int i = 0; i < this.entryCount; ++i) {
            this.getRowAt(i);
        }
    }

    private void write() throws SQLException {
        int n;
        if (this.written) {
            return;
        }
        this.readAllRows();
        this.data.reset();
        this.data.checkCapacity(this.overflowRowSize);
        this.data.writeInt(this.parentPageId);
        int n2 = this.firstOverflowPageId == 0 ? 17 : 1;
        this.data.writeByte((byte)n2);
        this.data.writeInt(this.index.getId());
        this.data.writeShortInt(this.entryCount);
        if (this.firstOverflowPageId != 0) {
            this.data.writeInt(this.firstOverflowPageId);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeInt(this.keys[n]);
            this.data.writeShortInt(this.offsets[n]);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.setPos(this.offsets[n]);
            this.getRowAt(n).write(this.data);
        }
        this.written = true;
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf table:" + this.index.getId() + " entries:" + this.entryCount + " parent:" + this.parentPageId + (this.firstOverflowPageId == 0 ? "" : " overflow:" + this.firstOverflowPageId);
    }

    public void moveTo(Session session, int n) throws SQLException {
        PageStore pageStore = this.index.getPageStore();
        PageDataLeaf pageDataLeaf = new PageDataLeaf(this.index, n, pageStore.createData());
        this.readAllRows();
        pageDataLeaf.keys = this.keys;
        pageDataLeaf.overflowRowSize = this.overflowRowSize;
        pageDataLeaf.firstOverflowPageId = this.firstOverflowPageId;
        pageDataLeaf.rowRef = this.rowRef;
        pageDataLeaf.rows = this.rows;
        pageDataLeaf.entryCount = this.entryCount;
        pageDataLeaf.offsets = this.offsets;
        pageDataLeaf.parentPageId = this.parentPageId;
        pageDataLeaf.start = this.start;
        pageStore.updateRecord(pageDataLeaf, false, null);
        pageDataLeaf.remapChildren();
        pageStore.freePage(this.getPos(), true, this.data);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n);
        } else {
            PageDataNode pageDataNode = (PageDataNode)pageStore.getPage(this.parentPageId);
            pageDataNode.moveChild(this.getPos(), n);
        }
    }

    void setOverflow(int n) throws SQLException {
        this.written = false;
        this.firstOverflowPageId = n;
        this.index.getPageStore().updateRecord(this, true, this.data);
    }
}

